/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.support;

import java.io.File;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryMonitor {
    private static final Logger log = LoggerFactory.getLogger(DirectoryMonitor.class);
    private final FileAlterationMonitor monitor;
    private final File siteDir;

    DirectoryMonitor(File siteDir, int interval, FileAlterationListener listener) {
        this.siteDir = siteDir;
        long intervalMillis = interval * 1000;
        if (intervalMillis < 1000L) {
            intervalMillis = 1000L;
        }
        FileAlterationObserver observer = new FileAlterationObserver(siteDir);
        observer.addListener(listener);
        this.monitor = new FileAlterationMonitor(intervalMillis, new FileAlterationObserver[]{observer});
    }

    public void start() throws Exception {
        if (this.monitor != null) {
            log.info("Starting monitor on directory: " + this.siteDir);
            this.monitor.start();
        }
    }

    public FileAlterationMonitor getMonitor() {
        return this.monitor;
    }

    public void stop() throws Exception {
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }
}

