/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.www.protocol.https;

import com.sun.net.ssl.HostnameVerifier;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.security.util.DerValue;
import sun.security.util.HostnameChecker;
import sun.security.x509.X500Name;

class VerifierWrapper
implements javax.net.ssl.HostnameVerifier {
    private HostnameVerifier verifier;

    VerifierWrapper(HostnameVerifier hostnameVerifier) {
        this.verifier = hostnameVerifier;
    }

    public boolean verify(String string, SSLSession sSLSession) {
        try {
            String string2;
            Principal principal = this.getPeerPrincipal(sSLSession);
            if (principal instanceof KerberosPrincipal) {
                string2 = HostnameChecker.getServerName((KerberosPrincipal)((KerberosPrincipal)principal));
            } else {
                Certificate[] certificateArray = sSLSession.getPeerCertificates();
                if (certificateArray == null || certificateArray.length == 0) {
                    return false;
                }
                if (!(certificateArray[0] instanceof X509Certificate)) {
                    return false;
                }
                X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                string2 = VerifierWrapper.getServername(x509Certificate);
            }
            if (string2 == null) {
                return false;
            }
            return this.verifier.verify(string, string2);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
    }

    private Principal getPeerPrincipal(SSLSession sSLSession) throws SSLPeerUnverifiedException {
        Principal principal;
        try {
            principal = sSLSession.getPeerPrincipal();
        }
        catch (AbstractMethodError abstractMethodError) {
            principal = null;
        }
        return principal;
    }

    private static String getServername(X509Certificate x509Certificate) {
        try {
            Object object;
            Object object2;
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection != null) {
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    object = (List)object2.next();
                    if ((Integer)object.get(0) != 2) continue;
                    String string = (String)object.get(1);
                    return string;
                }
            }
            if ((object = ((X500Name)(object2 = HostnameChecker.getSubjectX500Name(x509Certificate))).findMostSpecificAttribute(X500Name.commonName_oid)) != null) {
                try {
                    String string = ((DerValue)object).getAsString();
                    return string;
                }
                catch (IOException iOException) {}
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }
}

