/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.wagon.github;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.Repository;
import org.opoo.press.maven.wagon.github.GitHub;
import org.opoo.press.maven.wagon.github.GitHubException;

public class GitHubWagon
extends StreamWagon {
    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.fireSessionDebug("fillInputData");
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        this.fireSessionDebug("fillOutputData");
    }

    public void closeConnection() throws ConnectionException {
        this.fireSessionDebug("closeConnection");
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        this.fireSessionDebug("openConnectionInternal");
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String userName = this.getAuthenticationInfo().getUserName();
        String password = this.getAuthenticationInfo().getPassword();
        Repository repo = this.getRepository();
        String[] strings = StringUtils.split((String)repo.getBasedir(), (char)'/');
        if (strings.length != 2) {
            throw new IllegalArgumentException("GitHub url error, no repository owner or name.");
        }
        String repositoryName = strings[1];
        String repositoryOwner = strings[0];
        String branch = repo.getParameter("branch");
        String dryRun = repo.getParameter("dryRun");
        String force = repo.getParameter("force");
        String host = repo.getParameter("host");
        String merge = repo.getParameter("merge");
        String message = repo.getParameter("message");
        String noJekyll = repo.getParameter("noJekyll");
        String oauth2Token = repo.getParameter("oauth2Token");
        String repoUsername = repo.getUsername();
        String repoPassword = repo.getPassword();
        String threads = System.getProperty("threads", "1");
        if (StringUtils.isNotBlank((String)repoUsername)) {
            this.fireTransferDebug("Override userName: " + userName + " -> " + repoUsername);
            userName = repoUsername;
        }
        if (StringUtils.isNotBlank((String)repoPassword)) {
            this.fireTransferDebug("Override password by repository's.");
            password = repoPassword;
        }
        this.fireTransferDebug("userName: " + userName);
        this.fireTransferDebug("password: " + (password != null ? "***" : ""));
        this.fireTransferDebug("message: " + message);
        this.fireTransferDebug("branch: " + branch);
        this.fireTransferDebug("dryRun: " + dryRun);
        this.fireTransferDebug("force: " + force);
        this.fireTransferDebug("host: " + host);
        this.fireTransferDebug("merge: " + merge);
        this.fireTransferDebug("noJekyll: " + noJekyll);
        this.fireTransferDebug("oauth2Token: " + oauth2Token);
        this.fireTransferDebug("numThreads: " + threads);
        GitHub github = new GitHub();
        github.setUserName(userName);
        github.setPassword(password);
        github.setRepositoryName(repositoryName);
        github.setRepositoryOwner(repositoryOwner);
        if (StringUtils.isNotBlank((String)branch)) {
            github.setBranch(branch);
        }
        if (StringUtils.isNotBlank((String)dryRun)) {
            github.setDryRun("true".equals(dryRun));
        }
        if (StringUtils.isNotBlank((String)force)) {
            github.setForce("force".equals(force));
        }
        if (StringUtils.isNotBlank((String)host)) {
            github.setHost(host);
        }
        if (StringUtils.isNotBlank((String)merge)) {
            github.setMerge("true".equals(merge));
        }
        if (StringUtils.isNotBlank((String)message)) {
            github.setMessage(message);
        }
        if (StringUtils.isNotBlank((String)noJekyll)) {
            github.setNoJekyll("true".equals(noJekyll));
        }
        if (StringUtils.isNotBlank((String)oauth2Token)) {
            github.setOauth2Token(oauth2Token);
        }
        if (StringUtils.isNumeric((String)threads)) {
            github.setNumThreads(Integer.parseInt(threads));
        }
        try {
            github.deploy(sourceDirectory, destinationDirectory);
        }
        catch (GitHubException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
    }
}

