/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.plugins.plugin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.opoo.press.Site;
import org.opoo.press.SiteManager;
import org.opoo.press.importer.ImportException;
import org.opoo.press.importer.WordPressImporter;
import org.opoo.press.maven.plugins.plugin.AbstractInstallMojo;

public class WordPressImportMojo
extends AbstractInstallMojo {
    protected File file;
    private boolean importDrafts = false;
    private boolean importAuthor = false;
    private String permalinkStyle;
    private String importDir;
    private Map<String, String> replaceEntries;

    @Override
    protected void afterInstall(SiteManager siteManager, File siteDir) throws MojoExecutionException, MojoFailureException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.file == null || !this.file.exists() || !this.file.isFile()) {
            throw new MojoFailureException("the wordpress exported XML file is required, use '-Dfile=/path/to/file.xml'");
        }
        if (StringUtils.isBlank((String)this.permalinkStyle)) {
            throw new MojoFailureException("permalink style is required, \nsuch as '-Dpermalink-style=/%year%/%monthnum%/%postname%/%post_id%/");
        }
        props.put("permalink_style", this.permalinkStyle);
        props.put("include_drafts", this.importDrafts);
        props.put("include_author", this.importAuthor);
        if (StringUtils.isNotBlank((String)this.importDir)) {
            props.put("import_dir", this.importDir);
        }
        HashMap<String, String> entries = new HashMap<String, String>();
        entries.put("$", "${'$'}");
        if (this.replaceEntries != null) {
            this.getLog().debug((CharSequence)("Add replacement entries: " + this.replaceEntries));
            entries.putAll(this.replaceEntries);
        }
        props.put("content_replacements", entries);
        props.put("file", this.file.getAbsoluteFile());
        WordPressImporter importer = new WordPressImporter();
        try {
            Site site = siteManager.createSite(siteDir);
            importer.doImport(site, props);
        }
        catch (ImportException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }
}

