/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.plugins.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.util.EncodingUtils;
import org.opoo.press.Site;
import org.opoo.press.maven.plugins.plugin.AbstractDeployMojo;

public class DeployToGitHubMojo
extends AbstractDeployMojo {
    public static final String BRANCH_DEFAULT = "refs/heads/gh-pages";
    public static final String NO_JEKYLL_FILE = ".nojekyll";
    private String branch = "refs/heads/gh-pages";
    private String message;
    private String repositoryName;
    private String repositoryOwner;
    private String userName;
    private String password;
    private String oauth2Token;
    private String host;
    private String server;
    private String[] includes;
    private String[] excludes;
    private MavenProject project;
    private MavenSession session;
    private Settings settings;
    private boolean force;
    private boolean noJekyll;
    private boolean merge;
    private boolean dryRun;

    protected String createBlob(DataService service, RepositoryId repository, File outputDirectory, String path) throws MojoExecutionException {
        File file = new File(outputDirectory, path);
        long length = file.length();
        int size = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
        ByteArrayOutputStream output = new ByteArrayOutputStream(size);
        FileInputStream stream = null;
        try {
            int read;
            stream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((read = stream.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading file: " + DeployToGitHubMojo.getExceptionMessage(e), (Exception)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.debug("Exception closing stream", e);
                }
            }
        }
        Blob blob = new Blob().setEncoding("base64");
        String encoded = EncodingUtils.toBase64((byte[])output.toByteArray());
        blob.setContent(encoded);
        try {
            if (this.isDebug()) {
                this.debug(MessageFormat.format("Creating blob from {0}", file.getAbsolutePath()));
            }
            if (!this.dryRun) {
                return service.createBlob((IRepositoryIdProvider)repository, blob);
            }
            return null;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating blob: " + DeployToGitHubMojo.getExceptionMessage(e), (Exception)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void deploy(Site site, File dest) throws MojoExecutionException, MojoFailureException {
        Commit created;
        Tree tree;
        Object[] paths;
        RepositoryId repository = this.getRepository(this.project, this.repositoryOwner, this.repositoryName);
        if (this.dryRun) {
            this.info("Dry run mode, repository will not be modified");
        }
        File outputDirectory = dest;
        String baseDir = outputDirectory.getAbsolutePath();
        Object[] includePaths = DeployToGitHubMojo.removeEmpties(this.includes);
        Object[] excludePaths = DeployToGitHubMojo.removeEmpties(this.excludes);
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Scanning {0} and including {1} and exluding {2}", baseDir, Arrays.toString(includePaths), Arrays.toString(excludePaths)));
        }
        if ((paths = DeployToGitHubMojo.getMatchingPaths((String[])includePaths, (String[])excludePaths, baseDir)).length != 1) {
            this.info(MessageFormat.format("Creating {0} blobs", paths.length));
        } else {
            this.info("Creating 1 blob");
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Scanned files to include: {0}", Arrays.toString(paths)));
        }
        DataService service = new DataService(this.createClient(this.host, this.userName, this.password, this.oauth2Token, this.server, this.settings, this.session));
        ArrayList<TreeEntry> entries = new ArrayList<TreeEntry>(paths.length);
        String prefix = site.getRoot();
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if ('\\' == File.separatorChar) {
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = ((String)paths[i]).replace('\\', '/');
            }
        }
        boolean createNoJekyll = this.noJekyll;
        for (Object path : paths) {
            TreeEntry entry = new TreeEntry();
            entry.setPath(prefix + (String)path);
            if (createNoJekyll && NO_JEKYLL_FILE.equals(entry.getPath())) {
                createNoJekyll = false;
            }
            entry.setType("blob");
            entry.setMode("100644");
            entry.setSha(this.createBlob(service, repository, outputDirectory, (String)path));
            entries.add(entry);
        }
        if (createNoJekyll) {
            TreeEntry entry = new TreeEntry();
            entry.setPath(NO_JEKYLL_FILE);
            entry.setType("blob");
            entry.setMode("100644");
            if (this.isDebug()) {
                this.debug("Creating empty .nojekyll blob at root of tree");
            }
            if (!this.dryRun) {
                try {
                    entry.setSha(service.createBlob((IRepositoryIdProvider)repository, new Blob().setEncoding("base64").setContent("")));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error creating .nojekyll empty blob: " + DeployToGitHubMojo.getExceptionMessage(e), (Exception)e);
                }
            }
            entries.add(entry);
        }
        Reference ref = null;
        try {
            ref = service.getReference((IRepositoryIdProvider)repository, this.branch);
        }
        catch (RequestException e) {
            if (404 != e.getStatus()) {
                throw new MojoExecutionException("Error getting reference: " + DeployToGitHubMojo.getExceptionMessage((IOException)((Object)e)), (Exception)((Object)e));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting reference: " + DeployToGitHubMojo.getExceptionMessage(e), (Exception)e);
        }
        if (ref != null && !"commit".equals(ref.getObject().getType())) {
            throw new MojoExecutionException(MessageFormat.format("Existing ref {0} points to a {1} ({2}) instead of a commmit", ref.getRef(), ref.getObject().getType(), ref.getObject().getSha()));
        }
        try {
            int size = entries.size();
            if (size != 1) {
                this.info(MessageFormat.format("Creating tree with {0} blob entries", size));
            } else {
                this.info("Creating tree with 1 blob entry");
            }
            String baseTree = null;
            if (this.merge && ref != null) {
                Tree currentTree = service.getCommit((IRepositoryIdProvider)repository, ref.getObject().getSha()).getTree();
                if (currentTree != null) {
                    baseTree = currentTree.getSha();
                }
                this.info(MessageFormat.format("Merging with tree {0}", baseTree));
            }
            tree = !this.dryRun ? service.createTree((IRepositoryIdProvider)repository, entries, baseTree) : new Tree();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating tree: " + DeployToGitHubMojo.getExceptionMessage(e), (Exception)e);
        }
        Commit commit = new Commit();
        commit.setMessage(this.message);
        commit.setTree(tree);
        if (ref != null) {
            commit.setParents(Collections.singletonList(new Commit().setSha(ref.getObject().getSha())));
        }
        try {
            created = !this.dryRun ? service.createCommit((IRepositoryIdProvider)repository, commit) : new Commit();
            this.info(MessageFormat.format("Creating commit with SHA-1: {0}", created.getSha()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating commit: " + DeployToGitHubMojo.getExceptionMessage(e), (Exception)e);
        }
        TypedResource object = new TypedResource();
        object.setType("commit").setSha(created.getSha());
        if (ref != null) {
            ref.setObject(object);
            try {
                this.info(MessageFormat.format("Updating reference {0} from {1} to {2}", this.branch, ((Commit)commit.getParents().get(0)).getSha(), created.getSha()));
                if (this.dryRun) return;
                service.editReference((IRepositoryIdProvider)repository, ref, this.force);
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error editing reference: " + DeployToGitHubMojo.getExceptionMessage(e), (Exception)e);
            }
        }
        ref = new Reference().setObject(object).setRef(this.branch);
        try {
            this.info(MessageFormat.format("Creating reference {0} starting at commit {1}", this.branch, created.getSha()));
            if (this.dryRun) return;
            service.createReference((IRepositoryIdProvider)repository, ref);
            return;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating reference: " + DeployToGitHubMojo.getExceptionMessage(e), (Exception)e);
        }
    }

    public static String getExceptionMessage(IOException e) {
        return e.getMessage();
    }

    protected boolean isDebug() {
        Log log = this.getLog();
        return log != null ? log.isDebugEnabled() : false;
    }

    protected boolean isInfo() {
        Log log = this.getLog();
        return log != null ? log.isInfoEnabled() : false;
    }

    protected void debug(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.debug((CharSequence)message);
        }
    }

    protected void debug(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.debug((CharSequence)message, throwable);
        }
    }

    protected void info(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.info((CharSequence)message);
        }
    }

    protected void info(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.info((CharSequence)message, throwable);
        }
    }

    protected GitHubClient createClient(String host, String userName, String password, String oauth2Token, String serverId, Settings settings, MavenSession session) throws MojoExecutionException {
        GitHubClient client;
        if (!StringUtils.isEmpty((String)host)) {
            if (this.isDebug()) {
                this.debug("Using custom host: " + host);
            }
            client = this.createClient(host);
        } else {
            client = this.createClient();
        }
        if (this.configureUsernamePassword(client, userName, password) || this.configureOAuth2Token(client, oauth2Token) || this.configureServerCredentials(client, serverId, settings, session)) {
            return client;
        }
        throw new MojoExecutionException("No authentication credentials configured");
    }

    protected GitHubClient createClient(String hostname) throws MojoExecutionException {
        if (!hostname.contains("://")) {
            return new GitHubClient(hostname);
        }
        try {
            URL hostUrl = new URL(hostname);
            return new GitHubClient(hostUrl.getHost(), hostUrl.getPort(), hostUrl.getProtocol());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Could not parse host URL " + hostname, (Exception)e);
        }
    }

    protected GitHubClient createClient() {
        return new GitHubClient();
    }

    protected boolean configureUsernamePassword(GitHubClient client, String userName, String password) {
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)password)) {
            return false;
        }
        if (!StringUtils.isEmpty((String)userName) && StringUtils.isEmpty((String)password) && System.console() != null) {
            password = new String(System.console().readPassword("Input password for " + userName + ": ", new Object[0]));
        }
        if (this.isDebug()) {
            this.debug("Using basic authentication with username: " + userName);
        }
        client.setCredentials(userName, password);
        return true;
    }

    protected boolean configureOAuth2Token(GitHubClient client, String oauth2Token) {
        if (StringUtils.isEmpty((String)oauth2Token)) {
            return false;
        }
        if (this.isDebug()) {
            this.debug("Using OAuth2 access token authentication");
        }
        client.setOAuth2Token(oauth2Token);
        return true;
    }

    protected boolean configureServerCredentials(GitHubClient client, String serverId, Settings settings, MavenSession session) throws MojoExecutionException {
        if (StringUtils.isEmpty((String)serverId)) {
            return false;
        }
        String serverUsername = null;
        String serverPassword = null;
        if (StringUtils.isEmpty(serverPassword)) {
            Server server = this.getServer(settings, serverId);
            if (server == null) {
                throw new MojoExecutionException(MessageFormat.format("Server ''{0}'' not found in settings", serverId));
            }
            if (this.isDebug()) {
                this.debug(MessageFormat.format("Using ''{0}'' server credentials", serverId));
            }
            serverUsername = server.getUsername();
            serverPassword = server.getPassword();
        }
        if (!StringUtils.isEmpty(serverUsername) && StringUtils.isEmpty(serverPassword) && System.console() != null) {
            serverPassword = new String(System.console().readPassword("Input password for " + serverUsername + ": ", new Object[0]));
        }
        if (!StringUtils.isEmpty(serverUsername) && !StringUtils.isEmpty(serverPassword)) {
            if (this.isDebug()) {
                this.debug("Using basic authentication with username: " + serverUsername);
            }
            client.setCredentials(serverUsername, serverPassword);
            return true;
        }
        if (!StringUtils.isEmpty(serverPassword)) {
            if (this.isDebug()) {
                this.debug("Using OAuth2 access token authentication");
            }
            client.setOAuth2Token(serverPassword);
            return true;
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Server ''{0}'' is missing username/password credentials", serverId));
        }
        return false;
    }

    protected RepositoryId getRepository(MavenProject project, String owner, String name) throws MojoExecutionException {
        RepositoryId repository = null;
        if (!StringUtils.isNotBlank((String)name) || !StringUtils.isNotBlank((String)owner)) {
            throw new MojoExecutionException("No GitHub repository (owner and name) configured");
        }
        repository = RepositoryId.create((String)owner, (String)name);
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Using GitHub repository {0}", repository.generateId()));
        }
        return repository;
    }

    protected Server getServer(Settings settings, String serverId) {
        if (settings == null) {
            return null;
        }
        List servers = settings.getServers();
        if (servers == null || servers.isEmpty()) {
            return null;
        }
        for (Server server : servers) {
            if (!serverId.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    public static String[] removeEmpties(String ... values) {
        if (values == null || values.length == 0) {
            return new String[0];
        }
        ArrayList<String> validValues = new ArrayList<String>();
        for (String value : values) {
            if (value == null || value.length() <= 0) continue;
            validValues.add(value);
        }
        return validValues.toArray(new String[validValues.size()]);
    }

    public static String[] getMatchingPaths(String[] includes, String[] excludes, String baseDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        if (includes != null && includes.length > 0) {
            scanner.setIncludes(includes);
        }
        if (excludes != null && excludes.length > 0) {
            scanner.setExcludes(excludes);
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

