/*
 * Decompiled with CFR 0.152.
 */
package org.opoo.press.maven.plugins.plugin;

import java.io.File;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.opoo.press.Site;
import org.opoo.press.SiteManager;
import org.opoo.press.maven.plugins.plugin.AbstractSassCompileMojo;
import org.opoo.press.util.StaleUtils;

public abstract class AbstractGenerateMojo
extends AbstractSassCompileMojo {
    protected boolean skipGenerate;

    @Override
    protected final void afterSassCompile(SiteManager siteManager, File siteDir) throws MojoExecutionException, MojoFailureException {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("show_drafts", this.showDrafts());
        config.put("debug", this.getLog().isDebugEnabled());
        config.put("op.generate.skip", this.skipGenerate);
        config.put("op.install.skip", this.skipInstall);
        config.put("op.sass.compile.skip", this.skipSassCompile);
        Site site = siteManager.createSite(siteDir, config);
        if (this.skipGenerate) {
            this.getLog().info((CharSequence)"op.generate.skip = true: Skipping generate");
        } else if (this.skipGenerate(siteManager, siteDir, site)) {
            this.getLog().info((CharSequence)"Skipping generate, all output files are up to date.");
        } else {
            this.generate(site);
        }
        this.afterGenerate(siteManager, siteDir, site);
    }

    protected void afterGenerate(SiteManager siteManager, File siteDir, Site site) throws MojoExecutionException, MojoFailureException {
    }

    private boolean skipGenerate(SiteManager siteManager, File siteDir, Site site) {
        return !StaleUtils.isSourceStale((Site)site);
    }

    protected abstract boolean showDrafts();

    private void generate(Site site) {
        long start = System.currentTimeMillis();
        site.build();
        long time = System.currentTimeMillis() - start;
        this.getLog().info((CharSequence)("Generate time: " + time + "ms"));
    }
}

