/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util.anttask;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.mylyn.internal.wikitext.core.validation.StandaloneMarkupValidator;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.ServiceLocator;
import org.eclipse.mylyn.wikitext.core.util.anttask.Messages;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;

public abstract class MarkupTask
extends Task {
    private String markupLanguage;
    private String internalLinkPattern;
    private boolean validate = true;
    private boolean failOnValidationError = true;
    private boolean failOnValidationWarning = false;

    public String getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(String markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    protected MarkupLanguage createMarkupLanguage() throws BuildException {
        if (this.markupLanguage == null) {
            throw new BuildException(Messages.getString("MarkupTask.0"));
        }
        try {
            MarkupLanguage language = ServiceLocator.getInstance(((Object)((Object)this)).getClass().getClassLoader()).getMarkupLanguage(this.markupLanguage);
            if (this.internalLinkPattern != null) {
                language.setInternalLinkPattern(this.internalLinkPattern);
            }
            return language;
        }
        catch (IllegalArgumentException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public void setInternalLinkPattern(String internalLinkPattern) {
        this.internalLinkPattern = internalLinkPattern;
    }

    public String getInternalLinkPattern() {
        return this.internalLinkPattern;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public boolean isFailOnValidationError() {
        return this.failOnValidationError;
    }

    public void setFailOnValidationError(boolean failOnValidationError) {
        this.failOnValidationError = failOnValidationError;
    }

    public boolean isFailOnValidationWarning() {
        return this.failOnValidationWarning;
    }

    public void setFailOnValidationWarning(boolean failOnValidationWarning) {
        this.failOnValidationWarning = failOnValidationWarning;
    }

    protected void performValidation(File source, String markupContent) {
        if (!this.validate) {
            return;
        }
        if (this.markupLanguage == null) {
            throw new IllegalStateException();
        }
        this.log(MessageFormat.format(Messages.getString("MarkupTask.1"), source), 3);
        StandaloneMarkupValidator markupValidator = StandaloneMarkupValidator.getValidator(this.markupLanguage);
        List<ValidationProblem> problems = markupValidator.validate(markupContent);
        int errorCount = 0;
        int warningCount = 0;
        for (ValidationProblem problem : problems) {
            int messageLevel = 0;
            if (problem.getSeverity() == ValidationProblem.Severity.ERROR) {
                ++errorCount;
            } else if (problem.getSeverity() == ValidationProblem.Severity.WARNING) {
                ++warningCount;
                messageLevel = 1;
            }
            this.log(String.format("%s:%s %s", source.getName(), problem.getOffset(), problem.getMessage()), messageLevel);
        }
        if (errorCount > 0 && this.failOnValidationError || warningCount > 0 && this.failOnValidationWarning) {
            throw new BuildException(MessageFormat.format(Messages.getString("MarkupTask.3"), errorCount, warningCount, source));
        }
    }
}

