/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.Locator;

public class MultiplexingDocumentBuilder
extends DocumentBuilder {
    private final List<DocumentBuilder> builders = new ArrayList<DocumentBuilder>();

    public MultiplexingDocumentBuilder(DocumentBuilder ... delegates) {
        this.builders.addAll((Collection<DocumentBuilder>)Arrays.asList(delegates));
    }

    public void addDocumentBuilder(DocumentBuilder delegate) {
        this.builders.add(delegate);
    }

    public void acronym(String text, String definition) {
        for (DocumentBuilder builder : this.builders) {
            builder.acronym(text, definition);
        }
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        for (DocumentBuilder builder : this.builders) {
            builder.beginBlock(type, attributes);
        }
    }

    public void beginDocument() {
        for (DocumentBuilder builder : this.builders) {
            builder.beginDocument();
        }
    }

    public void beginHeading(int level, Attributes attributes) {
        for (DocumentBuilder builder : this.builders) {
            builder.beginHeading(level, attributes);
        }
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        for (DocumentBuilder builder : this.builders) {
            builder.beginSpan(type, attributes);
        }
    }

    public void characters(String text) {
        for (DocumentBuilder builder : this.builders) {
            builder.characters(text);
        }
    }

    public void charactersUnescaped(String literal) {
        for (DocumentBuilder builder : this.builders) {
            builder.charactersUnescaped(literal);
        }
    }

    public void endBlock() {
        for (DocumentBuilder builder : this.builders) {
            builder.endBlock();
        }
    }

    public void endDocument() {
        for (DocumentBuilder builder : this.builders) {
            builder.endDocument();
        }
    }

    public void endHeading() {
        for (DocumentBuilder builder : this.builders) {
            builder.endHeading();
        }
    }

    public void endSpan() {
        for (DocumentBuilder builder : this.builders) {
            builder.endSpan();
        }
    }

    public void entityReference(String entity) {
        for (DocumentBuilder builder : this.builders) {
            builder.entityReference(entity);
        }
    }

    public void image(Attributes attributes, String url) {
        for (DocumentBuilder builder : this.builders) {
            builder.image(attributes, url);
        }
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        for (DocumentBuilder builder : this.builders) {
            builder.imageLink(linkAttributes, imageAttributes, href, imageUrl);
        }
    }

    public void lineBreak() {
        for (DocumentBuilder builder : this.builders) {
            builder.lineBreak();
        }
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        for (DocumentBuilder builder : this.builders) {
            builder.link(attributes, hrefOrHashName, text);
        }
    }

    public void setLocator(Locator locator) {
        super.setLocator(locator);
        for (DocumentBuilder builder : this.builders) {
            builder.setLocator(locator);
        }
    }
}

