/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.ListAttributes;
import org.eclipse.mylyn.wikitext.core.parser.QuoteAttributes;
import org.eclipse.mylyn.wikitext.core.parser.TableAttributes;
import org.eclipse.mylyn.wikitext.core.parser.TableCellAttributes;
import org.eclipse.mylyn.wikitext.core.parser.TableRowAttributes;
import org.eclipse.mylyn.wikitext.core.parser.builder.AbstractXmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.Messages;
import org.eclipse.mylyn.wikitext.core.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.FormattingXMLStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

public class HtmlDocumentBuilder
extends AbstractXmlDocumentBuilder {
    private static final Pattern ABSOLUTE_URL_PATTERN = Pattern.compile("[a-zA-Z]{3,8}://?.*");
    private static final Map<DocumentBuilder.SpanType, String> spanTypeToElementName = new HashMap<DocumentBuilder.SpanType, String>();
    private static final Map<DocumentBuilder.BlockType, ElementInfo> blockTypeToElementInfo;
    private String htmlNsUri = "http://www.w3.org/1999/xhtml";
    private String htmlDtd = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    private boolean xhtmlStrict = false;
    private boolean emitAsDocument = true;
    private boolean emitDtd = false;
    private String encoding = "utf-8";
    private String title;
    private String defaultAbsoluteLinkTarget;
    private List<Stylesheet> stylesheets = null;
    private boolean useInlineStyles = true;
    private boolean suppressBuiltInStyles = false;
    private String linkRel;
    private String prependImagePrefix;

    static {
        spanTypeToElementName.put(DocumentBuilder.SpanType.BOLD, "b");
        spanTypeToElementName.put(DocumentBuilder.SpanType.CITATION, "cite");
        spanTypeToElementName.put(DocumentBuilder.SpanType.ITALIC, "i");
        spanTypeToElementName.put(DocumentBuilder.SpanType.EMPHASIS, "em");
        spanTypeToElementName.put(DocumentBuilder.SpanType.STRONG, "strong");
        spanTypeToElementName.put(DocumentBuilder.SpanType.DELETED, "del");
        spanTypeToElementName.put(DocumentBuilder.SpanType.INSERTED, "ins");
        spanTypeToElementName.put(DocumentBuilder.SpanType.UNDERLINED, "u");
        spanTypeToElementName.put(DocumentBuilder.SpanType.SUPERSCRIPT, "sup");
        spanTypeToElementName.put(DocumentBuilder.SpanType.SUBSCRIPT, "sub");
        spanTypeToElementName.put(DocumentBuilder.SpanType.SPAN, "span");
        spanTypeToElementName.put(DocumentBuilder.SpanType.CODE, "code");
        spanTypeToElementName.put(DocumentBuilder.SpanType.MONOSPACE, "tt");
        blockTypeToElementInfo = new HashMap<DocumentBuilder.BlockType, ElementInfo>();
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.BULLETED_LIST, new ElementInfo("ul"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.CODE, new ElementInfo("code"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.FOOTNOTE, new ElementInfo("footnote"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.LIST_ITEM, new ElementInfo("li"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.NUMERIC_LIST, new ElementInfo("ol"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.DEFINITION_LIST, new ElementInfo("dl"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.DEFINITION_TERM, new ElementInfo("dt"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.DEFINITION_ITEM, new ElementInfo("dd"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.PARAGRAPH, new ElementInfo("p"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.PREFORMATTED, new ElementInfo("pre"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.QUOTE, new ElementInfo("blockquote"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.TABLE, new ElementInfo("table"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.TABLE_CELL_HEADER, new ElementInfo("th"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, new ElementInfo("td"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.TABLE_ROW, new ElementInfo("tr"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.TIP, new ElementInfo("div", "tip", "border: 1px solid #090;background-color: #dfd;margin: 20px;padding: 0px 6px 0px 6px;"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.WARNING, new ElementInfo("div", "warning", "border: 1px solid #c00;background-color: #fcc;margin: 20px;padding: 0px 6px 0px 6px;"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.INFORMATION, new ElementInfo("div", "info", "border: 1px solid #3c78b5;background-color: #D8E4F1;margin: 20px;padding: 0px 6px 0px 6px;"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.NOTE, new ElementInfo("div", "note", "border: 1px solid #F0C000;background-color: #FFFFCE;margin: 20px;padding: 0px 6px 0px 6px;"));
        blockTypeToElementInfo.put(DocumentBuilder.BlockType.PANEL, new ElementInfo("div", "panel", "border: 1px solid #ccc;background-color: #FFFFCE;margin: 10px;padding: 0px 6px 0px 6px;"));
    }

    public HtmlDocumentBuilder(Writer out) {
        this(out, false);
    }

    public HtmlDocumentBuilder(Writer out, boolean formatting) {
        super(formatting ? HtmlDocumentBuilder.createFormattingXmlStreamWriter(out) : new DefaultXmlStreamWriter(out));
    }

    public HtmlDocumentBuilder(XmlStreamWriter writer) {
        super(writer);
    }

    public void copyConfiguration(HtmlDocumentBuilder other) {
        other.setBase(this.getBase());
        other.setBaseInHead(this.isBaseInHead());
        other.setDefaultAbsoluteLinkTarget(this.getDefaultAbsoluteLinkTarget());
        other.setEmitAsDocument(this.isEmitAsDocument());
        other.setEmitDtd(this.isEmitDtd());
        other.setHtmlDtd(this.getHtmlDtd());
        other.setHtmlNsUri(this.getHtmlNsUri());
        other.setLinkRel(this.getLinkRel());
        other.setTitle(this.getTitle());
        other.setUseInlineStyles(this.isUseInlineStyles());
        other.setSuppressBuiltInStyles(this.isSuppressBuiltInStyles());
        other.setXhtmlStrict(this.xhtmlStrict);
        other.setPrependImagePrefix(this.prependImagePrefix);
        if (this.stylesheets != null) {
            other.stylesheets = new ArrayList<Stylesheet>();
            other.stylesheets.addAll(this.stylesheets);
        }
    }

    protected static XmlStreamWriter createFormattingXmlStreamWriter(Writer out) {
        return new FormattingXMLStreamWriter(new DefaultXmlStreamWriter(out)){

            protected boolean preserveWhitespace(String elementName) {
                return elementName.equals("pre") || elementName.equals("code");
            }
        };
    }

    public String getHtmlNsUri() {
        return this.htmlNsUri;
    }

    public void setHtmlNsUri(String htmlNsUri) {
        this.htmlNsUri = htmlNsUri;
    }

    public String getHtmlDtd() {
        return this.htmlDtd;
    }

    public void setHtmlDtd(String htmlDtd) {
        this.htmlDtd = htmlDtd;
    }

    public boolean isEmitAsDocument() {
        return this.emitAsDocument;
    }

    public void setEmitAsDocument(boolean emitAsDocument) {
        this.emitAsDocument = emitAsDocument;
    }

    public boolean isEmitDtd() {
        return this.emitDtd;
    }

    public void setEmitDtd(boolean emitDtd) {
        this.emitDtd = emitDtd;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDefaultAbsoluteLinkTarget() {
        return this.defaultAbsoluteLinkTarget;
    }

    public void setDefaultAbsoluteLinkTarget(String defaultAbsoluteLinkTarget) {
        this.defaultAbsoluteLinkTarget = defaultAbsoluteLinkTarget;
    }

    public boolean isXhtmlStrict() {
        return this.xhtmlStrict;
    }

    public void setXhtmlStrict(boolean xhtmlStrict) {
        this.xhtmlStrict = xhtmlStrict;
    }

    @Deprecated
    public void addCssStylesheet(String url) {
        this.addCssStylesheet(new Stylesheet(url));
    }

    @Deprecated
    public void addCssStylesheet(File file) {
        this.addCssStylesheet(new Stylesheet(file));
    }

    public void addCssStylesheet(Stylesheet stylesheet) {
        if (stylesheet.file != null) {
            this.checkFileReadable(stylesheet.file);
        }
        if (this.stylesheets == null) {
            this.stylesheets = new ArrayList<Stylesheet>();
        }
        this.stylesheets.add(stylesheet);
    }

    protected void checkFileReadable(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("HtmlDocumentBuilder.3"), file));
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("HtmlDocumentBuilder.1"), file));
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("HtmlDocumentBuilder.2"), file));
        }
    }

    public boolean isUseInlineStyles() {
        return this.useInlineStyles;
    }

    public void setUseInlineStyles(boolean useInlineStyles) {
        this.useInlineStyles = useInlineStyles;
    }

    public boolean isSuppressBuiltInStyles() {
        return this.suppressBuiltInStyles;
    }

    public void setSuppressBuiltInStyles(boolean suppressBuiltInStyles) {
        this.suppressBuiltInStyles = suppressBuiltInStyles;
    }

    public String getLinkRel() {
        return this.linkRel;
    }

    public void setLinkRel(String linkRel) {
        this.linkRel = linkRel;
    }

    public void beginDocument() {
        this.writer.setDefaultNamespace(this.htmlNsUri);
        if (this.emitAsDocument) {
            if (this.encoding != null && this.encoding.length() > 0) {
                this.writer.writeStartDocument(this.encoding, "1.0");
            } else {
                this.writer.writeStartDocument();
            }
            if (this.emitDtd && this.htmlDtd != null) {
                this.writer.writeDTD(this.htmlDtd);
            }
            this.writer.writeStartElement(this.htmlNsUri, "html");
            this.writer.writeDefaultNamespace(this.htmlNsUri);
            this.writer.writeStartElement(this.htmlNsUri, "head");
            this.emitHeadContents();
            this.writer.writeEndElement();
            this.beginBody();
        } else if (this.stylesheets != null && !this.stylesheets.isEmpty()) {
            throw new IllegalStateException(Messages.getString("HtmlDocumentBuilder.0"));
        }
    }

    protected void emitHeadContents() {
        if (this.encoding != null && this.encoding.length() > 0) {
            this.writer.writeEmptyElement(this.htmlNsUri, "meta");
            this.writer.writeAttribute("http-equiv", "Content-Type");
            this.writer.writeAttribute("content", String.format("text/html; charset=%s", this.encoding));
        }
        if (this.base != null && this.baseInHead) {
            this.writer.writeEmptyElement(this.htmlNsUri, "base");
            this.writer.writeAttribute("href", this.base.toString());
        }
        if (this.title != null) {
            this.writer.writeStartElement(this.htmlNsUri, "title");
            this.writer.writeCharacters(this.title);
            this.writer.writeEndElement();
        }
        if (!this.useInlineStyles && !this.suppressBuiltInStyles) {
            this.writer.writeStartElement(this.htmlNsUri, "style");
            this.writer.writeAttribute("type", "text/css");
            this.writer.writeCharacters("\n");
            for (Map.Entry entry : blockTypeToElementInfo.entrySet()) {
                String[] classes;
                ElementInfo elementInfo = (ElementInfo)entry.getValue();
                if (elementInfo.cssStyles == null || elementInfo.cssClass == null) continue;
                String[] stringArray = classes = elementInfo.cssClass.split("\\s+");
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    String cssClass = stringArray[n2];
                    this.writer.writeCharacters(".");
                    this.writer.writeCharacters(cssClass);
                    this.writer.writeCharacters(" ");
                    ++n2;
                }
                this.writer.writeCharacters("{");
                this.writer.writeCharacters(elementInfo.cssStyles);
                this.writer.writeCharacters("}\n");
            }
            this.writer.writeEndElement();
        }
        if (this.stylesheets != null) {
            for (Stylesheet stylesheet : this.stylesheets) {
                this.emitStylesheet(stylesheet);
            }
        }
    }

    private void emitStylesheet(Stylesheet stylesheet) {
        if (stylesheet.url != null) {
            this.writer.writeEmptyElement(this.htmlNsUri, "link");
            this.writer.writeAttribute("type", "text/css");
            this.writer.writeAttribute("rel", "stylesheet");
            this.writer.writeAttribute("href", this.makeUrlAbsolute(stylesheet.url));
            for (Map.Entry attr : stylesheet.attributes.entrySet()) {
                String attrName = (String)attr.getKey();
                if ("type".equals(attrName) || "rel".equals(attrName) || "href".equals(attrName)) continue;
                this.writer.writeAttribute(attrName, (String)attr.getValue());
            }
        } else {
            String css;
            this.writer.writeStartElement(this.htmlNsUri, "style");
            this.writer.writeAttribute("type", "text/css");
            for (Map.Entry attr : stylesheet.attributes.entrySet()) {
                String attrName = (String)attr.getKey();
                if ("type".equals(attrName)) continue;
                this.writer.writeAttribute(attrName, (String)attr.getValue());
            }
            if (stylesheet.file != null) {
                try {
                    css = this.readFully(stylesheet.file);
                }
                catch (IOException e) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("HtmlDocumentBuilder.4"), stylesheet.file), e);
                }
            }
            try {
                css = this.readFully(stylesheet.reader, 1024);
            }
            catch (IOException e) {
                throw new IllegalStateException(Messages.getString("HtmlDocumentBuilder.5"), e);
            }
            this.writer.writeCharacters(css);
            this.writer.writeEndElement();
        }
    }

    public void endDocument() {
        if (this.emitAsDocument) {
            this.endBody();
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
        }
        this.writer.close();
    }

    protected void beginBody() {
        this.writer.writeStartElement(this.htmlNsUri, "body");
    }

    protected void endBody() {
        this.writer.writeEndElement();
    }

    public void entityReference(String entity) {
        this.writer.writeEntityRef(entity);
    }

    public void acronym(String text, String definition) {
        this.writer.writeStartElement(this.htmlNsUri, "acronym");
        this.writer.writeAttribute("title", definition);
        this.writer.writeCharacters(text);
        this.writer.writeEndElement();
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.writer.writeStartElement(this.htmlNsUri, "a");
        this.emitAnchorHref(hrefOrHashName);
        this.applyLinkAttributes(attributes, hrefOrHashName);
        this.characters(text);
        this.writer.writeEndElement();
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        ElementInfo elementInfo = blockTypeToElementInfo.get((Object)type);
        if (elementInfo == null) {
            throw new IllegalStateException(type.name());
        }
        this.writer.writeStartElement(this.htmlNsUri, elementInfo.name);
        if (elementInfo.cssClass != null) {
            if (attributes.getCssClass() == null) {
                attributes.setCssClass(elementInfo.cssClass);
            } else {
                attributes.setCssClass(String.valueOf(elementInfo.cssClass) + ' ' + attributes.getCssClass());
            }
        }
        if (this.useInlineStyles && !this.suppressBuiltInStyles && elementInfo.cssStyles != null) {
            if (attributes.getCssStyle() == null) {
                attributes.setCssStyle(elementInfo.cssStyles);
            } else {
                attributes.setCssStyle(String.valueOf(elementInfo.cssStyles) + attributes.getCssStyle());
            }
        }
        if (type == DocumentBuilder.BlockType.TABLE) {
            this.applyTableAttributes(attributes);
        } else if (type == DocumentBuilder.BlockType.TABLE_ROW) {
            this.applyTableRowAttributes(attributes);
        } else if (type == DocumentBuilder.BlockType.TABLE_CELL_HEADER || type == DocumentBuilder.BlockType.TABLE_CELL_NORMAL) {
            this.applyCellAttributes(attributes);
        } else if (type == DocumentBuilder.BlockType.BULLETED_LIST || type == DocumentBuilder.BlockType.NUMERIC_LIST) {
            this.applyListAttributes(attributes);
        } else if (type == DocumentBuilder.BlockType.QUOTE) {
            this.applyQuoteAttributes(attributes);
        } else {
            this.applyAttributes(attributes);
            if (attributes.getTitle() != null) {
                this.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
                this.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
                this.characters(attributes.getTitle());
                this.endSpan();
                this.endBlock();
            }
        }
    }

    public void beginHeading(int level, Attributes attributes) {
        if (level > 6) {
            level = 6;
        }
        this.writer.writeStartElement(this.htmlNsUri, "h" + level);
        this.applyAttributes(attributes);
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        String elementName = spanTypeToElementName.get((Object)type);
        if (elementName == null) {
            throw new IllegalStateException(type.name());
        }
        this.writer.writeStartElement(this.htmlNsUri, elementName);
        this.applyAttributes(attributes);
    }

    public void endBlock() {
        this.writer.writeEndElement();
    }

    public void endHeading() {
        this.writer.writeEndElement();
    }

    public void endSpan() {
        this.writer.writeEndElement();
    }

    public void image(Attributes attributes, String url) {
        this.writer.writeEmptyElement(this.htmlNsUri, "img");
        this.applyImageAttributes(attributes);
        url = this.prependImageUrl(url);
        this.writer.writeAttribute("src", this.makeUrlAbsolute(url));
    }

    private void applyListAttributes(Attributes attributes) {
        ListAttributes listAttributes;
        this.applyAttributes(attributes);
        if (attributes instanceof ListAttributes && (listAttributes = (ListAttributes)attributes).getStart() != null) {
            this.writer.writeAttribute("start", listAttributes.getStart());
        }
    }

    private void applyQuoteAttributes(Attributes attributes) {
        QuoteAttributes quoteAttributes;
        this.applyAttributes(attributes);
        if (attributes instanceof QuoteAttributes && (quoteAttributes = (QuoteAttributes)attributes).getCitation() != null) {
            this.writer.writeAttribute("cite", quoteAttributes.getCitation());
        }
    }

    private void applyTableAttributes(Attributes attributes) {
        this.applyAttributes(attributes);
        if (attributes.getTitle() != null) {
            this.writer.writeAttribute("title", attributes.getTitle());
        }
        if (attributes instanceof TableAttributes) {
            TableAttributes tableAttributes = (TableAttributes)attributes;
            if (tableAttributes.getBgcolor() != null) {
                this.writer.writeAttribute("bgcolor", tableAttributes.getBgcolor());
            }
            if (tableAttributes.getBorder() != null) {
                this.writer.writeAttribute("border", tableAttributes.getBorder());
            }
            if (tableAttributes.getCellpadding() != null) {
                this.writer.writeAttribute("cellpadding", tableAttributes.getCellpadding());
            }
            if (tableAttributes.getCellspacing() != null) {
                this.writer.writeAttribute("cellspacing", tableAttributes.getCellspacing());
            }
            if (tableAttributes.getFrame() != null) {
                this.writer.writeAttribute("frame", tableAttributes.getFrame());
            }
            if (tableAttributes.getRules() != null) {
                this.writer.writeAttribute("rules", tableAttributes.getRules());
            }
            if (tableAttributes.getSummary() != null) {
                this.writer.writeAttribute("summary", tableAttributes.getSummary());
            }
            if (tableAttributes.getWidth() != null) {
                this.writer.writeAttribute("width", tableAttributes.getWidth());
            }
        }
    }

    private void applyTableRowAttributes(Attributes attributes) {
        this.applyAttributes(attributes);
        if (attributes.getTitle() != null) {
            this.writer.writeAttribute("title", attributes.getTitle());
        }
        if (attributes instanceof TableRowAttributes) {
            TableRowAttributes tableRowAttributes = (TableRowAttributes)attributes;
            if (tableRowAttributes.getBgcolor() != null) {
                this.writer.writeAttribute("bgcolor", tableRowAttributes.getBgcolor());
            }
            if (tableRowAttributes.getAlign() != null) {
                this.writer.writeAttribute("align", tableRowAttributes.getAlign());
            }
            if (tableRowAttributes.getValign() != null) {
                this.writer.writeAttribute("valign", tableRowAttributes.getValign());
            }
        }
    }

    private void applyCellAttributes(Attributes attributes) {
        this.applyAttributes(attributes);
        if (attributes.getTitle() != null) {
            this.writer.writeAttribute("title", attributes.getTitle());
        }
        if (attributes instanceof TableCellAttributes) {
            TableCellAttributes tableCellAttributes = (TableCellAttributes)attributes;
            if (tableCellAttributes.getBgcolor() != null) {
                this.writer.writeAttribute("bgcolor", tableCellAttributes.getBgcolor());
            }
            if (tableCellAttributes.getAlign() != null) {
                this.writer.writeAttribute("align", tableCellAttributes.getAlign());
            }
            if (tableCellAttributes.getValign() != null) {
                this.writer.writeAttribute("valign", tableCellAttributes.getValign());
            }
            if (tableCellAttributes.getRowspan() != null) {
                this.writer.writeAttribute("rowspan", tableCellAttributes.getRowspan());
            }
            if (tableCellAttributes.getColspan() != null) {
                this.writer.writeAttribute("colspan", tableCellAttributes.getColspan());
            }
        }
    }

    private void applyImageAttributes(Attributes attributes) {
        int border = 0;
        ImageAttributes.Align align = null;
        if (attributes instanceof ImageAttributes) {
            ImageAttributes imageAttributes = (ImageAttributes)attributes;
            border = imageAttributes.getBorder();
            align = imageAttributes.getAlign();
        }
        if (this.xhtmlStrict) {
            String borderStyle = String.format("border-width: %spx;", border);
            String alignStyle = null;
            if (align != null) {
                switch (align) {
                    case Left: 
                    case Right: 
                    case Center: {
                        alignStyle = "text-align: " + align.name().toLowerCase() + ";";
                        break;
                    }
                    case Top: 
                    case Middle: 
                    case Baseline: 
                    case Bottom: {
                        alignStyle = "vertical-align: " + align.name().toLowerCase() + ";";
                        break;
                    }
                    case Texttop: {
                        alignStyle = "vertical-align: text-top;";
                        break;
                    }
                    case Absmiddle: {
                        alignStyle = "vertical-align: middle;";
                        break;
                    }
                    case Absbottom: {
                        alignStyle = "vertical-align: bottom;";
                    }
                }
            }
            String additionalStyles = borderStyle;
            if (alignStyle != null) {
                additionalStyles = String.valueOf(additionalStyles) + alignStyle;
            }
            if (attributes.getCssStyle() == null || attributes.getCssStyle().length() == 0) {
                attributes.setCssStyle(additionalStyles);
            } else {
                attributes.setCssStyle(String.valueOf(additionalStyles) + attributes.getCssStyle());
            }
        }
        this.applyAttributes(attributes);
        boolean haveAlt = false;
        if (attributes instanceof ImageAttributes) {
            ImageAttributes imageAttributes = (ImageAttributes)attributes;
            if (imageAttributes.getHeight() != -1) {
                this.writer.writeAttribute("height", Integer.toString(imageAttributes.getHeight()));
            }
            if (imageAttributes.getWidth() != -1) {
                this.writer.writeAttribute("width", Integer.toString(imageAttributes.getWidth()));
            }
            if (!this.xhtmlStrict && align != null) {
                this.writer.writeAttribute("align", align.name().toLowerCase());
            }
            if (imageAttributes.getAlt() != null) {
                haveAlt = true;
                this.writer.writeAttribute("alt", imageAttributes.getAlt());
            }
        }
        if (attributes.getTitle() != null) {
            this.writer.writeAttribute("title", attributes.getTitle());
            if (!haveAlt) {
                haveAlt = true;
                this.writer.writeAttribute("alt", attributes.getTitle());
            }
        }
        if (this.xhtmlStrict) {
            if (!haveAlt) {
                this.writer.writeAttribute("alt", "");
            }
        } else {
            this.writer.writeAttribute("border", Integer.toString(border));
        }
    }

    private void applyLinkAttributes(Attributes attributes, String href) {
        this.applyAttributes(attributes);
        boolean hasTarget = false;
        String rel = this.linkRel;
        if (attributes instanceof LinkAttributes) {
            LinkAttributes linkAttributes = (LinkAttributes)attributes;
            if (linkAttributes.getTarget() != null) {
                hasTarget = true;
                this.writer.writeAttribute("target", linkAttributes.getTarget());
            }
            if (linkAttributes.getRel() != null) {
                String string = rel = rel == null ? linkAttributes.getRel() : String.valueOf(linkAttributes.getRel()) + ' ' + rel;
            }
        }
        if (attributes.getTitle() != null && attributes.getTitle().length() > 0) {
            this.writer.writeAttribute("title", attributes.getTitle());
        }
        if (!hasTarget && this.defaultAbsoluteLinkTarget != null && href != null && this.isExternalLink(href)) {
            this.writer.writeAttribute("target", this.defaultAbsoluteLinkTarget);
        }
        if (rel != null) {
            this.writer.writeAttribute("rel", rel);
        }
    }

    private void applyAttributes(Attributes attributes) {
        if (attributes.getId() != null) {
            this.writer.writeAttribute("id", attributes.getId());
        }
        if (attributes.getCssClass() != null) {
            this.writer.writeAttribute("class", attributes.getCssClass());
        }
        if (attributes.getCssStyle() != null) {
            this.writer.writeAttribute("style", attributes.getCssStyle());
        }
        if (attributes.getLanguage() != null) {
            this.writer.writeAttribute("lang", attributes.getLanguage());
        }
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.writer.writeStartElement(this.htmlNsUri, "a");
        this.emitAnchorHref(href);
        this.applyLinkAttributes(linkAttributes, href);
        this.writer.writeEmptyElement(this.htmlNsUri, "img");
        this.applyImageAttributes(imageAttributes);
        imageUrl = this.prependImageUrl(imageUrl);
        this.writer.writeAttribute("src", this.makeUrlAbsolute(imageUrl));
        this.writer.writeEndElement();
    }

    protected void emitAnchorHref(String href) {
        this.writer.writeAttribute("href", this.makeUrlAbsolute(href));
    }

    private String prependImageUrl(String imageUrl) {
        if (this.prependImagePrefix == null || this.prependImagePrefix.length() == 0) {
            return imageUrl;
        }
        if (ABSOLUTE_URL_PATTERN.matcher(imageUrl).matches()) {
            return imageUrl;
        }
        String url = this.prependImagePrefix;
        if (!this.prependImagePrefix.endsWith("/")) {
            url = String.valueOf(url) + '/';
        }
        url = String.valueOf(url) + imageUrl;
        return url;
    }

    public void lineBreak() {
        this.writer.writeEmptyElement(this.htmlNsUri, "br");
    }

    public void charactersUnescaped(String literal) {
        this.writer.writeLiteral(literal);
    }

    private String readFully(File inputFile) throws IOException {
        int length = (int)inputFile.length();
        if (length <= 0) {
            length = 2048;
        }
        return this.readFully(this.getReader(inputFile), length);
    }

    private String readFully(Reader input, int bufferSize) throws IOException {
        StringBuilder buf = new StringBuilder(bufferSize);
        try {
            int c;
            BufferedReader reader = new BufferedReader(input);
            while ((c = ((Reader)reader).read()) != -1) {
                buf.append((char)c);
            }
        }
        finally {
            input.close();
        }
        return buf.toString();
    }

    protected Reader getReader(File inputFile) throws FileNotFoundException {
        return new FileReader(inputFile);
    }

    public void setPrependImagePrefix(String prependImagePrefix) {
        this.prependImagePrefix = prependImagePrefix;
    }

    public String getPrependImagePrefix() {
        return this.prependImagePrefix;
    }

    private static final class ElementInfo {
        final String name;
        final String cssClass;
        final String cssStyles;

        public ElementInfo(String name, String cssClass, String cssStyles) {
            this.name = name;
            this.cssClass = cssClass;
            this.cssStyles = cssStyles != null && !cssStyles.endsWith(";") ? String.valueOf(cssStyles) + ';' : cssStyles;
        }

        public ElementInfo(String name) {
            this(name, null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Stylesheet {
        private final String url;
        private final File file;
        private final Reader reader;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public Stylesheet(File file) {
            if (file == null) {
                throw new IllegalArgumentException();
            }
            this.file = file;
            this.url = null;
            this.reader = null;
        }

        public Stylesheet(String url) {
            if (url == null || url.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.url = url;
            this.file = null;
            this.reader = null;
        }

        public Stylesheet(Reader reader) {
            if (reader == null) {
                throw new IllegalArgumentException();
            }
            this.reader = reader;
            this.file = null;
            this.url = null;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public File getFile() {
            return this.file;
        }

        public String getUrl() {
            return this.url;
        }

        public Reader getReader() {
            return this.reader;
        }
    }
}

