/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Component(role=LocalRepositoryProvider.class)
public class DefaultLocalRepositoryProvider
implements LocalRepositoryProvider,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement(role=LocalRepositoryManagerFactory.class)
    private Collection<LocalRepositoryManagerFactory> managerFactories = new ArrayList<LocalRepositoryManagerFactory>();
    private static final Comparator<LocalRepositoryManagerFactory> COMPARATOR = new Comparator<LocalRepositoryManagerFactory>(){

        @Override
        public int compare(LocalRepositoryManagerFactory o1, LocalRepositoryManagerFactory o2) {
            return Float.compare(o2.getPriority(), o1.getPriority());
        }
    };

    public DefaultLocalRepositoryProvider() {
    }

    @Inject
    DefaultLocalRepositoryProvider(Set<LocalRepositoryManagerFactory> factories, LoggerFactory loggerFactory) {
        this.setLocalRepositoryManagerFactories(factories);
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
        this.setLocalRepositoryManagerFactories(locator.getServices(LocalRepositoryManagerFactory.class));
    }

    public DefaultLocalRepositoryProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultLocalRepositoryProvider addLocalRepositoryManagerFactory(LocalRepositoryManagerFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Local repository manager factory has not been specified.");
        }
        this.managerFactories.add(factory);
        return this;
    }

    public DefaultLocalRepositoryProvider setLocalRepositoryManagerFactories(Collection<LocalRepositoryManagerFactory> factories) {
        this.managerFactories = factories == null ? new ArrayList<LocalRepositoryManagerFactory>(2) : factories;
        return this;
    }

    DefaultLocalRepositoryProvider setManagerFactories(List<LocalRepositoryManagerFactory> factories) {
        return this.setLocalRepositoryManagerFactories(factories);
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) throws NoLocalRepositoryManagerException {
        ArrayList<LocalRepositoryManagerFactory> factories = new ArrayList<LocalRepositoryManagerFactory>(this.managerFactories);
        Collections.sort(factories, COMPARATOR);
        for (LocalRepositoryManagerFactory factory : factories) {
            try {
                LocalRepositoryManager manager = factory.newInstance(session, localRepository);
                if (this.logger.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using manager ").append(manager.getClass().getSimpleName());
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(localRepository.getBasedir());
                    this.logger.debug(buffer.toString());
                }
                return manager;
            }
            catch (NoLocalRepositoryManagerException e) {
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("No manager available for local repository ");
        buffer.append(localRepository.getBasedir());
        buffer.append(" of type ").append(localRepository.getContentType());
        buffer.append(" using the available factories ");
        ListIterator it = factories.listIterator();
        while (it.hasNext()) {
            LocalRepositoryManagerFactory factory = (LocalRepositoryManagerFactory)it.next();
            buffer.append(factory.getClass().getSimpleName());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        throw new NoLocalRepositoryManagerException(localRepository, buffer.toString());
    }
}

