import 'package:flutter/material.dart';

/// UI Widget for displaying metadata.
class MetaCard extends StatelessWidget {
  final String _title;
  final Widget _children;

  // ignore: public_member_api_docs
  MetaCard(this._title, this._children);

  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      margin: const EdgeInsets.only(left: 8, right: 8, top: 8),
      child: Card(
        child: Padding(
          padding: const EdgeInsets.all(16),
          child: Column(children: [
            Container(
              margin: const EdgeInsets.only(bottom: 16),
              child:
                Text(_title, style: const TextStyle(fontSize: 18))
            ),
            this._children,
          ])
        )
      )
    );
  }
}