//**********************************************************************************
//* All Rights Reserved, Copyright (C) 2007,2010 Hitachi Solutions,Ltd.
//**********************************************************************************

//**********************************************************************************
//* NX        FWindowsAPIErrorException
//* NX{ꖼ  FWin32ʗO
//*
//* 쐬          FZ 
//* XV        F
//*
//*          XV            e
//*  ----------  ----------------  -------------------------------------------------
//*  2010/10/26            VK쐬
//**********************************************************************************

using System;

namespace Touryo.Infrastructure.Public.Win32
{
    /// <summary>Win32ʗO</summary>
    public class WindowsAPIErrorException : ApplicationException
    {
        /// <summary>G[bZ[W̃ev[g</summary>
        public static readonly string MessageTemplate
            = "Windows API{0}֐ĂяoɎs܂B";

        /// <summary>ErrorCodes</summary>
        private CmnWin32.ErrorCodes _errorCode = 0;

        /// <summary>ErrorCodes</summary>
        public CmnWin32.ErrorCodes ErrorCode
        {
            get
            {
                return this._errorCode;
            }
        }

        /// <summary>RXgN^P</summary>
        /// <param name="error">ErrorCodes</param>
        public WindowsAPIErrorException(CmnWin32.ErrorCodes error)
            : base()
        {
            this._errorCode = error;
        }

        /// <summary>RXgN^Q</summary>
        /// <param name="error">ErrorCodes</param>
        /// <param name="message">bZ[W</param>
        public WindowsAPIErrorException(
            CmnWin32.ErrorCodes error, string message)
            : base(message)
        {
            this._errorCode = error;
        }

        /// <summary>RXgN^R</summary>
        /// <param name="error">ErrorCodes</param>
        /// <param name="message">bZ[W</param>
        /// <param name="inner">O</param>
        public WindowsAPIErrorException(
            CmnWin32.ErrorCodes error, string message, System.Exception inner)
            : base(message, inner)
        {
            this._errorCode = error;
        }

        /// <summary>RXgN^S</summary>
        /// <param name="info">SerializationInfo</param>
        /// <param name="context">StreamingContext</param>
        /// <remarks>
        /// [eBO T[o̓`dɕKvȃRXgN^B
        /// </remarks>
        protected WindowsAPIErrorException(
            System.Runtime.Serialization.SerializationInfo info,
            System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }
}
