﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ChatWindow.aspx.cs" Inherits="SignalRChat.ChatWindow" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>SignalR Chat</title>
    <link href="Style/Common.css" rel="stylesheet" />
</head>
<body>
    <!--Script references. -->
    <!--Reference the jQuery library. -->
    <script src="Scripts/jquery-1.6.4.min.js"></script>
    <!--Reference the SignalR library. -->
    <script src="Scripts/jquery.signalR-2.2.0.min.js"></script>
    <!--Reference the autogenerated SignalR hub script. -->
    <script src="signalr/hubs"></script>
    <!--Add script to update the page and send messages.-->
    <script type="text/javascript">
        var encodedName = '';
        var encodedMsg = '';

        $(document).ready(function () { $('#txtUserName').focus(); });

        function SubmitClick() {
            if (event.keyCode == 13) {
                document.getElementById('btnLogin').click();
            }
        }

        function SendClick() {
            if (event.keyCode == 13) {
                window.event.returnValue = false;
                document.getElementById('sendmessage').click();
            }
        }

        $(function () {
            // Declare a proxy to reference the hub.
            var chat = $.connection.chatHub;
            // Create a function that the hub can call to broadcast messages.
            chat.client.broadcastMessage = function (name, message) {
                // Html encode display name and message.
                encodedName = $('<div />').text(name).html();
                encodedMsg = $('<div />').text(message).html();

                // Add the message to the page.
                $('#discussion').append('<ul style="text-align:left;"><strong>' + encodedName
                    + '</strong>:&nbsp;&nbsp;' + encodedMsg + '</li>');
            };
            // Set initial focus to message input box.
            $('#message').focus();
            // Start the connection.
            $.connection.hub.start().done(function () {
                $('#sendmessage').click(function () {
                    // Call the Send method on the hub.
                    chat.server.send($('#displayname').val(), $('#message').val());
                    // Clear text box and reset focus for next comment.
                    $('#message').val('').focus();
                });
            });
        });
    </script>

    <form id="form1" runat="server">
        <div style="width: 100%">
            <div style="width: 100%; color: white; background-color: green; height: 50px; font-size: xx-large; font-weight: bold;">
                SignalR Chat Window
                <asp:Button ID="btnLogout" runat="server" value="Logout" Text="Logout" Style="float: right;" OnClick="btnLogout_Click" UseSubmitBehavior="False"></asp:Button>
            </div>
            <div style="width: 100%">

                <table class="table-discussion">
                    <tr>
                        <td id="login" runat="server" style="display: block;">
                            <div class="divlogin">
                                Login
                            </div>
                            <div class="dv-margin-text">
                                <asp:Label ID="lblUserName" meta:resourcekey="lblUserName" runat="server"></asp:Label>
                                <input type="text" id="txtUserName" runat="server" onkeydown="SubmitClick(); " />
                                <asp:HiddenField ID="displayname" runat="server" />
                            </div>
                            <div style="margin: 5px auto;">
                                <asp:Button ID="btnLogin" runat="server" Text="Login" OnClick="btnLogin_Click"></asp:Button>
                            </div>
                        </td>
                        <td id="chatWindow" runat="server">
                            <div style="width: 60%; margin-left: 20%">
                                <div class="dvChatwindow" style="overflow: scroll;">
                                    <div id="discussion" style="height: 80%; width: 100%">
                                    </div>
                                </div>
                                <div style="width: 96%; text-align: center; margin: auto;">
                                    <input type="text" id="message" onkeydown="SendClick()" />
                                    <input type="button" id="sendmessage" value="Send" />
                                </div>
                                <asp:ScriptManager ID="ScriptManager" runat="server" EnablePageMethods="true" />
                            </div>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </form>
</body>
</html>
