# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

import httpx

from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.jsonable_encoder import jsonable_encoder
from .core.remove_none_from_dict import remove_none_from_dict
from .environment import OpenPipeApiEnvironment
from .types.check_cache_response import CheckCacheResponse
from .types.create_chat_completion_request_function_call import CreateChatCompletionRequestFunctionCall
from .types.create_chat_completion_request_functions_item import CreateChatCompletionRequestFunctionsItem
from .types.create_chat_completion_request_messages_item import CreateChatCompletionRequestMessagesItem
from .types.create_chat_completion_request_req_payload import CreateChatCompletionRequestReqPayload
from .types.create_chat_completion_request_response_format import CreateChatCompletionRequestResponseFormat
from .types.create_chat_completion_request_tool_choice import CreateChatCompletionRequestToolChoice
from .types.create_chat_completion_request_tools_item import CreateChatCompletionRequestToolsItem
from .types.create_chat_completion_response import CreateChatCompletionResponse
from .types.local_testing_only_get_latest_logged_call_response import LocalTestingOnlyGetLatestLoggedCallResponse
from .types.report_request_tags_value import ReportRequestTagsValue
from .types.report_response import ReportResponse
from .types.unstable_dataset_create_response import UnstableDatasetCreateResponse
from .types.unstable_dataset_entry_create_request_entries_item import UnstableDatasetEntryCreateRequestEntriesItem
from .types.unstable_dataset_entry_create_response import UnstableDatasetEntryCreateResponse
from .types.unstable_finetune_create_request_base_model import UnstableFinetuneCreateRequestBaseModel
from .types.unstable_finetune_create_response import UnstableFinetuneCreateResponse
from .types.unstable_finetune_get_response import UnstableFinetuneGetResponse
from .types.update_log_tags_request_filters_item import UpdateLogTagsRequestFiltersItem
from .types.update_log_tags_request_tags_value import UpdateLogTagsRequestTagsValue
from .types.update_log_tags_response import UpdateLogTagsResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OpenPipeApi:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: OpenPipeApiEnvironment = OpenPipeApiEnvironment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = 240,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx.Client(timeout=timeout) if httpx_client is None else httpx_client,
        )

    def check_cache(
        self,
        *,
        requested_at: float,
        req_payload: typing.Optional[typing.Any] = OMIT,
        tags: typing.Optional[typing.Dict[str, str]] = OMIT,
    ) -> CheckCacheResponse:
        """
        DEPRECATED: we no longer support prompt caching.

        Parameters:
            - requested_at: float. Unix timestamp in milliseconds

            - req_payload: typing.Optional[typing.Any].

            - tags: typing.Optional[typing.Dict[str, str]]. Extra tags to attach to the call for filtering. Eg { "userId": "123", "promptId": "populate-title" }
        """
        _request: typing.Dict[str, typing.Any] = {"requestedAt": requested_at}
        if req_payload is not OMIT:
            _request["reqPayload"] = req_payload
        if tags is not OMIT:
            _request["tags"] = tags
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "check-cache"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CheckCacheResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_chat_completion(
        self,
        *,
        req_payload: typing.Optional[CreateChatCompletionRequestReqPayload] = OMIT,
        model: typing.Optional[str] = OMIT,
        messages: typing.Optional[typing.List[CreateChatCompletionRequestMessagesItem]] = OMIT,
        function_call: typing.Optional[CreateChatCompletionRequestFunctionCall] = OMIT,
        functions: typing.Optional[typing.List[CreateChatCompletionRequestFunctionsItem]] = OMIT,
        tool_choice: typing.Optional[CreateChatCompletionRequestToolChoice] = OMIT,
        tools: typing.Optional[typing.List[CreateChatCompletionRequestToolsItem]] = OMIT,
        n: typing.Optional[float] = OMIT,
        max_tokens: typing.Optional[float] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        stream: typing.Optional[bool] = OMIT,
        response_format: typing.Optional[CreateChatCompletionRequestResponseFormat] = OMIT,
    ) -> CreateChatCompletionResponse:
        """
        OpenAI-compatible route for generating inference and optionally logging the request.

        Parameters:
            - req_payload: typing.Optional[CreateChatCompletionRequestReqPayload]. DEPRECATED. Use the top-level fields instead

            - model: typing.Optional[str].

            - messages: typing.Optional[typing.List[CreateChatCompletionRequestMessagesItem]].

            - function_call: typing.Optional[CreateChatCompletionRequestFunctionCall].

            - functions: typing.Optional[typing.List[CreateChatCompletionRequestFunctionsItem]].

            - tool_choice: typing.Optional[CreateChatCompletionRequestToolChoice].

            - tools: typing.Optional[typing.List[CreateChatCompletionRequestToolsItem]].

            - n: typing.Optional[float].

            - max_tokens: typing.Optional[float].

            - temperature: typing.Optional[float].

            - stream: typing.Optional[bool].

            - response_format: typing.Optional[CreateChatCompletionRequestResponseFormat].
        """
        _request: typing.Dict[str, typing.Any] = {}
        if req_payload is not OMIT:
            _request["reqPayload"] = req_payload
        if model is not OMIT:
            _request["model"] = model
        if messages is not OMIT:
            _request["messages"] = messages
        if function_call is not OMIT:
            _request["function_call"] = function_call
        if functions is not OMIT:
            _request["functions"] = functions
        if tool_choice is not OMIT:
            _request["tool_choice"] = tool_choice
        if tools is not OMIT:
            _request["tools"] = tools
        if n is not OMIT:
            _request["n"] = n
        if max_tokens is not OMIT:
            _request["max_tokens"] = max_tokens
        if temperature is not OMIT:
            _request["temperature"] = temperature
        if stream is not OMIT:
            _request["stream"] = stream
        if response_format is not OMIT:
            _request["response_format"] = response_format
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "chat/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateChatCompletionResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def report(
        self,
        *,
        requested_at: typing.Optional[float] = OMIT,
        received_at: typing.Optional[float] = OMIT,
        req_payload: typing.Optional[typing.Any] = OMIT,
        resp_payload: typing.Optional[typing.Any] = OMIT,
        status_code: typing.Optional[float] = OMIT,
        error_message: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Dict[str, ReportRequestTagsValue]] = OMIT,
    ) -> ReportResponse:
        """
        Report an API call

        Parameters:
            - requested_at: typing.Optional[float]. Unix timestamp in milliseconds

            - received_at: typing.Optional[float]. Unix timestamp in milliseconds

            - req_payload: typing.Optional[typing.Any].

            - resp_payload: typing.Optional[typing.Any].

            - status_code: typing.Optional[float]. HTTP status code of response

            - error_message: typing.Optional[str]. User-friendly error message

            - tags: typing.Optional[typing.Dict[str, ReportRequestTagsValue]]. Extra tags to attach to the call for filtering. Eg { "userId": "123", "promptId": "populate-title" }
        ---
        from OpenPipe.client import OpenPipeApi

        client = OpenPipeApi(
            token="YOUR_TOKEN",
        )
        client.report()
        """
        _request: typing.Dict[str, typing.Any] = {}
        if requested_at is not OMIT:
            _request["requestedAt"] = requested_at
        if received_at is not OMIT:
            _request["receivedAt"] = received_at
        if req_payload is not OMIT:
            _request["reqPayload"] = req_payload
        if resp_payload is not OMIT:
            _request["respPayload"] = resp_payload
        if status_code is not OMIT:
            _request["statusCode"] = status_code
        if error_message is not OMIT:
            _request["errorMessage"] = error_message
        if tags is not OMIT:
            _request["tags"] = tags
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "report"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ReportResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_log_tags(
        self,
        *,
        filters: typing.List[UpdateLogTagsRequestFiltersItem],
        tags: typing.Dict[str, UpdateLogTagsRequestTagsValue],
    ) -> UpdateLogTagsResponse:
        """
        Update tags for logged calls matching the provided filters

        Parameters:
            - filters: typing.List[UpdateLogTagsRequestFiltersItem].

            - tags: typing.Dict[str, UpdateLogTagsRequestTagsValue]. Extra tags to attach to the call for filtering. Eg { "userId": "123", "promptId": "populate-title" }
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "logs/update-tags"),
            json=jsonable_encoder({"filters": filters, "tags": tags}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UpdateLogTagsResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def local_testing_only_get_latest_logged_call(self) -> typing.Optional[LocalTestingOnlyGetLatestLoggedCallResponse]:
        """
        Get the latest logged call (only for local testing)
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "local-testing-only-get-latest-logged-call"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Optional[LocalTestingOnlyGetLatestLoggedCallResponse], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def unstable_dataset_create(self, *, name: str) -> UnstableDatasetCreateResponse:
        """
        Create a new dataset. Note, this endpoint is unstable and may change without notice. Do not use without consulting the OpenPipe team.

        Parameters:
            - name: str.
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "unstable/dataset/create"),
            json=jsonable_encoder({"name": name}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UnstableDatasetCreateResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def unstable_dataset_entry_create(
        self, *, archive_id: str, entries: typing.List[UnstableDatasetEntryCreateRequestEntriesItem]
    ) -> UnstableDatasetEntryCreateResponse:
        """
        Add new dataset entries. Note, this endpoint is unstable and may change without notice. Do not use without consulting the OpenPipe team.

        Parameters:
            - archive_id: str.

            - entries: typing.List[UnstableDatasetEntryCreateRequestEntriesItem].
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "unstable/dataset-entry/create"),
            json=jsonable_encoder({"archiveId": archive_id, "entries": entries}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UnstableDatasetEntryCreateResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def unstable_finetune_create(
        self, *, dataset_id: str, slug: str, base_model: UnstableFinetuneCreateRequestBaseModel
    ) -> UnstableFinetuneCreateResponse:
        """
        Create a new finetune. Note, this endpoint is unstable and may change without notice. Do not use without consulting the OpenPipe team.

        Parameters:
            - dataset_id: str.

            - slug: str.

            - base_model: UnstableFinetuneCreateRequestBaseModel.
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "unstable/finetune/create"),
            json=jsonable_encoder({"datasetId": dataset_id, "slug": slug, "baseModel": base_model}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UnstableFinetuneCreateResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def unstable_finetune_get(self, *, fine_tune_id: str) -> UnstableFinetuneGetResponse:
        """
        Get a finetune by ID. Note, this endpoint is unstable and may change without notice. Do not use without consulting the OpenPipe team.

        Parameters:
            - fine_tune_id: str.
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "unstable/finetune/get"),
            params=remove_none_from_dict({"fineTuneId": fine_tune_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UnstableFinetuneGetResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncOpenPipeApi:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: OpenPipeApiEnvironment = OpenPipeApiEnvironment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = 240,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx.AsyncClient(timeout=timeout) if httpx_client is None else httpx_client,
        )

    async def check_cache(
        self,
        *,
        requested_at: float,
        req_payload: typing.Optional[typing.Any] = OMIT,
        tags: typing.Optional[typing.Dict[str, str]] = OMIT,
    ) -> CheckCacheResponse:
        """
        DEPRECATED: we no longer support prompt caching.

        Parameters:
            - requested_at: float. Unix timestamp in milliseconds

            - req_payload: typing.Optional[typing.Any].

            - tags: typing.Optional[typing.Dict[str, str]]. Extra tags to attach to the call for filtering. Eg { "userId": "123", "promptId": "populate-title" }
        """
        _request: typing.Dict[str, typing.Any] = {"requestedAt": requested_at}
        if req_payload is not OMIT:
            _request["reqPayload"] = req_payload
        if tags is not OMIT:
            _request["tags"] = tags
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "check-cache"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CheckCacheResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_chat_completion(
        self,
        *,
        req_payload: typing.Optional[CreateChatCompletionRequestReqPayload] = OMIT,
        model: typing.Optional[str] = OMIT,
        messages: typing.Optional[typing.List[CreateChatCompletionRequestMessagesItem]] = OMIT,
        function_call: typing.Optional[CreateChatCompletionRequestFunctionCall] = OMIT,
        functions: typing.Optional[typing.List[CreateChatCompletionRequestFunctionsItem]] = OMIT,
        tool_choice: typing.Optional[CreateChatCompletionRequestToolChoice] = OMIT,
        tools: typing.Optional[typing.List[CreateChatCompletionRequestToolsItem]] = OMIT,
        n: typing.Optional[float] = OMIT,
        max_tokens: typing.Optional[float] = OMIT,
        temperature: typing.Optional[float] = OMIT,
        stream: typing.Optional[bool] = OMIT,
        response_format: typing.Optional[CreateChatCompletionRequestResponseFormat] = OMIT,
    ) -> CreateChatCompletionResponse:
        """
        OpenAI-compatible route for generating inference and optionally logging the request.

        Parameters:
            - req_payload: typing.Optional[CreateChatCompletionRequestReqPayload]. DEPRECATED. Use the top-level fields instead

            - model: typing.Optional[str].

            - messages: typing.Optional[typing.List[CreateChatCompletionRequestMessagesItem]].

            - function_call: typing.Optional[CreateChatCompletionRequestFunctionCall].

            - functions: typing.Optional[typing.List[CreateChatCompletionRequestFunctionsItem]].

            - tool_choice: typing.Optional[CreateChatCompletionRequestToolChoice].

            - tools: typing.Optional[typing.List[CreateChatCompletionRequestToolsItem]].

            - n: typing.Optional[float].

            - max_tokens: typing.Optional[float].

            - temperature: typing.Optional[float].

            - stream: typing.Optional[bool].

            - response_format: typing.Optional[CreateChatCompletionRequestResponseFormat].
        """
        _request: typing.Dict[str, typing.Any] = {}
        if req_payload is not OMIT:
            _request["reqPayload"] = req_payload
        if model is not OMIT:
            _request["model"] = model
        if messages is not OMIT:
            _request["messages"] = messages
        if function_call is not OMIT:
            _request["function_call"] = function_call
        if functions is not OMIT:
            _request["functions"] = functions
        if tool_choice is not OMIT:
            _request["tool_choice"] = tool_choice
        if tools is not OMIT:
            _request["tools"] = tools
        if n is not OMIT:
            _request["n"] = n
        if max_tokens is not OMIT:
            _request["max_tokens"] = max_tokens
        if temperature is not OMIT:
            _request["temperature"] = temperature
        if stream is not OMIT:
            _request["stream"] = stream
        if response_format is not OMIT:
            _request["response_format"] = response_format
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "chat/completions"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateChatCompletionResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def report(
        self,
        *,
        requested_at: typing.Optional[float] = OMIT,
        received_at: typing.Optional[float] = OMIT,
        req_payload: typing.Optional[typing.Any] = OMIT,
        resp_payload: typing.Optional[typing.Any] = OMIT,
        status_code: typing.Optional[float] = OMIT,
        error_message: typing.Optional[str] = OMIT,
        tags: typing.Optional[typing.Dict[str, ReportRequestTagsValue]] = OMIT,
    ) -> ReportResponse:
        """
        Report an API call

        Parameters:
            - requested_at: typing.Optional[float]. Unix timestamp in milliseconds

            - received_at: typing.Optional[float]. Unix timestamp in milliseconds

            - req_payload: typing.Optional[typing.Any].

            - resp_payload: typing.Optional[typing.Any].

            - status_code: typing.Optional[float]. HTTP status code of response

            - error_message: typing.Optional[str]. User-friendly error message

            - tags: typing.Optional[typing.Dict[str, ReportRequestTagsValue]]. Extra tags to attach to the call for filtering. Eg { "userId": "123", "promptId": "populate-title" }
        ---
        from OpenPipe.client import AsyncOpenPipeApi

        client = AsyncOpenPipeApi(
            token="YOUR_TOKEN",
        )
        await client.report()
        """
        _request: typing.Dict[str, typing.Any] = {}
        if requested_at is not OMIT:
            _request["requestedAt"] = requested_at
        if received_at is not OMIT:
            _request["receivedAt"] = received_at
        if req_payload is not OMIT:
            _request["reqPayload"] = req_payload
        if resp_payload is not OMIT:
            _request["respPayload"] = resp_payload
        if status_code is not OMIT:
            _request["statusCode"] = status_code
        if error_message is not OMIT:
            _request["errorMessage"] = error_message
        if tags is not OMIT:
            _request["tags"] = tags
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "report"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ReportResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_log_tags(
        self,
        *,
        filters: typing.List[UpdateLogTagsRequestFiltersItem],
        tags: typing.Dict[str, UpdateLogTagsRequestTagsValue],
    ) -> UpdateLogTagsResponse:
        """
        Update tags for logged calls matching the provided filters

        Parameters:
            - filters: typing.List[UpdateLogTagsRequestFiltersItem].

            - tags: typing.Dict[str, UpdateLogTagsRequestTagsValue]. Extra tags to attach to the call for filtering. Eg { "userId": "123", "promptId": "populate-title" }
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "logs/update-tags"),
            json=jsonable_encoder({"filters": filters, "tags": tags}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UpdateLogTagsResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def local_testing_only_get_latest_logged_call(
        self,
    ) -> typing.Optional[LocalTestingOnlyGetLatestLoggedCallResponse]:
        """
        Get the latest logged call (only for local testing)
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", "local-testing-only-get-latest-logged-call"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(typing.Optional[LocalTestingOnlyGetLatestLoggedCallResponse], _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def unstable_dataset_create(self, *, name: str) -> UnstableDatasetCreateResponse:
        """
        Create a new dataset. Note, this endpoint is unstable and may change without notice. Do not use without consulting the OpenPipe team.

        Parameters:
            - name: str.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "unstable/dataset/create"),
            json=jsonable_encoder({"name": name}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UnstableDatasetCreateResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def unstable_dataset_entry_create(
        self, *, archive_id: str, entries: typing.List[UnstableDatasetEntryCreateRequestEntriesItem]
    ) -> UnstableDatasetEntryCreateResponse:
        """
        Add new dataset entries. Note, this endpoint is unstable and may change without notice. Do not use without consulting the OpenPipe team.

        Parameters:
            - archive_id: str.

            - entries: typing.List[UnstableDatasetEntryCreateRequestEntriesItem].
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "unstable/dataset-entry/create"),
            json=jsonable_encoder({"archiveId": archive_id, "entries": entries}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UnstableDatasetEntryCreateResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def unstable_finetune_create(
        self, *, dataset_id: str, slug: str, base_model: UnstableFinetuneCreateRequestBaseModel
    ) -> UnstableFinetuneCreateResponse:
        """
        Create a new finetune. Note, this endpoint is unstable and may change without notice. Do not use without consulting the OpenPipe team.

        Parameters:
            - dataset_id: str.

            - slug: str.

            - base_model: UnstableFinetuneCreateRequestBaseModel.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "unstable/finetune/create"),
            json=jsonable_encoder({"datasetId": dataset_id, "slug": slug, "baseModel": base_model}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UnstableFinetuneCreateResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def unstable_finetune_get(self, *, fine_tune_id: str) -> UnstableFinetuneGetResponse:
        """
        Get a finetune by ID. Note, this endpoint is unstable and may change without notice. Do not use without consulting the OpenPipe team.

        Parameters:
            - fine_tune_id: str.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "unstable/finetune/get"),
            params=remove_none_from_dict({"fineTuneId": fine_tune_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=240,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UnstableFinetuneGetResponse, _response.json())  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: OpenPipeApiEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
