/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.openide.util.Parameters;

public final class ImageUtilities {
    static final String TOOLTIP_SEPAR = "<br>";
    private static final Set<String> extraInitialSlashes = new HashSet<String>();
    private static final Component component = new Component(){};
    private static final MediaTracker tracker = new MediaTracker(component);
    private static int mediaTrackerID;
    private static ImageReader PNG_READER;
    private static final Logger ERR;

    private ImageUtilities() {
    }

    public static final Image loadImage(String resourceID) {
        return ImageUtilities.getIcon(resourceID);
    }

    public static final Image loadImage(String resource, boolean localized) {
        return ImageUtilities.getIcon(resource);
    }

    public static final ImageIcon loadImageIcon(String resource, boolean localized) {
        Image image = ImageUtilities.getIcon(resource);
        return image == null ? null : (ImageIcon)ImageUtilities.image2Icon(image);
    }

    public static final Icon image2Icon(Image image) {
        if (image instanceof ToolTipImage) {
            return ((ToolTipImage)image).getIcon();
        }
        return new ImageIcon(image);
    }

    public static final Image icon2Image(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        ToolTipImage image = new ToolTipImage("", icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics g = image.getGraphics();
        icon.paintIcon(new JLabel(), g, 0, 0);
        g.dispose();
        return image;
    }

    public static Icon createDisabledIcon(Icon icon) {
        Parameters.notNull("icon", icon);
        return new LazyDisabledIcon(ImageUtilities.icon2Image(icon));
    }

    public static Image createDisabledImage(Image image) {
        Parameters.notNull("image", image);
        return LazyDisabledIcon.createDisabledImage(image);
    }

    private static Image getIcon(String name) {
        BufferedImage result;
        URL url;
        String n;
        boolean warn;
        block10: {
            if (name.startsWith("/")) {
                warn = true;
                n = name.substring(1);
            } else {
                warn = false;
                n = name;
            }
            url = ImageUtilities.class.getClassLoader().getResource(n);
            result = null;
            try {
                if (url == null) break block10;
                if (name.endsWith(".png")) {
                    ImageInputStream stream = ImageIO.createImageInputStream(url.openStream());
                    ImageReadParam param = PNG_READER.getDefaultReadParam();
                    try {
                        PNG_READER.setInput(stream, true, true);
                        result = PNG_READER.read(0, param);
                    }
                    catch (IOException ioe1) {
                        ERR.log(Level.INFO, "Image " + name + " is not PNG", ioe1);
                    }
                    stream.close();
                }
                if (result == null) {
                    result = ImageIO.read(url);
                }
            }
            catch (IOException ioe) {
                ERR.log(Level.WARNING, "Cannot load " + name + " image", ioe);
            }
        }
        if (result != null) {
            if (warn && extraInitialSlashes.add(name)) {
                ERR.warning("Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + name);
            }
            ERR.log(Level.FINE, "loading icon {0} = {1}", new Object[]{n, result});
            name = new String(name).intern();
            result = ToolTipImage.createNew("", result, url);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = ++mediaTrackerID;
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            assert (tracker.statusID(id, false) == 8) : "Image loaded";
            tracker.removeImage(image, id);
        }
    }

    private static ColorModel colorModel(int transparency) {
        ColorModel model;
        try {
            model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(transparency);
        }
        catch (HeadlessException he) {
            model = ColorModel.getRGBdefault();
        }
        return model;
    }

    static {
        ERR = Logger.getLogger(ImageUtilities.class.getName());
        ImageIO.setUseCache(false);
        PNG_READER = ImageIO.getImageReadersByMIMEType("image/png").next();
    }

    private static class DisabledButtonFilter
    extends RGBImageFilter {
        DisabledButtonFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            return (rgb & 0xFF000000) + 0x888888 + ((rgb >> 16 & 0xFF) >> 2 << 16) + ((rgb >> 8 & 0xFF) >> 2 << 8) + ((rgb & 0xFF) >> 2);
        }

        @Override
        public void setProperties(Hashtable<?, ?> props) {
            props = (Hashtable)props.clone();
            this.consumer.setProperties(props);
        }
    }

    private static class LazyDisabledIcon
    implements Icon {
        private static final RGBImageFilter DISABLED_BUTTON_FILTER = new DisabledButtonFilter();
        private Image img;
        private Icon disabledIcon;

        public LazyDisabledIcon(Image img) {
            assert (null != img);
            this.img = img;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getDisabledIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getDisabledIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getDisabledIcon().getIconHeight();
        }

        private synchronized Icon getDisabledIcon() {
            if (null == this.disabledIcon) {
                this.disabledIcon = new ImageIcon(LazyDisabledIcon.createDisabledImage(this.img));
            }
            return this.disabledIcon;
        }

        static Image createDisabledImage(Image img) {
            FilteredImageSource prod = new FilteredImageSource(img.getSource(), DISABLED_BUTTON_FILTER);
            return Toolkit.getDefaultToolkit().createImage(prod);
        }
    }

    private static class ToolTipImage
    extends BufferedImage
    implements Icon {
        final String toolTipText;
        ImageIcon imageIcon;
        final URL url;

        public static ToolTipImage createNew(String toolTipText, Image image, URL url) {
            ImageUtilities.ensureLoaded(image);
            boolean bitmask = image instanceof Transparency && ((Transparency)((Object)image)).getTransparency() != 3;
            ColorModel model = ImageUtilities.colorModel(bitmask ? 2 : 3);
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            ToolTipImage newImage = new ToolTipImage(toolTipText, model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null, url);
            Graphics2D g = newImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return newImage;
        }

        public ToolTipImage(String toolTipText, ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties, URL url) {
            super(cm, raster, isRasterPremultiplied, properties);
            this.toolTipText = toolTipText;
            this.url = url;
        }

        public ToolTipImage(String toolTipText, int width, int height, int imageType) {
            super(width, height, imageType);
            this.toolTipText = toolTipText;
            this.url = null;
        }

        synchronized ImageIcon getIcon() {
            if (this.imageIcon == null) {
                this.imageIcon = new ImageIcon(this);
            }
            return this.imageIcon;
        }

        @Override
        public int getIconHeight() {
            return super.getHeight();
        }

        @Override
        public int getIconWidth() {
            return super.getWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this, x, y, null);
        }

        @Override
        public Object getProperty(String name, ImageObserver observer) {
            if ("url".equals(name)) {
                if (this.url != null) {
                    return this.url;
                }
                return this.imageIcon.getImage().getProperty("url", observer);
            }
            return super.getProperty(name, observer);
        }
    }

    private static class ToolTipImageKey {
        Image image;
        String str;

        ToolTipImageKey(Image image, String str) {
            this.image = image;
            this.str = str;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ToolTipImageKey)) {
                return false;
            }
            ToolTipImageKey k = (ToolTipImageKey)other;
            return this.str.equals(k.str) && this.image == k.image;
        }

        public int hashCode() {
            int hash = this.image.hashCode() ^ this.str.hashCode();
            return hash;
        }

        public String toString() {
            return "ImageStringKey for " + this.image + " + " + this.str;
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image base, Image overlay, int x, int y) {
            this.x = x;
            this.y = y;
            this.baseImage = base;
            this.overlayImage = overlay;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey k = (CompositeImageKey)other;
            return this.x == k.x && this.y == k.y && this.baseImage == k.baseImage && this.overlayImage == k.overlayImage;
        }

        public int hashCode() {
            int hash = (this.x << 3 ^ this.y) << 4;
            hash = hash ^ this.baseImage.hashCode() ^ this.overlayImage.hashCode();
            return hash;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }
}

