/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import javax.annotation.Nonnull;
import jpsxdec.util.player.PlayController;
import jpsxdec.util.player.PlayerException;
import jpsxdec.util.player.ThreadSafeEventListeners;

abstract class VideoTimer {
    private static final int FRAME_DELAY_NANO_FUDGE_TIME = 50;
    private static final boolean DEBUG = false;
    @Nonnull
    private State _state = State.PAUSED;
    private final ThreadSafeEventListeners _listeners = new ThreadSafeEventListeners();

    VideoTimer() {
    }

    public synchronized void go() {
        this._state = State.RUNNING;
        this.notifyAll();
    }

    public void pause() {
        this._state = State.PAUSED;
    }

    public boolean isPaused() {
        return this._state == State.PAUSED;
    }

    public synchronized void terminate() {
        this._state = State.TERMINATED;
        this.notifyAll();
    }

    abstract void initPaused() throws PlayerException;

    public abstract void videoDone();

    protected abstract long getNanoTime();

    public final synchronized boolean shouldBeProcessed(long lngPresentationNanos) {
        if (this._state == State.RUNNING || this._state == State.PAUSED) {
            long lngPlayTime = this.getNanoTime();
            return lngPresentationNanos >= lngPlayTime;
        }
        return false;
    }

    @Nonnull
    public final synchronized ShowFrame waitToPresentFrame(long lngPresentationNanos) throws InterruptedException {
        while (true) {
            if (this._state == State.TERMINATED) {
                return ShowFrame.CLOSED;
            }
            if (this._state == State.PAUSED) {
                this.wait();
                continue;
            }
            long lngPos = this.getNanoTime();
            long lngSleepNanos = lngPresentationNanos - lngPos;
            if (lngSleepNanos <= 50L) break;
            this.wait((lngSleepNanos -= 50L) / 1000000L, (int)(lngSleepNanos % 1000000L));
        }
        return ShowFrame.YES;
    }

    public boolean isTerminated() {
        return this._state == State.TERMINATED;
    }

    public void addEventListener(@Nonnull PlayController.PlayerListener listener) {
        this._listeners.addEventListener(listener);
    }

    public void removeEventListener(@Nonnull PlayController.PlayerListener listener) {
        this._listeners.removeEventListener(listener);
    }

    protected void fire(@Nonnull PlayController.Event event) {
        this._listeners.fire(event);
    }

    private static enum State {
        RUNNING,
        PAUSED,
        TERMINATED;

    }

    public static enum ShowFrame {
        YES,
        NO,
        CLOSED;

    }
}

