/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferStrategy;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.Fraction;
import jpsxdec.util.player.DecodedVideoFrame;
import jpsxdec.util.player.PlayController;

class VideoScreen
extends Canvas {
    private final int _iWidth;
    private final int _iHeight;
    @Nonnull
    private Fraction _aspectRatio = PlayController.PAL_ASPECT_RATIO;
    @Nonnull
    private Dimension _minDims;
    @Nonnull
    private Object _renderingHintInterpolation = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    @CheckForNull
    private transient BufferStrategy _buffStrategy;
    @CheckForNull
    private transient DecodedVideoFrame _currentFrame;
    private boolean _blnSquashWidth = false;

    public VideoScreen(int iWidth, int iHeight) {
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        this.setBackground(Color.BLACK);
        this.updateDims();
    }

    public void setAspectRatio(@Nonnull Fraction aspectRatio) {
        this._aspectRatio = aspectRatio;
        this.updateDims();
    }

    public void setRenderingHint(Object interpolation) {
        this._renderingHintInterpolation = interpolation;
    }

    public void setSquashWidth(boolean blnSquash) {
        this._blnSquashWidth = blnSquash;
        this.updateDims();
    }

    private int getSrcWidth() {
        if (this._blnSquashWidth && this._iWidth > 320) {
            return 320;
        }
        return this._iWidth;
    }

    private void updateDims() {
        this._minDims = new Dimension(this.getSrcWidth(), (int)((long)this._iHeight * this._aspectRatio.getNumerator() / this._aspectRatio.getDenominator()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImage(@Nonnull DecodedVideoFrame frame) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this._currentFrame = frame;
            if (this._currentFrame == null) {
                return;
            }
            if (!this.isDisplayable()) {
                System.out.println("Trying to play frame when canvas is hidden");
                return;
            }
            if (this.getWidth() == 0 || this.getHeight() == 0) {
                return;
            }
            if (this._buffStrategy == null) {
                this.createBufferStrategy(2);
                System.out.println("BufferStrategy created");
                this._buffStrategy = this.getBufferStrategy();
            }
            Graphics g = this._buffStrategy.getDrawGraphics();
            this.paint(g);
            g.dispose();
            this._buffStrategy.show();
        }
    }

    @Override
    public void paint(@Nonnull Graphics g) {
        int iDispH;
        int iDispW;
        int iWinW = this.getWidth();
        int iWinH = this.getHeight();
        g.setColor(Color.black);
        g.fillRect(0, 0, iWinW, iWinH);
        float fltConvertAspectRatio = (float)((long)this.getSrcWidth() * this._aspectRatio.getDenominator()) / (float)((long)this._iHeight * this._aspectRatio.getNumerator());
        float fltWinAspectRatio = (float)iWinW / (float)iWinH;
        if (fltConvertAspectRatio > fltWinAspectRatio) {
            iDispW = iWinW;
            iDispH = (int)((float)iDispW / fltConvertAspectRatio);
        } else {
            iDispH = iWinH;
            iDispW = (int)((float)iDispH * fltConvertAspectRatio);
        }
        int iOfsX = (iWinW - iDispW) / 2;
        int iOfsY = (iWinH - iDispH) / 2;
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, this._renderingHintInterpolation);
        }
        if (this._currentFrame != null) {
            g.drawImage(this._currentFrame.image, iOfsX, iOfsY, iDispW, iDispH, null);
        }
    }

    @Override
    public Dimension getMaximumSize() {
        return null;
    }

    @Override
    public Dimension getMinimumSize() {
        return this._minDims;
    }

    @Override
    public Dimension getPreferredSize() {
        return this._minDims;
    }
}

