/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import javax.annotation.Nonnull;
import jpsxdec.util.player.ClosableBoundedBlockingQueue;
import jpsxdec.util.player.DecodableFrame;
import jpsxdec.util.player.DecodedVideoFrame;
import jpsxdec.util.player.IFrameProcessor;
import jpsxdec.util.player.IPreprocessedFrameWriter;
import jpsxdec.util.player.StopPlayingException;
import jpsxdec.util.player.VideoPlayer;
import jpsxdec.util.player.VideoTimer;

class VideoProcessor
implements Runnable,
IPreprocessedFrameWriter {
    private static final boolean DEBUG = false;
    private static final int CAPACITY = 50;
    private final ClosableBoundedBlockingQueue<DecodableFrame<?>> _framesProcessingQueue = new ClosableBoundedBlockingQueue(50);
    @Nonnull
    private final VideoTimer _vidTimer;
    @Nonnull
    private final VideoPlayer _vidPlayer;
    @Nonnull
    private final Thread _thread;
    private IFrameProcessor _processor;

    VideoProcessor(@Nonnull VideoTimer timer, @Nonnull VideoPlayer player) {
        this._vidTimer = timer;
        this._vidPlayer = player;
        this._thread = new Thread((Runnable)this, this.getClass().getName());
    }

    public void setProcessor(@Nonnull IFrameProcessor<?> processor) {
        this._processor = processor;
    }

    public void start() {
        if (this._processor == null) {
            throw new IllegalStateException();
        }
        this._thread.start();
    }

    @Override
    public void run() {
        int[] aiImage = new int[this._vidPlayer.getWidth() * this._vidPlayer.getHeight()];
        try {
            DecodableFrame<?> decodeFrame;
            while ((decodeFrame = this._framesProcessingQueue.take()) != null) {
                if (this._vidTimer.shouldBeProcessed(decodeFrame.lngPresentationNanos)) {
                    DecodedVideoFrame frame = new DecodedVideoFrame(this._vidPlayer.getWidth(), this._vidPlayer.getHeight());
                    frame.lngPresentationNanos = decodeFrame.lngPresentationNanos;
                    this._processor.processFrame(decodeFrame.frame, aiImage);
                    frame.image.setRGB(0, 0, frame.image.getWidth(), frame.image.getHeight(), aiImage, 0, frame.image.getWidth());
                    this._vidPlayer.addFrame(frame);
                    continue;
                }
                System.out.println("Processor skipping frame :(");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.terminate();
            return;
        }
        System.out.println("VideoProcessor ending");
        this._vidPlayer.finish();
    }

    @Override
    public void writeFrame(@Nonnull Object frame, long lngPresentationNanos) throws StopPlayingException {
        try {
            if (!this._framesProcessingQueue.add(new DecodableFrame<Object>(frame, lngPresentationNanos))) {
                throw new StopPlayingException();
            }
        }
        catch (InterruptedException ex) {
            throw new StopPlayingException(ex);
        }
    }

    public void finish() {
        System.out.println("VideoProcessor request to end");
        this._framesProcessingQueue.closeWhenEmpty();
    }

    public void terminate() {
        this._framesProcessingQueue.closeNow();
        this._vidPlayer.terminate();
    }
}

