/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import javax.annotation.Nonnull;
import jpsxdec.util.player.ClosableBoundedBlockingQueue;
import jpsxdec.util.player.DecodedVideoFrame;
import jpsxdec.util.player.VideoScreen;
import jpsxdec.util.player.VideoTimer;

class VideoPlayer
implements Runnable {
    private static final boolean DEBUG = false;
    private static final int CAPACITY = 50;
    private final ClosableBoundedBlockingQueue<DecodedVideoFrame> _frameDisplayQueue = new ClosableBoundedBlockingQueue(50);
    private final int _iWidth;
    private final int _iHeight;
    @Nonnull
    private final VideoScreen _screen;
    @Nonnull
    private final VideoTimer _vidTimer;
    @Nonnull
    private final Thread _thread;

    public VideoPlayer(@Nonnull VideoTimer vidTimer, int iWidth, int iHeight) {
        this._vidTimer = vidTimer;
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        this._screen = new VideoScreen(this._iWidth, this._iHeight);
        this._thread = new Thread((Runnable)this, this.getClass().getName());
    }

    public void startup() {
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DecodedVideoFrame frame;
            while ((frame = this._frameDisplayQueue.take()) != null) {
                VideoTimer.ShowFrame showFrame = this._vidTimer.waitToPresentFrame(frame.lngPresentationNanos);
                if (showFrame == VideoTimer.ShowFrame.CLOSED) {
                    break;
                }
                if (showFrame == VideoTimer.ShowFrame.NO) {
                    System.out.println("Timer says to discard frame");
                    continue;
                }
                this._screen.updateImage(frame);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this._vidTimer.terminate();
        }
        finally {
            System.out.println("VideoPlayer ending");
            this._frameDisplayQueue.closeNow();
            this._vidTimer.videoDone();
        }
    }

    public void addFrame(@Nonnull DecodedVideoFrame frame) throws InterruptedException {
        this._frameDisplayQueue.add(frame);
    }

    @Nonnull
    public VideoScreen getScreen() {
        return this._screen;
    }

    public void terminate() {
        this._frameDisplayQueue.closeNow();
        this._vidTimer.terminate();
    }

    public void pause() {
        this._vidTimer.pause();
    }

    public void unpause() {
        this._vidTimer.go();
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    public void finish() {
        System.out.println("VideoPlayer request to end (if not already terminated)");
        this._frameDisplayQueue.closeWhenEmpty();
    }
}

