/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import javax.annotation.Nonnull;
import jpsxdec.util.player.ClosableBoundedBlockingQueue;
import jpsxdec.util.player.PlayController;
import jpsxdec.util.player.VideoTimer;

class VideoClock
extends VideoTimer
implements Runnable {
    private long _lngStartTime = -1L;
    private long _lngPausedTime = -1L;
    @Nonnull
    private final Thread _eventThread;
    private final ClosableBoundedBlockingQueue<PlayController.Event> _eventQueue = new ClosableBoundedBlockingQueue(100);

    public VideoClock() {
        this._eventThread = new Thread((Runnable)this, this.getClass().getName() + " event dispatcher");
    }

    @Override
    public synchronized void initPaused() {
        this._eventThread.start();
    }

    @Override
    public synchronized void go() {
        if (this._lngStartTime < 0L) {
            this._lngStartTime = System.nanoTime();
        } else if (this._lngPausedTime >= 0L) {
            this._lngStartTime += System.nanoTime() - this._lngPausedTime;
            this._lngPausedTime = -1L;
        } else {
            return;
        }
        super.go();
        this._eventQueue.addWithCapacityCheck(PlayController.Event.Play);
    }

    @Override
    public synchronized void pause() {
        this._lngPausedTime = System.nanoTime();
        super.pause();
        this._eventQueue.addWithCapacityCheck(PlayController.Event.Play);
    }

    @Override
    public synchronized long getNanoTime() {
        if (this._lngStartTime < 0L) {
            return 0L;
        }
        if (this._lngPausedTime >= 0L) {
            return this._lngPausedTime - this._lngStartTime;
        }
        return System.nanoTime() - this._lngStartTime;
    }

    @Override
    public synchronized void videoDone() {
        super.terminate();
        try {
            this._eventQueue.add(PlayController.Event.End);
            this._eventQueue.closeWhenEmpty();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public synchronized void terminate() {
        this._eventQueue.closeNow();
        super.terminate();
    }

    @Override
    public void run() {
        try {
            PlayController.Event event;
            while ((event = this._eventQueue.take()) != null) {
                this.fire(event);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

