/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.player.PlayController;

class ThreadSafeEventListeners {
    @CheckForNull
    protected WeakHashMap<PlayController.PlayerListener, Boolean> _listeners;

    ThreadSafeEventListeners() {
    }

    public synchronized void addEventListener(@Nonnull PlayController.PlayerListener listener) {
        if (this._listeners == null) {
            this._listeners = new WeakHashMap();
        }
        this._listeners.put(listener, Boolean.TRUE);
    }

    public synchronized void removeEventListener(@Nonnull PlayController.PlayerListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(@Nonnull PlayController.Event event) {
        if (this._listeners != null) {
            ArrayList<PlayController.PlayerListener> listeners;
            ThreadSafeEventListeners threadSafeEventListeners = this;
            synchronized (threadSafeEventListeners) {
                listeners = new ArrayList<PlayController.PlayerListener>(this._listeners.keySet());
            }
            for (PlayController.PlayerListener listener : listeners) {
                listener.event(event);
            }
        }
    }
}

