/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.player.AudioPlayer;
import jpsxdec.util.player.IMediaDataReader;
import jpsxdec.util.player.PlayController;
import jpsxdec.util.player.StopPlayingException;
import jpsxdec.util.player.VideoProcessor;

class ReaderThread
implements Runnable {
    @CheckForNull
    private final AudioPlayer _audioPlayer;
    @CheckForNull
    private final VideoProcessor _videoProcessor;
    @Nonnull
    private final PlayController _controller;
    @Nonnull
    private final Thread _thread;
    private IMediaDataReader _reader;

    public ReaderThread(@CheckForNull AudioPlayer audioPlayer, @CheckForNull VideoProcessor videoProcessor, @Nonnull PlayController controller) {
        this._audioPlayer = audioPlayer;
        this._videoProcessor = videoProcessor;
        this._controller = controller;
        this._thread = new Thread((Runnable)this, this.getClass().getName());
    }

    public void setReader(@Nonnull IMediaDataReader reader) {
        this._reader = reader;
    }

    public void start() {
        if (this._reader == null) {
            throw new IllegalStateException();
        }
        this._thread.start();
    }

    @Override
    public void run() {
        try {
            this._reader.demuxThread(this._controller);
        }
        catch (StopPlayingException ex) {
            this._controller.terminate();
            return;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this._controller.terminate();
            return;
        }
        if (this._audioPlayer != null) {
            this._audioPlayer.finish();
        }
        if (this._videoProcessor != null) {
            this._videoProcessor.finish();
        }
    }
}

