/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import java.awt.Canvas;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.util.Fraction;
import jpsxdec.util.player.AudioPlayer;
import jpsxdec.util.player.IFrameProcessor;
import jpsxdec.util.player.IMediaDataReader;
import jpsxdec.util.player.IPreprocessedFrameWriter;
import jpsxdec.util.player.PlayerException;
import jpsxdec.util.player.ReaderThread;
import jpsxdec.util.player.VideoClock;
import jpsxdec.util.player.VideoPlayer;
import jpsxdec.util.player.VideoProcessor;
import jpsxdec.util.player.VideoTimer;

public class PlayController {
    public static final Fraction PAL_ASPECT_RATIO = new Fraction(59L, 54L);
    public static final Fraction NTSC_ASPECT_RATIO = new Fraction(10L, 11L);
    public static final Fraction SQUARE_ASPECT_RATIO = new Fraction(1L, 1L);
    @CheckForNull
    private AudioPlayer _audPlayer;
    @CheckForNull
    private VideoPlayer _vidPlayer;
    @Nonnull
    private final VideoTimer _videoTimer;
    @CheckForNull
    private final VideoProcessor _videoProcessorThread;
    @Nonnull
    private final ReaderThread _readerThread;

    public PlayController(@Nonnull AudioFormat audioFormat) {
        this._audPlayer = new AudioPlayer(audioFormat);
        this._videoTimer = this._audPlayer;
        this._vidPlayer = null;
        this._videoProcessorThread = null;
        this._readerThread = new ReaderThread(this._audPlayer, null, this);
    }

    public PlayController(int iWidth, int iHeight) {
        this(iWidth, iHeight, null);
    }

    public PlayController(int iWidth, int iHeight, @CheckForNull AudioFormat audioFormat) {
        if (audioFormat != null) {
            this._audPlayer = new AudioPlayer(audioFormat);
            this._videoTimer = this._audPlayer;
        } else {
            this._audPlayer = null;
            this._videoTimer = new VideoClock();
        }
        this._vidPlayer = new VideoPlayer(this._videoTimer, iWidth, iHeight);
        this._videoProcessorThread = new VideoProcessor(this._videoTimer, this._vidPlayer);
        this._readerThread = new ReaderThread(this._audPlayer, this._videoProcessorThread, this);
    }

    public void setReader(@Nonnull IMediaDataReader reader) {
        this._readerThread.setReader(reader);
    }

    public void setVidProcressor(@Nonnull IFrameProcessor<?> processor) {
        if (this._videoProcessorThread == null) {
            throw new IllegalArgumentException();
        }
        this._videoProcessorThread.setProcessor(processor);
    }

    public void activate() throws PlayerException {
        try {
            this._videoTimer.initPaused();
            if (this._videoProcessorThread != null) {
                this._videoProcessorThread.start();
            }
            if (this._vidPlayer != null) {
                this._vidPlayer.startup();
            }
            this._readerThread.start();
        }
        catch (RuntimeException ex) {
            this.terminate();
        }
    }

    public void terminate() {
        this._videoTimer.terminate();
        if (this._vidPlayer != null) {
            this._vidPlayer.terminate();
        }
        if (this._videoProcessorThread != null) {
            this._videoProcessorThread.terminate();
        }
    }

    public void pause() {
        this._videoTimer.pause();
    }

    public void unpause() {
        this._videoTimer.go();
    }

    public boolean isClosed() {
        return this._videoTimer.isTerminated();
    }

    public boolean isPaused() {
        return this._videoTimer.isPaused();
    }

    public boolean hasAudio() {
        return this._audPlayer != null;
    }

    public boolean hasVideo() {
        return this._vidPlayer != null;
    }

    @CheckForNull
    public Canvas getVideoScreen() {
        if (this._vidPlayer != null) {
            return this._vidPlayer.getScreen();
        }
        return null;
    }

    @CheckForNull
    public OutputStream getAudioOutputStream() {
        if (this._audPlayer != null) {
            return this._audPlayer.getOutputStream();
        }
        return null;
    }

    @CheckForNull
    public IPreprocessedFrameWriter getFrameWriter() {
        return this._videoProcessorThread;
    }

    public void setAspectRatio(@Nonnull Fraction aspectRatio) {
        if (this._vidPlayer != null) {
            this._vidPlayer.getScreen().setAspectRatio(aspectRatio);
        }
    }

    public void setSquashWidth(boolean blnSquash) {
        if (this._vidPlayer != null) {
            this._vidPlayer.getScreen().setSquashWidth(blnSquash);
        }
    }

    public void addEventListener(@Nonnull PlayerListener listener) {
        this._videoTimer.addEventListener(listener);
    }

    public void removeEventListener(@Nonnull PlayerListener listener) {
        this._videoTimer.removeEventListener(listener);
    }

    public static interface PlayerListener {
        public void event(@Nonnull Event var1);
    }

    public static enum Event {
        Play,
        End,
        Pause;

    }
}

