/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ClosableBoundedBlockingQueue<T> {
    private static final Object POISON_PILL = new Object();
    @Nonnull
    private final Queue<Object> _queue;
    private final int _iCapacity;
    @Nonnull
    private final ReentrantLock _lock;
    @Nonnull
    private final Condition _notEmpty;
    @Nonnull
    private final Condition _notFull;
    private boolean _blnIsClosed = false;
    private boolean _blnIsPoisoned = false;
    @CheckForNull
    private Thread _addingThread;
    @CheckForNull
    private Thread _takingThread;

    public ClosableBoundedBlockingQueue(int iCapacity) {
        this._iCapacity = iCapacity;
        this._queue = new ArrayDeque<Object>();
        this._lock = new ReentrantLock();
        this._notEmpty = this._lock.newCondition();
        this._notFull = this._lock.newCondition();
    }

    public boolean add(@Nonnull T entry) throws InterruptedException {
        return this.innerAdd(entry, false);
    }

    public boolean addWithCapacityCheck(@Nonnull T entry) {
        try {
            return this.innerAdd(entry, true);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("should not happen", ex);
        }
    }

    private boolean innerAdd(@Nonnull Object entry, boolean blnFailIfTooBig) throws InterruptedException {
        if (entry == null) {
            throw new NullPointerException();
        }
        this._lock.lock();
        try {
            this._addingThread = Thread.currentThread();
            while (true) {
                if (this._blnIsClosed || this._blnIsPoisoned) {
                    boolean bl = false;
                    return bl;
                }
                int iQueueSize = this._queue.size();
                if (iQueueSize < this._iCapacity) {
                    this._queue.add(entry);
                    this._notEmpty.signalAll();
                    boolean bl = true;
                    return bl;
                }
                if (blnFailIfTooBig) {
                    this.closeNow();
                    throw new IllegalStateException("Queue is too big: " + iQueueSize + "/" + this._iCapacity);
                }
                ClosableBoundedBlockingQueue.checkOtherThreadBeforeWaiting(this._takingThread);
                boolean dontCareWhy = this._notEmpty.await(1L, TimeUnit.SECONDS);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @CheckForNull
    public T take() throws InterruptedException {
        this._lock.lock();
        try {
            this._takingThread = Thread.currentThread();
            while (true) {
                if (this._blnIsClosed) {
                    T t = null;
                    return t;
                }
                if (!this._queue.isEmpty()) {
                    Object entry = this._queue.remove();
                    this._notFull.signalAll();
                    if (entry == POISON_PILL) {
                        this.closeNow();
                        T t = null;
                        return t;
                    }
                    Object object = entry;
                    return (T)object;
                }
                ClosableBoundedBlockingQueue.checkOtherThreadBeforeWaiting(this._addingThread);
                boolean bl = this._notEmpty.await(1L, TimeUnit.SECONDS);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private static void checkOtherThreadBeforeWaiting(@CheckForNull Thread otherThread) {
        if (otherThread != null) {
            if (!otherThread.isAlive()) {
                throw new IllegalStateException(otherThread.getName() + " thread is dead, throwing exception to make sure this thread (" + Thread.currentThread().getName() + ") won't block forever");
            }
            if (otherThread == Thread.currentThread()) {
                throw new IllegalStateException("The last thread to add entries was THIS thread (" + Thread.currentThread().getName() + "), throwing exception to make sure this won't block forever");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeNow() {
        this._lock.lock();
        try {
            this._blnIsClosed = true;
            this._queue.clear();
            this._notEmpty.signalAll();
            this._notFull.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWhenEmpty() {
        this._lock.lock();
        try {
            if (this._blnIsClosed) {
                return;
            }
            if (this._blnIsPoisoned) {
                return;
            }
            this._queue.add(POISON_PILL);
            this._notEmpty.signalAll();
            this._blnIsPoisoned = true;
        }
        finally {
            this._lock.unlock();
        }
    }

    public boolean isClosed() {
        return this._blnIsClosed;
    }
}

