/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.player;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import jpsxdec.util.IO;
import jpsxdec.util.player.PlayController;
import jpsxdec.util.player.PlayerException;
import jpsxdec.util.player.VideoTimer;

class AudioPlayer
extends VideoTimer
implements Runnable,
LineListener {
    private static final Logger LOG = Logger.getLogger(AudioPlayer.class.getName());
    private static final boolean DEBUG = false;
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("win");
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final double SECONDS_OF_BUFFER_NON_WINDOWS = 0.1;
    private static final double SECONDS_OF_BUFFER_WINDOWS = 5.0;
    @Nonnull
    private final AudioFormat _format;
    @Nonnull
    private final PipedInputStream _pipedInputStream;
    @Nonnull
    private final PipedOutputStream _pipedOutputStream;
    private final double _dblSamplesPerNano;
    private final int _iCopyBufferSize;
    @Nonnull
    private final Thread _thread;
    private SourceDataLine _dataLine;
    private boolean _blnWasStarted = false;
    private boolean _blnUseAudioAndSystemClockTogether = false;
    private long _lngStartTime = -1L;
    private long _lngLastSync = -1L;
    private static final long RESYNC_EVERY_NANOS = 500000000L;

    public AudioPlayer(@Nonnull AudioFormat format) {
        this._format = format;
        this._dblSamplesPerNano = 1.0E9 / (double)this._format.getSampleRate();
        int iPipeSize = this._format.getFrameSize() * Math.round(this._format.getSampleRate()) * 5;
        this._pipedInputStream = new PipedInputStream(iPipeSize);
        try {
            this._pipedOutputStream = new PipedOutputStream(this._pipedInputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Should not happen", ex);
        }
        this._iCopyBufferSize = (int)((float)format.getFrameSize() * format.getSampleRate() * 5.0f);
        this._thread = new Thread((Runnable)this, this.getClass().getName());
    }

    @Override
    public synchronized void initPaused() throws PlayerException {
        if (this._dataLine != null) {
            throw new IllegalStateException();
        }
        try {
            this._dataLine = AudioPlayer.createOpenLine(this._format);
            this._dataLine.addLineListener(this);
            this._thread.start();
        }
        catch (LineUnavailableException ex) {
            throw new PlayerException(ex);
        }
    }

    @Nonnull
    private static SourceDataLine createOpenLine(@Nonnull AudioFormat format) throws LineUnavailableException {
        boolean blnUseDefault = true;
        SourceDataLine dataLine = null;
        dataLine = AudioSystem.getSourceDataLine(format);
        double dblSeconds = IS_WINDOWS ? 5.0 : 0.1;
        int iRequestedBufferSize = (int)((double)((float)format.getFrameSize() * format.getSampleRate()) * dblSeconds);
        dataLine.open(format, iRequestedBufferSize);
        dataLine.start();
        dataLine.stop();
        int iActualBufferSize = dataLine.getBufferSize();
        System.out.println("Dataline requested buffer size " + iRequestedBufferSize + " actual buffer size " + iActualBufferSize);
        return dataLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] abCopyBuffer = new byte[this._iCopyBufferSize];
            int iBytesToWrite = 0;
            int iBytesWritten = 0;
            while (this._dataLine.isOpen()) {
                if (iBytesWritten < iBytesToWrite) {
                    int iToWrite = iBytesToWrite - iBytesWritten;
                    int iFrameRemainder = iToWrite % this._format.getFrameSize();
                    if (iFrameRemainder > 0) {
                        iToWrite -= iFrameRemainder;
                    }
                    int iWrorte = this._dataLine.write(abCopyBuffer, iBytesWritten, iToWrite);
                    iBytesWritten += iWrorte;
                    if (iWrorte >= iToWrite) continue;
                    boolean blnDueToPause = false;
                    AudioPlayer audioPlayer = this;
                    synchronized (audioPlayer) {
                        if (this.isPaused()) {
                            this.wait();
                            blnDueToPause = true;
                        }
                    }
                    if (blnDueToPause) continue;
                    System.out.println("[AudioPlayer] Only " + iWrorte + " bytes of audio was written. Progress: " + iBytesWritten + "/" + iBytesToWrite);
                    continue;
                }
                iBytesToWrite = this._pipedInputStream.read(abCopyBuffer);
                iBytesWritten = 0;
                if (iBytesToWrite >= 0) continue;
            }
            AudioPlayer audioPlayer = this;
            synchronized (audioPlayer) {
                while (!this._blnWasStarted) {
                    System.out.println("Out of audio data, but player has not been started");
                    this.wait();
                }
            }
        }
        catch (IOException ex) {
            System.out.println("Audio player IOException stop: " + ex.getMessage());
            this._dataLine.close();
            super.terminate();
            return;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            this._dataLine.close();
            super.terminate();
            return;
        }
        this._dataLine.drain();
        this._dataLine.close();
        super.terminate();
        System.out.println("AudioPlayer ending");
    }

    @Nonnull
    public OutputStream getOutputStream() {
        return this._pipedOutputStream;
    }

    @Override
    public synchronized void go() {
        if (this._dataLine != null) {
            long lngNow;
            this._lngLastSync = lngNow = System.nanoTime();
            this._lngStartTime = lngNow - (long)((double)this._dataLine.getLongFramePosition() * this._dblSamplesPerNano);
            this._dataLine.start();
            this._blnWasStarted = true;
        }
        super.go();
    }

    @Override
    public synchronized void pause() {
        if (this._dataLine != null) {
            this._dataLine.stop();
        }
        super.pause();
    }

    public void finish() {
        IO.closeSilently(this._pipedOutputStream, LOG);
    }

    @Override
    public void videoDone() {
    }

    @Override
    public synchronized void terminate() {
        if (this._dataLine != null) {
            this._dataLine.stop();
            this._dataLine.close();
        }
        IO.closeSilently(this._pipedOutputStream, LOG);
        IO.closeSilently(this._pipedInputStream, LOG);
        super.terminate();
    }

    @Override
    public synchronized long getNanoTime() {
        if (!this._blnUseAudioAndSystemClockTogether || this.isPaused() || this.isTerminated()) {
            return (long)((double)this._dataLine.getLongFramePosition() * this._dblSamplesPerNano);
        }
        long lngNow = System.nanoTime();
        if (lngNow - this._lngLastSync > 500000000L) {
            long lngPlayTime = (long)((double)this._dataLine.getLongFramePosition() * this._dblSamplesPerNano);
            long lngOldStartTime = this._lngStartTime;
            this._lngStartTime = lngNow - lngPlayTime;
            this._lngLastSync = lngNow;
            System.out.println("Resyncing from " + lngOldStartTime + " to " + this._lngStartTime + " (" + (double)(this._lngStartTime - lngOldStartTime) / 1.0E9 + ")");
            return lngPlayTime;
        }
        return lngNow - this._lngStartTime;
    }

    @Override
    public void update(LineEvent event) {
        PlayController.Event playerEvent;
        LineEvent.Type type = event.getType();
        if (type == LineEvent.Type.CLOSE) {
            playerEvent = PlayController.Event.End;
        } else if (type == LineEvent.Type.START) {
            playerEvent = PlayController.Event.Play;
        } else if (type == LineEvent.Type.STOP) {
            playerEvent = PlayController.Event.Pause;
        } else {
            return;
        }
        this.fire(playerEvent);
    }
}

