/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.aviwriter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.util.aviwriter.AVIstruct;
import jpsxdec.util.aviwriter.AviWriter;

public class AviWriterYV12
extends AviWriter {
    private final int _iFrameByteSize;
    private final int _iFrameYByteSize;
    private final int _iFrameCByteSize;

    public AviWriterYV12(@Nonnull File outFile, int iWidth, int iHeight, long lngFrames, long lngPerSecond) throws FileNotFoundException, IOException {
        this(outFile, iWidth, iHeight, lngFrames, lngPerSecond, null);
    }

    public AviWriterYV12(@Nonnull File outFile, int iWidth, int iHeight, long lngFrames, long lngPerSecond, @CheckForNull AudioFormat audioFormat) throws FileNotFoundException, IOException {
        super(outFile, iWidth, iHeight, lngFrames, lngPerSecond, audioFormat, false, "YV12", AVIstruct.string2int("YV12"));
        if (((iWidth | iHeight) & 1) != 0) {
            this.closeSilentlyDueToError();
            throw new IllegalArgumentException("Dimensions must be divisible by 2");
        }
        this._iFrameYByteSize = iWidth * iHeight;
        this._iFrameCByteSize = iWidth * iHeight / 4;
        this._iFrameByteSize = this._iFrameYByteSize + this._iFrameCByteSize * 2;
    }

    public void write(@Nonnull byte[] abY, @Nonnull byte[] abCb, @Nonnull byte[] abCr) throws IOException {
        if (abY.length < this._iFrameYByteSize) {
            throw new IllegalArgumentException("Y data wrong size.");
        }
        if (abCb.length < this._iFrameCByteSize) {
            throw new IllegalArgumentException("Cb data wrong size.");
        }
        if (abCr.length < this._iFrameCByteSize) {
            throw new IllegalArgumentException("Cr data wrong size.");
        }
        if (this._abWriteBuffer == null || this._abWriteBuffer.length < this._iFrameByteSize) {
            this._abWriteBuffer = new byte[this._iFrameByteSize];
        }
        System.arraycopy(abY, 0, this._abWriteBuffer, 0, this._iFrameYByteSize);
        System.arraycopy(abCr, 0, this._abWriteBuffer, this._iFrameYByteSize, this._iFrameCByteSize);
        System.arraycopy(abCb, 0, this._abWriteBuffer, this._iFrameYByteSize + this._iFrameCByteSize, this._iFrameCByteSize);
        this.writeFrameChunk(this._abWriteBuffer, 0, this._iFrameByteSize);
    }

    @Override
    public void writeBlankFrame() throws IOException {
        if (this._abWriteBuffer == null || this._abWriteBuffer.length < this._iFrameByteSize) {
            this._abWriteBuffer = new byte[this._iFrameByteSize];
        }
        Arrays.fill(this._abWriteBuffer, 0, this._iFrameYByteSize, (byte)0);
        Arrays.fill(this._abWriteBuffer, this._iFrameYByteSize, this._iFrameYByteSize + this._iFrameCByteSize * 2, (byte)-128);
        this.writeFrameChunk(this._abWriteBuffer, 0, this._iFrameByteSize);
    }
}

