/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.aviwriter;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.sound.sampled.AudioFormat;
import jpsxdec.util.ExposedBAOS;
import jpsxdec.util.aviwriter.AVIstruct;
import jpsxdec.util.aviwriter.AviWriter;

public class AviWriterMJPG
extends AviWriter {
    private static final boolean CAN_ENCODE_JPEG;
    @Nonnull
    private final ImageWriter _imgWriter;
    @CheckForNull
    private final ImageWriteParam _writeParams;

    public AviWriterMJPG(@Nonnull File outputfile, int iWidth, int iHeight, long lngFrames, long lngPerSecond) throws FileNotFoundException, IOException {
        this(outputfile, iWidth, iHeight, lngFrames, lngPerSecond, -1.0f, null);
    }

    public AviWriterMJPG(@Nonnull File outputfile, int iWidth, int iHeight, long lngFrames, long lngPerSecond, @CheckForNull AudioFormat audioFormat) throws FileNotFoundException, IOException {
        this(outputfile, iWidth, iHeight, lngFrames, lngPerSecond, -1.0f, audioFormat);
    }

    public AviWriterMJPG(@Nonnull File outputfile, int iWidth, int iHeight, long lngFrames, long lngPerSecond, float fltLossyQuality) throws FileNotFoundException, IOException {
        this(outputfile, iWidth, iHeight, lngFrames, lngPerSecond, fltLossyQuality, null);
    }

    public AviWriterMJPG(@Nonnull File outputfile, int iWidth, int iHeight, long lngFrames, long lngPerSecond, float fltLossyQuality, @CheckForNull AudioFormat audioFormat) throws FileNotFoundException, IOException {
        super(outputfile, iWidth, iHeight, lngFrames, lngPerSecond, audioFormat, true, "MJPG", AVIstruct.string2int("MJPG"));
        if (!CAN_ENCODE_JPEG) {
            this.closeSilentlyDueToError();
            throw new UnsupportedOperationException("Unable to create 'jpeg' images on this platform.");
        }
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        this._imgWriter = iter.next();
        if (fltLossyQuality < 0.0f || fltLossyQuality > 1.0f) {
            this._writeParams = null;
        } else {
            this._writeParams = this._imgWriter.getDefaultWriteParam();
            this._writeParams.setCompressionMode(2);
            this._writeParams.setCompressionQuality(fltLossyQuality);
        }
    }

    public void writeFrame(@Nonnull BufferedImage bi) throws IOException {
        if (this.getWidth() != bi.getWidth()) {
            throw new IllegalArgumentException("AviWriter: Frame width doesn't match (was " + this.getWidth() + ", now " + bi.getWidth() + ").");
        }
        if (this.getHeight() != bi.getHeight()) {
            throw new IllegalArgumentException("AviWriter: Frame height doesn't match (was " + this.getHeight() + ", now " + bi.getHeight() + ").");
        }
        ExposedBAOS out = this.image2MJPEG(bi);
        this.writeFrameChunk(out.getBuffer(), 0, out.size());
    }

    public void writeFrame(@Nonnull byte[] abJpeg, int iStart, int iSize) throws IOException {
        this.writeFrameChunk(abJpeg, iStart, iSize);
    }

    @Override
    public void writeBlankFrame() throws IOException {
        BufferedImage bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.writeFrame(bi);
    }

    @Nonnull
    private ExposedBAOS image2MJPEG(@Nonnull BufferedImage img) throws IOException {
        ExposedBAOS jpgStream = this.writeImageToBytes(img, new ExposedBAOS());
        return jpgStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private ExposedBAOS writeImageToBytes(@Nonnull BufferedImage img, @Nonnull ExposedBAOS out) throws IOException {
        MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(out);
        this._imgWriter.setOutput(imgOut);
        IIOImage imgIO = new IIOImage(img, null, null);
        boolean blnException = true;
        try {
            this._imgWriter.write(null, imgIO, this._writeParams);
            imgOut.flush();
            blnException = false;
        }
        finally {
            this._imgWriter.setOutput(null);
            if (blnException) {
                try {
                    imgOut.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(AviWriterMJPG.class.getName()).log(Level.SEVERE, "Exception closing " + imgOut.getClass().getName(), ex);
                }
            } else {
                imgOut.close();
            }
        }
        return out;
    }

    static {
        boolean bln = false;
        for (String s : ImageIO.getReaderFormatNames()) {
            if (!s.equals("jpeg")) continue;
            bln = true;
            break;
        }
        CAN_ENCODE_JPEG = bln;
    }
}

