/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.aviwriter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import jpsxdec.util.aviwriter.AviWriter;

public class AviWriterDIB
extends AviWriter {
    private final int _iFrameByteSize;
    private final int _iLinePadding;

    public AviWriterDIB(@Nonnull File outputfile, int iWidth, int iHeight, long lngFrames, long lngPerSecond) throws FileNotFoundException, IOException {
        this(outputfile, iWidth, iHeight, lngFrames, lngPerSecond, null);
    }

    public AviWriterDIB(@Nonnull File outputfile, int iWidth, int iHeight, long lngFrames, long lngPerSecond, @CheckForNull AudioFormat audioFormat) throws FileNotFoundException, IOException {
        super(outputfile, iWidth, iHeight, lngFrames, lngPerSecond, audioFormat, true, "DIB ", 0);
        int iLinePadding = this.getWidth() * 3 & 3;
        if (iLinePadding != 0) {
            iLinePadding = 4 - iLinePadding;
        }
        this._iLinePadding = iLinePadding;
        this._iFrameByteSize = (this.getWidth() * 3 + iLinePadding) * this.getHeight();
    }

    public void writeFrameRGB(@Nonnull byte[] abData, int iStart, int iLineStride) throws IOException {
        int WIDTH = this.getWidth();
        int HEIGHT = this.getHeight();
        if (this._abWriteBuffer == null || this._abWriteBuffer.length < this._iFrameByteSize) {
            this._abWriteBuffer = new byte[this._iFrameByteSize];
        }
        int iSrcLine = iStart + (HEIGHT - 1) * iLineStride;
        int iDestPos = 0;
        for (int y = HEIGHT - 1; y >= 0; --y) {
            int iSrcPos = iSrcLine;
            for (int x = 0; x < WIDTH; ++x) {
                this._abWriteBuffer[iDestPos] = abData[iSrcPos + 2];
                this._abWriteBuffer[++iDestPos] = abData[iSrcPos + 1];
                this._abWriteBuffer[++iDestPos] = abData[iSrcPos + 0];
                ++iDestPos;
                iSrcPos += 3;
            }
            iSrcLine -= iLineStride;
            for (int i = 0; i < this._iLinePadding; ++i) {
                this._abWriteBuffer[iDestPos] = 0;
                ++iDestPos;
            }
        }
        this.writeFrameChunk(this._abWriteBuffer, 0, this._iFrameByteSize);
    }

    public void writeFrameRGB(@Nonnull int[] aiData, int iStart, int iLineStride) throws IOException {
        int WIDTH = this.getWidth();
        int HEIGHT = this.getHeight();
        if (this._abWriteBuffer == null || this._abWriteBuffer.length < this._iFrameByteSize) {
            this._abWriteBuffer = new byte[this._iFrameByteSize];
        }
        int iSrcLine = iStart + (HEIGHT - 1) * iLineStride;
        int iDestPos = 0;
        for (int y = HEIGHT - 1; y >= 0; --y) {
            int iSrcPos = iSrcLine;
            for (int x = 0; x < WIDTH; ++x) {
                int c = aiData[iSrcPos];
                this._abWriteBuffer[iDestPos] = (byte)c;
                this._abWriteBuffer[++iDestPos] = (byte)(c >> 8);
                this._abWriteBuffer[++iDestPos] = (byte)(c >> 16);
                ++iDestPos;
                ++iSrcPos;
            }
            iSrcLine -= iLineStride;
            for (int i = 0; i < this._iLinePadding; ++i) {
                this._abWriteBuffer[iDestPos] = 0;
                ++iDestPos;
            }
        }
        this.writeFrameChunk(this._abWriteBuffer, 0, this._iFrameByteSize);
    }

    @Override
    public void writeBlankFrame() throws IOException {
        if (this._abWriteBuffer == null || this._abWriteBuffer.length < this._iFrameByteSize) {
            this._abWriteBuffer = new byte[this._iFrameByteSize];
        }
        Arrays.fill(this._abWriteBuffer, 0, this._iFrameByteSize, (byte)0);
        this.writeFrameChunk(this._abWriteBuffer, 0, this._iFrameByteSize);
    }
}

