/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.aviwriter;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;
import jpsxdec.util.aviwriter.AVIMAINHEADER;
import jpsxdec.util.aviwriter.AVIOLDINDEX;
import jpsxdec.util.aviwriter.AVISTREAMHEADER;
import jpsxdec.util.aviwriter.AVIstruct;
import jpsxdec.util.aviwriter.AviIsClosedException;
import jpsxdec.util.aviwriter.BITMAPINFOHEADER;
import jpsxdec.util.aviwriter.WAVEFORMATEX;

public abstract class AviWriter
implements Closeable {
    private static final boolean DEBUG = false;
    @Nonnull
    private final File _outputFile;
    private final int _iWidth;
    private final int _iHeight;
    private final long _lngFpsNumerator;
    private final long _lngFpsDenominator;
    protected byte[] _abWriteBuffer;
    private long _lngFrameCount = 0L;
    @CheckForNull
    private final AudioFormat _audioFormat;
    private long _lngSampleCount = 0L;
    private final boolean _blnCompressedVideo;
    @Nonnull
    private final String _sFourCCcodec;
    private final int _iCompression;
    @CheckForNull
    private RandomAccessFile _aviFile;
    private Chunk _RIFF_chunk;
    private Chunk _LIST_hdr1;
    private AVIMAINHEADER _avih;
    private Chunk _LIST_strl_vid;
    private Chunk _strf_vid;
    private AVISTREAMHEADER _strh_vid;
    private BITMAPINFOHEADER _bif;
    private Chunk _strn_vid;
    private Chunk _LIST_strl_aud;
    private Chunk _strf_aud;
    private AVISTREAMHEADER _strh_aud;
    private WAVEFORMATEX _wavfmt;
    private Chunk LIST_movi;
    private AVIOLDINDEX avioldidx;
    @Nonnull
    private ArrayList<AVIOLDINDEX.AVIOLDINDEXENTRY> _indexList;

    @Nonnull
    public File getFile() {
        return this._outputFile;
    }

    @CheckForNull
    public AudioFormat getAudioFormat() {
        return this._audioFormat;
    }

    public long getFramesPerSecNum() {
        return this._lngFpsNumerator;
    }

    public long getFramesperSecDenom() {
        return this._lngFpsDenominator;
    }

    public int getWidth() {
        return this._iWidth;
    }

    public int getHeight() {
        return this._iHeight;
    }

    public long getVideoFramesWritten() {
        return this._lngFrameCount;
    }

    public long getAudioSampleFramesWritten() {
        return this._lngSampleCount;
    }

    public int getAudioSamplesPerFrame() {
        if (this._audioFormat == null) {
            return 0;
        }
        return Math.round(this._audioFormat.getSampleRate() * (float)this._lngFpsDenominator / (float)this._lngFpsNumerator);
    }

    protected AviWriter(@Nonnull File outputfile, int iWidth, int iHeight, long lngFrames, long lngPerSecond, @CheckForNull AudioFormat audioFormat, boolean blnCompressedVideo, @Nonnull String sFourCCcodec, int iBytes) throws FileNotFoundException, IOException {
        this._outputFile = outputfile;
        this._blnCompressedVideo = blnCompressedVideo;
        this._sFourCCcodec = sFourCCcodec;
        this._iCompression = iBytes;
        this._iWidth = iWidth;
        this._iHeight = iHeight;
        if (this._iWidth < 1 || this._iHeight < 1) {
            throw new IllegalArgumentException("Video dimensions must be greater than 0.");
        }
        this._lngFpsNumerator = lngFrames;
        this._lngFpsDenominator = lngPerSecond;
        if (this._lngFpsNumerator < 1L || this._lngFpsDenominator < 1L) {
            throw new IllegalArgumentException("Frames/Second must be greater than 0 (and less than infinity).");
        }
        if (audioFormat != null) {
            if (audioFormat.getChannels() == -1) {
                throw new IllegalArgumentException("Audio channels cannot be NOT_SPECIFIED.");
            }
            if (audioFormat.getFrameRate() == -1.0f) {
                throw new IllegalArgumentException("Audio frame rate cannot be NOT_SPECIFIED.");
            }
            if (audioFormat.getFrameSize() == -1) {
                throw new IllegalArgumentException("Audio frame size cannot be NOT_SPECIFIED.");
            }
            if (audioFormat.getSampleRate() == -1.0f) {
                throw new IllegalArgumentException("Audio sample rate cannot be NOT_SPECIFIED.");
            }
            if (audioFormat.getSampleSizeInBits() == -1) {
                throw new IllegalArgumentException("Audio sample size cannot be NOT_SPECIFIED.");
            }
            if (audioFormat.isBigEndian()) {
                throw new IllegalArgumentException("Audio must be little-endian.");
            }
            if (audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                throw new IllegalArgumentException("Audio encoding needs to be PCM_SIGNED.");
            }
        }
        this._audioFormat = audioFormat;
        this._aviFile = new RandomAccessFile(outputfile, "rw");
        try {
            this._aviFile.setLength(0L);
            this._RIFF_chunk = new Chunk(this._aviFile, "RIFF", "AVI ");
            this._LIST_hdr1 = new Chunk(this._aviFile, "LIST", "hdrl");
            this._avih = new AVIMAINHEADER();
            this._avih.makePlaceholder(this._aviFile);
            this._LIST_strl_vid = new Chunk(this._aviFile, "LIST", "strl");
            this._strh_vid = new AVISTREAMHEADER();
            this._strh_vid.makePlaceholder(this._aviFile);
            this._strf_vid = new Chunk(this._aviFile, "strf");
            this._bif = new BITMAPINFOHEADER();
            this._bif.makePlaceholder(this._aviFile);
            this._strf_vid.endChunk(this._aviFile);
            this._strn_vid = new Chunk(this._aviFile, "strn");
            this._aviFile.writeBytes("jPSXdec AVI    \u0000");
            this._strn_vid.endChunk(this._aviFile);
            this._LIST_strl_vid.endChunk(this._aviFile);
            if (this._audioFormat != null) {
                this._LIST_strl_aud = new Chunk(this._aviFile, "LIST", "strl");
                this._strh_aud = new AVISTREAMHEADER();
                this._strh_aud.makePlaceholder(this._aviFile);
                this._strf_aud = new Chunk(this._aviFile, "strf");
                this._wavfmt = new WAVEFORMATEX();
                this._wavfmt.makePlaceholder(this._aviFile);
                this._strf_aud.endChunk(this._aviFile);
                this._LIST_strl_aud.endChunk(this._aviFile);
            }
            this._LIST_hdr1.endChunk(this._aviFile);
            Chunk JUNK_writerId = new Chunk(this._aviFile, "JUNK");
            String sVersion = String.format("jPSXdec: PSX media decoder (non-commercial) v%s", "1.05 (beta)");
            this._aviFile.writeBytes(sVersion);
            this._aviFile.write(0);
            JUNK_writerId.endChunk(this._aviFile);
            this.LIST_movi = new Chunk(this._aviFile, "LIST", "movi");
        }
        catch (IOException ex) {
            this.closeSilentlyDueToError();
            throw ex;
        }
        this._indexList = new ArrayList();
    }

    protected final void closeSilentlyDueToError() {
        IO.closeSilently(this._aviFile, Logger.getLogger(AviWriter.class.getName()));
    }

    public void repeatPreviousFrame() {
        int iChunkId;
        if (this._lngFrameCount < 1L) {
            throw new IllegalStateException("Unable to repeat a previous frame that doesn't exist.");
        }
        int iIndex = this._indexList.size() - 1;
        int VID_CHUNK_ID = AVIstruct.string2int("00d_") & 0xFFFFFF;
        while (((iChunkId = this._indexList.get((int)iIndex).dwChunkId) & 0xFFFFFF) != VID_CHUNK_ID) {
            --iIndex;
        }
        this._indexList.add(this._indexList.get(iIndex));
        ++this._lngFrameCount;
    }

    public void writeAudio(@Nonnull AudioInputStream audStream) throws AviIsClosedException, IOException {
        int i;
        if (this._aviFile == null) {
            throw new AviIsClosedException();
        }
        if (this._audioFormat == null) {
            throw new IllegalStateException("Unable to write audio to video-only avi.");
        }
        AudioFormat fmt = audStream.getFormat();
        if (!fmt.matches(this._audioFormat)) {
            throw new IllegalArgumentException("Audio stream format does not match.");
        }
        AVIOLDINDEX.AVIOLDINDEXENTRY idxentry = new AVIOLDINDEX.AVIOLDINDEXENTRY();
        idxentry.dwOffset = (int)(this._aviFile.getFilePointer() - (this.LIST_movi.getStart() + 4L));
        idxentry.dwChunkId = AVIstruct.string2int("01wb");
        idxentry.dwFlags = 0;
        Chunk data_size = new Chunk(this._aviFile, "01wb");
        if (this._abWriteBuffer == null || this._abWriteBuffer.length < this._audioFormat.getFrameSize() * 1024) {
            this._abWriteBuffer = new byte[this._audioFormat.getFrameSize() * 1024];
        }
        int iTotal = 0;
        while ((i = audStream.read(this._abWriteBuffer)) > 0) {
            iTotal += i;
            this._lngSampleCount += (long)(i / this._audioFormat.getFrameSize());
            this._aviFile.write(this._abWriteBuffer, 0, i);
        }
        if (iTotal % this._audioFormat.getFrameSize() != 0) {
            throw new RuntimeException("Read and wrote partial sample.");
        }
        data_size.endChunk(this._aviFile);
        idxentry.dwSize = data_size.getSize();
        this._indexList.add(idxentry);
    }

    public void writeAudio(@Nonnull byte[] abData) throws IOException {
        this.writeAudio(abData, 0, abData.length);
    }

    public void writeAudio(@Nonnull byte[] abData, int iOfs, int iLen) throws AviIsClosedException, IOException {
        if (this._aviFile == null) {
            throw new AviIsClosedException();
        }
        if (this._audioFormat == null) {
            throw new IllegalStateException("Unable to write audio to video-only avi.");
        }
        if (iLen % this._audioFormat.getFrameSize() != 0) {
            throw new IllegalArgumentException("Half an audio sample can't be processed.");
        }
        AVIOLDINDEX.AVIOLDINDEXENTRY idxentry = new AVIOLDINDEX.AVIOLDINDEXENTRY();
        idxentry.dwOffset = (int)(this._aviFile.getFilePointer() - (this.LIST_movi.getStart() + 4L));
        idxentry.dwChunkId = AVIstruct.string2int("01wb");
        idxentry.dwFlags = 0;
        Chunk data_size = new Chunk(this._aviFile, "01wb");
        this._aviFile.write(abData, iOfs, iLen);
        data_size.endChunk(this._aviFile);
        this._lngSampleCount += (long)(iLen / this._audioFormat.getFrameSize());
        idxentry.dwSize = data_size.getSize();
        this._indexList.add(idxentry);
    }

    public void writeSilentSamples(long lngSampleCount) throws AviIsClosedException, IOException {
        if (this._audioFormat == null) {
            throw new IllegalStateException("Unable to write audio to video-only avi.");
        }
        this.writeAudio(new AudioInputStream(new IO.ZeroInputStream(), this._audioFormat, lngSampleCount));
    }

    protected void writeFrameChunk(@Nonnull byte[] abData, int iOfs, int iLen) throws AviIsClosedException, IOException {
        if (this._aviFile == null) {
            throw new AviIsClosedException();
        }
        AVIOLDINDEX.AVIOLDINDEXENTRY idxentry = new AVIOLDINDEX.AVIOLDINDEXENTRY();
        idxentry.dwOffset = (int)(this._aviFile.getFilePointer() - (this.LIST_movi.getStart() + 4L));
        String sChunkId = this._blnCompressedVideo ? "00dc" : "00db";
        idxentry.dwChunkId = AVIstruct.string2int(sChunkId);
        idxentry.dwFlags = AVIOLDINDEX.AVIIF_KEYFRAME;
        Chunk data_size = new Chunk(this._aviFile, sChunkId);
        this._aviFile.write(abData, iOfs, iLen);
        data_size.endChunk(this._aviFile);
        ++this._lngFrameCount;
        idxentry.dwSize = data_size.getSize();
        this._indexList.add(idxentry);
    }

    public abstract void writeBlankFrame() throws IOException;

    @Override
    public void close() throws AviIsClosedException, IOException {
        if (this._aviFile == null) {
            throw new AviIsClosedException();
        }
        this.LIST_movi.endChunk(this._aviFile);
        this.avioldidx = new AVIOLDINDEX(this._indexList.toArray(new AVIOLDINDEX.AVIOLDINDEXENTRY[this._indexList.size()]));
        this.avioldidx.write(this._aviFile);
        this._RIFF_chunk.endChunk(this._aviFile);
        this._avih.dwMicroSecPerFrame = (int)((double)this._lngFpsDenominator / (double)this._lngFpsNumerator * 1000000.0);
        this._avih.dwMaxBytesPerSec = 0L;
        this._avih.dwPaddingGranularity = 0L;
        this._avih.dwFlags = 272;
        this._avih.dwTotalFrames = this._lngFrameCount;
        this._avih.dwInitialFrames = 0L;
        this._avih.dwStreams = this._audioFormat == null ? 1L : 2L;
        this._avih.dwSuggestedBufferSize = 0L;
        this._avih.dwWidth = this._iWidth;
        this._avih.dwHeight = this._iHeight;
        this._strh_vid.fccType = AVIstruct.string2int("vids");
        this._strh_vid.fccHandler = AVIstruct.string2int(this._sFourCCcodec);
        this._strh_vid.dwFlags = 0;
        this._strh_vid.wPriority = 0;
        this._strh_vid.wLanguage = 0;
        this._strh_vid.dwInitialFrames = 0L;
        this._strh_vid.dwScale = this._lngFpsDenominator;
        this._strh_vid.dwRate = this._lngFpsNumerator;
        this._strh_vid.dwStart = 0L;
        this._strh_vid.dwLength = this._lngFrameCount;
        this._strh_vid.dwSuggestedBufferSize = 0L;
        this._strh_vid.dwQuality = -1L;
        this._strh_vid.dwSampleSize = 0L;
        this._strh_vid.left = 0;
        this._strh_vid.top = 0;
        this._strh_vid.right = (short)this._iWidth;
        this._strh_vid.bottom = (short)this._iHeight;
        this._bif.biWidth = this._iWidth;
        this._bif.biHeight = this._iHeight;
        this._bif.biBitCount = (short)24;
        this._bif.biCompression = this._iCompression;
        this._bif.biSizeImage = 0;
        this._bif.biXPelsPerMeter = 0;
        this._bif.biYPelsPerMeter = 0;
        this._bif.biClrUsed = 0;
        this._bif.biClrImportant = 0;
        if (this._audioFormat != null) {
            this._strh_aud.fccType = AVIstruct.string2int("auds");
            this._strh_aud.fccHandler = 0;
            this._strh_aud.dwFlags = 0;
            this._strh_aud.wPriority = 0;
            this._strh_aud.wLanguage = 0;
            this._strh_aud.dwInitialFrames = 1L;
            this._strh_aud.dwScale = 1L;
            this._strh_aud.dwRate = (int)this._audioFormat.getSampleRate();
            this._strh_aud.dwStart = 0L;
            this._strh_aud.dwLength = (int)this._lngSampleCount;
            this._strh_aud.dwSuggestedBufferSize = 0L;
            this._strh_aud.dwQuality = -1L;
            this._strh_aud.dwSampleSize = this._audioFormat.getFrameSize();
            this._strh_aud.left = 0;
            this._strh_aud.top = 0;
            this._strh_aud.right = 0;
            this._strh_aud.bottom = 0;
            this._wavfmt.wFormatTag = WAVEFORMATEX.WAVE_FORMAT_PCM;
            this._wavfmt.nChannels = (short)this._audioFormat.getChannels();
            this._wavfmt.nSamplesPerSec = (int)this._audioFormat.getFrameRate();
            this._wavfmt.nAvgBytesPerSec = this._audioFormat.getFrameSize() * this._wavfmt.nSamplesPerSec;
            this._wavfmt.nBlockAlign = (short)this._audioFormat.getFrameSize();
            this._wavfmt.wBitsPerSample = (short)this._audioFormat.getSampleSizeInBits();
        }
        this._avih.goBackAndWrite(this._aviFile);
        this._strh_vid.goBackAndWrite(this._aviFile);
        this._bif.goBackAndWrite(this._aviFile);
        if (this._audioFormat != null) {
            this._strh_aud.goBackAndWrite(this._aviFile);
            this._wavfmt.goBackAndWrite(this._aviFile);
        }
        this._aviFile.close();
        this._aviFile = null;
        this._RIFF_chunk = null;
        this._LIST_hdr1 = null;
        this._avih = null;
        this._LIST_strl_vid = null;
        this._strf_vid = null;
        this._strh_vid = null;
        this._bif = null;
        this._strn_vid = null;
        this._LIST_strl_aud = null;
        this._strf_aud = null;
        this._strh_aud = null;
        this._wavfmt = null;
        this.LIST_movi = null;
        this.avioldidx = null;
    }

    public String toString() {
        return String.format("%s %s %dx%d %d/%d fps", this.getClass().getSimpleName(), this.getFile(), this.getWidth(), this.getHeight(), this.getFramesPerSecNum(), this.getFramesperSecDenom());
    }

    @Nonnull
    private static String md5(@Nonnull byte[] abData, int iOfs, int iLen) {
        try {
            MessageDigest md = MessageDigest.getInstance("md5");
            md.update(abData, iOfs, iLen);
            BigInteger number = new BigInteger(1, md.digest());
            String sHashText = number.toString(16);
            sHashText = Misc.zeroPadString(sHashText, 32, false);
            return sHashText;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class Chunk {
        private static final byte[] ZEROES3 = new byte[3];
        private final long _lngPos;
        private int _iSize = -1;

        Chunk(@Nonnull RandomAccessFile raf, @Nonnull String sChunkName) throws IOException {
            IO.writeInt32LE(raf, (long)AVIstruct.string2int(sChunkName));
            this._lngPos = raf.getFilePointer();
            raf.writeInt(0);
        }

        Chunk(@Nonnull RandomAccessFile raf, @Nonnull String sChunkName, @Nonnull String sSubChunkName) throws IOException {
            this(raf, sChunkName);
            IO.writeInt32LE(raf, (long)AVIstruct.string2int(sSubChunkName));
        }

        public void endChunk(@Nonnull RandomAccessFile raf) throws IOException {
            long lngCurPos = raf.getFilePointer();
            this._iSize = (int)(lngCurPos - (this._lngPos + 4L));
            int iNon4bytes = this._iSize % 4;
            if (iNon4bytes > 0) {
                int iBytesToPad = 4 - iNon4bytes;
                raf.write(ZEROES3, 0, iBytesToPad);
                this._iSize += iBytesToPad;
                lngCurPos += (long)iBytesToPad;
            }
            raf.seek(this._lngPos);
            IO.writeInt32LE(raf, (long)this._iSize);
            raf.seek(lngCurPos);
        }

        private int getSize() {
            return this._iSize;
        }

        private long getStart() {
            return this._lngPos;
        }
    }
}

