/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util.aviwriter;

import java.io.IOException;
import java.io.RandomAccessFile;
import javax.annotation.Nonnull;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

abstract class AVIstruct {
    private long _lngPlaceholder;

    AVIstruct() {
    }

    public static int string2int(@Nonnull String s) {
        if (s.length() != 4) {
            throw new IllegalArgumentException();
        }
        return IO.readSInt32LE(Misc.stringToAscii(s), 0);
    }

    public abstract void write(@Nonnull RandomAccessFile var1) throws IOException;

    public abstract int sizeof();

    public void makePlaceholder(@Nonnull RandomAccessFile raf) throws IOException {
        this._lngPlaceholder = raf.getFilePointer();
        raf.write(new byte[this.sizeof()]);
    }

    public void goBackAndWrite(@Nonnull RandomAccessFile raf) throws IOException {
        long lngCurPos = raf.getFilePointer();
        raf.seek(this._lngPlaceholder);
        this.write(raf);
        raf.seek(lngCurPos);
    }
}

