/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nonnull;

public class PushAvailableInputStream<META>
extends InputStream {
    private final Queue<Pair<META>> _pieces = new ArrayDeque<Pair<META>>();
    private int _iPendingAvailable = 0;
    private final byte[] _abRead1 = new byte[1];

    public void addStream(@Nonnull InputStream is, @Nonnull META meta) throws IOException {
        while (!this._pieces.isEmpty() && ((Pair)this._pieces.peek()).is.available() == 0) {
            this._pieces.remove();
        }
        if (!this._pieces.isEmpty()) {
            this._iPendingAvailable += is.available();
        }
        this._pieces.add(new Pair<META>(is, meta));
    }

    @Override
    public int available() throws IOException {
        return this._iPendingAvailable + (this._pieces.isEmpty() ? 0 : ((Pair)this._pieces.peek()).is.available());
    }

    @Override
    public int read() throws IOException {
        this.read(this._abRead1, 0, 1);
        return this._abRead1[0] & 0xFF;
    }

    @Override
    public int read(@Nonnull byte[] abBuff, int iOffsetInBuff, int iBytesToRead) throws IOException {
        block3: {
            int iBytesRemaining;
            block2: {
                iBytesRemaining = iBytesToRead;
                while (true) {
                    if (this._pieces.isEmpty()) {
                        throw new IllegalStateException("First check if anything is available before reading");
                    }
                    int iAvailable = ((Pair)this._pieces.peek()).is.available();
                    if (iBytesRemaining <= iAvailable) break;
                    ((Pair)this._pieces.peek()).is.read(abBuff, iOffsetInBuff, iAvailable);
                    iBytesRemaining -= iAvailable;
                    iOffsetInBuff += iAvailable;
                    this.moveToNextPiece();
                }
                if (iBytesRemaining != 1) break block2;
                abBuff[iOffsetInBuff] = (byte)((Pair)this._pieces.peek()).is.read();
                break block3;
            }
            if (iBytesRemaining <= 0) break block3;
            ((Pair)this._pieces.peek()).is.read(abBuff, iOffsetInBuff, iBytesRemaining);
        }
        return iBytesToRead;
    }

    @Override
    public long skip(long lngBytesToSkip) throws IOException {
        block2: {
            long lngBytesRemaining = lngBytesToSkip;
            while (true) {
                if (this._pieces.isEmpty()) {
                    throw new IllegalStateException("First check if anything is available before reading");
                }
                int iAvailable = ((Pair)this._pieces.peek()).is.available();
                if (lngBytesRemaining <= (long)iAvailable) break;
                lngBytesRemaining -= (long)iAvailable;
                this.moveToNextPiece();
            }
            if (lngBytesRemaining <= 0L) break block2;
            ((Pair)this._pieces.peek()).is.skip(lngBytesRemaining);
        }
        return lngBytesToSkip;
    }

    private void moveToNextPiece() throws IOException {
        this._pieces.remove();
        if (this._pieces.isEmpty()) {
            throw new IllegalStateException("First check if anything is available before reading");
        }
        this._iPendingAvailable -= ((Pair)this._pieces.peek()).is.available();
    }

    @Nonnull
    public META getCurrentMeta() {
        if (this._pieces.isEmpty()) {
            throw new IllegalStateException("There is no available stream + meta data");
        }
        return (META)((Pair)this._pieces.peek()).meta;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    private static class Pair<T> {
        @Nonnull
        private final InputStream is;
        @Nonnull
        private final T meta;

        public Pair(@Nonnull InputStream is, @Nonnull T meta) {
            this.is = is;
            this.meta = meta;
        }
    }
}

