/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class Misc {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final URI CURRENT_URI = new File(".").toURI();
    private static final String[] ZERO_PAD = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000", "0000000000000", "00000000000000", "000000000000000", "0000000000000000", "00000000000000000", "000000000000000000", "0000000000000000000", "00000000000000000000", "000000000000000000000", "0000000000000000000000", "00000000000000000000000", "000000000000000000000000", "0000000000000000000000000", "00000000000000000000000000", "000000000000000000000000000", "0000000000000000000000000000", "00000000000000000000000000000", "000000000000000000000000000000", "0000000000000000000000000000000", "00000000000000000000000000000000"};

    @Nonnull
    public static byte[] stringToAscii(@Nonnull String string) {
        return string.getBytes(US_ASCII);
    }

    @Nonnull
    public static String asciiToString(@Nonnull byte[] ascii) {
        return Misc.asciiToString(ascii, 0, ascii.length);
    }

    @Nonnull
    public static String asciiToString(@Nonnull byte[] ascii, int iOffset, int iLength) {
        return new String(ascii, iOffset, iLength, US_ASCII);
    }

    @Nonnull
    public static Date dateFromSeconds(int iSeconds) {
        Calendar c = Calendar.getInstance();
        c.set(0, 0, 0, 0, 0, iSeconds);
        return c.getTime();
    }

    @CheckForNull
    public static String[] regex(@Nonnull String regex, @Nonnull String s) {
        return Misc.regex(Pattern.compile(regex), s);
    }

    @CheckForNull
    public static String[] regex(@Nonnull Pattern regex, @Nonnull String s) {
        Matcher m = regex.matcher(s);
        if (!m.find()) {
            return null;
        }
        String[] as = new String[m.groupCount() + 1];
        for (int i = 0; i < as.length; ++i) {
            as[i] = m.group(i);
        }
        return as;
    }

    @Nonnull
    public static String[] regexAll(@Nonnull Pattern regex, @Nonnull String s) {
        Matcher m = regex.matcher(s);
        ArrayList<String> matches = new ArrayList<String>();
        while (m.find()) {
            for (int i = 0; i <= m.groupCount(); ++i) {
                matches.add(m.group(i));
            }
        }
        return matches.toArray(new String[matches.size()]);
    }

    public static int parseIntOrDefault(@CheckForNull String sInt, int iDefault) throws NumberFormatException {
        if (sInt == null) {
            return iDefault;
        }
        return Integer.parseInt(sInt);
    }

    @Nonnull
    public static String stack2string(@Nonnull Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static int intCompare(int i1, int i2) {
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return 0;
    }

    public static boolean objectEquals(@CheckForNull Object o1, @CheckForNull Object o2) {
        return o1 == o2 || o1 != null && o2 != null && o1.equals(o2);
    }

    @Nonnull
    public static String dup(@Nonnull String s, int count) {
        if (count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Nonnull
    public static String dup(char c, int count) {
        if (count == 0) {
            return "";
        }
        char[] ac = new char[count];
        Arrays.fill(ac, c);
        return new String(ac);
    }

    @Nonnull
    public static String removeExt(@Nonnull String sFileName) {
        int i = sFileName.lastIndexOf(46);
        if (i >= 0) {
            return sFileName.substring(0, i);
        }
        return sFileName;
    }

    @Nonnull
    public static String getExt(@Nonnull String sFileName) {
        int i = sFileName.lastIndexOf(46);
        if (i >= 0) {
            return sFileName.substring(i + 1);
        }
        return "";
    }

    @Nonnull
    public static String forwardSlashPath(@Nonnull File f) {
        return CURRENT_URI.relativize(f.toURI()).toString();
    }

    @Nonnull
    public static String join(@Nonnull Iterable<?> ao, @Nonnull String sBetween) {
        StringBuilder sb = new StringBuilder();
        boolean blnFirst = true;
        for (Object o : ao) {
            if (!blnFirst) {
                sb.append(sBetween);
            } else {
                blnFirst = false;
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    @Nonnull
    public static String join(@Nonnull Object[] ao, @Nonnull String sBetween) {
        StringBuilder sb = new StringBuilder();
        boolean blnFirst = true;
        for (Object o : ao) {
            if (!blnFirst) {
                sb.append(sBetween);
            } else {
                blnFirst = false;
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    @CheckForNull
    public static int[] splitInt(@Nonnull String s, @Nonnull String regex) {
        String[] asSplit = s.split(regex);
        return Misc.stringArrayToIntArray(asSplit);
    }

    @CheckForNull
    public static long[] splitLong(@Nonnull String s, @Nonnull String regex) {
        String[] split = s.split(regex);
        long[] ai = new long[split.length];
        try {
            for (int i = 0; i < split.length; ++i) {
                ai[i] = Long.parseLong(split[i]);
            }
            return ai;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @CheckForNull
    public static int[] stringArrayToIntArray(@Nonnull String[] as) {
        try {
            int[] aiVals = new int[as.length];
            for (int i = 0; i < as.length; ++i) {
                aiVals[i] = Integer.parseInt(as[i]);
                if (aiVals[i] >= 0) continue;
                return null;
            }
            return aiVals;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Nonnull
    public static String bitsToString(long lng, int iLength) {
        String sBin = Long.toBinaryString(lng);
        return Misc.zeroPadString(sBin, iLength, true);
    }

    @Nonnull
    public static String intToPadded0String(int i, int iLength) {
        String sInt = Integer.toString(i);
        return Misc.zeroPadString(sInt, iLength, false);
    }

    @Nonnull
    public static String zeroPadString(@Nonnull String s, int iLength, boolean blnTrim) {
        int iSLen = s.length();
        if (iSLen < iLength) {
            return ZERO_PAD[iLength - iSLen] + s;
        }
        if (iSLen > iLength && blnTrim) {
            return s.substring(iSLen - iLength);
        }
        return s;
    }

    public static void log(@Nonnull Logger log, @Nonnull Level level, @CheckForNull Throwable cause, @Nonnull String sMessage, Object ... aoArguments) {
        LogRecord lr = new LogRecord(level, sMessage);
        lr.setLoggerName(log.getName());
        lr.setParameters(aoArguments);
        lr.setThrown(cause);
        log.log(lr);
    }
}

