/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import javax.annotation.Nonnull;

public class Imaging {
    public static final ColorModel LINEAR_RGB_INT;
    public static final IndexColorModel LINEAR_GRAY_INDEXED;

    @Nonnull
    public static BufferedImage createLinearRgbInt(@Nonnull int[] aiRgb, int iWidth, int iHeight) {
        WritableRaster oRaster = LINEAR_RGB_INT.createCompatibleWritableRaster(iWidth, iHeight);
        oRaster.setDataElements(0, 0, iWidth, iHeight, aiRgb);
        return new BufferedImage(LINEAR_RGB_INT, oRaster, false, null);
    }

    @Nonnull
    public static BufferedImage createLinearGrayIndexed256(@Nonnull byte[] abGray, int iWidth, int iHeight) {
        WritableRaster raster = LINEAR_GRAY_INDEXED.createCompatibleWritableRaster(iWidth, iHeight);
        raster.setDataElements(0, 0, iWidth, iHeight, abGray);
        return new BufferedImage(LINEAR_GRAY_INDEXED, raster, false, null);
    }

    static {
        ColorSpace clrSpace = ColorSpace.getInstance(1004);
        LINEAR_RGB_INT = new DirectColorModel(clrSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
        byte[] abPal = new byte[256];
        for (int i = 0; i < abPal.length; ++i) {
            abPal[i] = (byte)i;
        }
        LINEAR_GRAY_INDEXED = new IndexColorModel(8, abPal.length, abPal, abPal, abPal);
    }
}

