/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.i18n.I;
import jpsxdec.i18n.exception.LocalizedFileNotFoundException;

public final class IO {
    private static final byte[] ZEROS = new byte[1024];

    @CheckForNull
    public static IOException closeSilently(@CheckForNull Closeable obj, @Nonnull Logger log) {
        if (obj != null) {
            try {
                obj.close();
                return null;
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, "Exception closing object " + obj, ex);
                return ex;
            }
        }
        return null;
    }

    public static void writeInt4x2(@Nonnull OutputStream stream, byte bTop, byte bBottom) throws IOException {
        stream.write((bTop & 0xF) << 4 | bBottom & 0xF);
    }

    public static int readUInt8(@Nonnull InputStream stream) throws EOFException, IOException {
        int i = stream.read();
        if (i < 0) {
            throw new EOFException();
        }
        return i;
    }

    public static byte readSInt8(@Nonnull InputStream stream) throws EOFException, IOException {
        return (byte)IO.readUInt8(stream);
    }

    public static short readSInt16LE(@Nonnull InputStream stream) throws EOFException, IOException {
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.SInt16LE(b1, b2);
    }

    public static short readSInt16LE(@Nonnull RandomAccessFile stream) throws EOFException, IOException {
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.SInt16LE(b1, b2);
    }

    public static short readSInt16LE(@Nonnull byte[] ab, int i) {
        int b1 = ab[i] & 0xFF;
        int b2 = ab[i + 1] & 0xFF;
        return IO.SInt16LE(b1, b2);
    }

    public static short SInt16LE(int b1, int b2) {
        return (short)((b2 & 0xFF) << 8 | b1 & 0xFF);
    }

    public static int readUInt16LE(@Nonnull InputStream stream) throws EOFException, IOException {
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.UInt16LE(b1, b2);
    }

    public static int readUInt16LE(@Nonnull RandomAccessFile stream) throws EOFException, IOException {
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.UInt16LE(b1, b2);
    }

    public static int readUInt16LE(@Nonnull byte[] ab, int i) {
        int b1 = ab[i] & 0xFF;
        int b2 = ab[i + 1] & 0xFF;
        return IO.UInt16LE(b1, b2);
    }

    public static int UInt16LE(int b1, int b2) {
        return (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public static int readSInt16BE(@Nonnull InputStream stream) throws EOFException, IOException {
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.SInt16BE(b1, b2);
    }

    public static short readSInt16BE(@Nonnull byte[] ab, int i) {
        int b1 = ab[i] & 0xFF;
        int b2 = ab[i + 1] & 0xFF;
        return IO.SInt16BE(b1, b2);
    }

    public static short SInt16BE(int b1, int b2) {
        return (short)((b1 & 0xFF) << 8 | b2 & 0xFF);
    }

    public static int readUInt16BE(@Nonnull InputStream stream) throws EOFException, IOException {
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.UInt16BE(b1, b2);
    }

    public static int UInt16BE(int b1, int b2) {
        return (b1 & 0xFF) << 8 | b2 & 0xFF;
    }

    public static void writeInt16LE(@Nonnull RandomAccessFile stream, short si) throws IOException {
        stream.write(si & 0xFF);
        stream.write(si >>> 8 & 0xFF);
    }

    public static void writeInt16LE(@Nonnull OutputStream stream, int i) throws IOException {
        stream.write(i & 0xFF);
        stream.write(i >>> 8 & 0xFF);
    }

    public static void writeInt16LE(@Nonnull byte[] ab, int pos, short si) {
        ab[pos] = (byte)(si & 0xFF);
        ab[pos + 1] = (byte)(si >>> 8 & 0xFF);
    }

    public static void writeInt16BE(@Nonnull OutputStream stream, int i) throws IOException {
        stream.write(i >>> 8 & 0xFF);
        stream.write(i & 0xFF);
    }

    public static void writeInt16BE(@Nonnull byte[] ab, int pos, short si) {
        ab[pos] = (byte)(si >>> 8 & 0xFF);
        ab[pos + 1] = (byte)(si & 0xFF);
    }

    public static int readSInt32LE(@Nonnull InputStream stream) throws EOFException, IOException {
        int b4;
        int b3;
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0 || (b3 = stream.read()) < 0 || (b4 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.SInt32LE(b1, b2, b3, b4);
    }

    public static int readSInt32LE(@Nonnull RandomAccessFile stream) throws EOFException, IOException {
        int b4;
        int b3;
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0 || (b3 = stream.read()) < 0 || (b4 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.SInt32LE(b1, b2, b3, b4);
    }

    public static int readSInt32LE(@Nonnull byte[] ab, int i) {
        int b1 = ab[i + 0] & 0xFF;
        int b2 = ab[i + 1] & 0xFF;
        int b3 = ab[i + 2] & 0xFF;
        int b4 = ab[i + 3] & 0xFF;
        return IO.SInt32LE(b1, b2, b3, b4);
    }

    public static int SInt32LE(int b1, int b2, int b3, int b4) {
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    public static long readUInt32LE(@Nonnull RandomAccessFile stream) throws EOFException, IOException {
        long b4;
        long b3;
        long b2;
        long b1 = stream.read();
        if (b1 < 0L || (b2 = (long)stream.read()) < 0L || (b3 = (long)stream.read()) < 0L || (b4 = (long)stream.read()) < 0L) {
            throw new EOFException();
        }
        return IO.UInt32LE(b1, b2, b3, b4);
    }

    public static long readUInt32LE(@Nonnull InputStream stream) throws EOFException, IOException {
        long b4;
        long b3;
        long b2;
        long b1 = stream.read();
        if (b1 < 0L || (b2 = (long)stream.read()) < 0L || (b3 = (long)stream.read()) < 0L || (b4 = (long)stream.read()) < 0L) {
            throw new EOFException();
        }
        return IO.UInt32LE(b1, b2, b3, b4);
    }

    public static long readUInt32LE(@Nonnull byte[] ab, int i) {
        long b1 = (long)ab[i + 0] & 0xFFL;
        long b2 = (long)ab[i + 1] & 0xFFL;
        long b3 = (long)ab[i + 2] & 0xFFL;
        long b4 = (long)ab[i + 3] & 0xFFL;
        return IO.UInt32LE(b1, b2, b3, b4);
    }

    public static long UInt32LE(long b1, long b2, long b3, long b4) {
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    public static int readSInt32BE(@Nonnull InputStream stream) throws EOFException, IOException {
        int b4;
        int b3;
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0 || (b3 = stream.read()) < 0 || (b4 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.SInt32BE(b1, b2, b3, b4);
    }

    public static int readSInt32BE(@Nonnull byte[] ab, int i) {
        int b1 = ab[i + 0] & 0xFF;
        int b2 = ab[i + 1] & 0xFF;
        int b3 = ab[i + 2] & 0xFF;
        int b4 = ab[i + 3] & 0xFF;
        return IO.SInt32BE(b1, b2, b3, b4);
    }

    public static int SInt32BE(int b1, int b2, int b3, int b4) {
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public static long readUInt32BE(@Nonnull byte[] ab, int i) {
        long b4 = ab[i + 0] & 0xFF;
        long b3 = ab[i + 1] & 0xFF;
        long b2 = ab[i + 2] & 0xFF;
        long b1 = ab[i + 3] & 0xFF;
        long total = b4 << 24 | b3 << 16 | b2 << 8 | b1;
        return total;
    }

    public static long readUInt32BE(@Nonnull InputStream stream) throws EOFException, IOException {
        int b4;
        int b3;
        int b2;
        int b1 = stream.read();
        if (b1 < 0 || (b2 = stream.read()) < 0 || (b3 = stream.read()) < 0 || (b4 = stream.read()) < 0) {
            throw new EOFException();
        }
        return IO.SInt32BE(b1, b2, b3, b4);
    }

    public static void writeInt32LE(@Nonnull OutputStream stream, long lng) throws IOException {
        int i = (int)lng;
        stream.write(i & 0xFF);
        stream.write(i >>> 8 & 0xFF);
        stream.write(i >>> 16 & 0xFF);
        stream.write(i >>> 24 & 0xFF);
    }

    public static void writeInt32LE(@Nonnull RandomAccessFile stream, long lng) throws IOException {
        int i = (int)lng;
        stream.write(i & 0xFF);
        stream.write(i >>> 8 & 0xFF);
        stream.write(i >>> 16 & 0xFF);
        stream.write(i >>> 24 & 0xFF);
    }

    public static void writeInt32LE(@Nonnull byte[] ab, int pos, long lng) {
        int i = (int)lng;
        ab[pos] = (byte)(i & 0xFF);
        ab[pos + 1] = (byte)(i >>> 8 & 0xFF);
        ab[pos + 2] = (byte)(i >>> 16 & 0xFF);
        ab[pos + 3] = (byte)(i >>> 24 & 0xFF);
    }

    public static void writeInt32BE(@Nonnull OutputStream stream, int i) throws IOException {
        stream.write(i >>> 24 & 0xFF);
        stream.write(i >>> 16 & 0xFF);
        stream.write(i >>> 8 & 0xFF);
        stream.write(i & 0xFF);
    }

    public static long readSInt64BE(@Nonnull InputStream stream) throws EOFException, IOException {
        long lngRet = 0L;
        for (int i = 0; i < 8; ++i) {
            int iByte = stream.read();
            if (iByte < 0) {
                throw new EOFException();
            }
            lngRet = lngRet << 8 | (long)iByte;
        }
        return lngRet;
    }

    public static long readSInt64BE(@Nonnull byte[] ab, int i) {
        long lngRet = 0L;
        for (int j = i; j < i + 8; ++j) {
            int iByte = ab[j] & 0xFF;
            lngRet = lngRet << 8 | (long)iByte;
        }
        return lngRet;
    }

    @Nonnull
    public static byte[] readByteArray(@Nonnull InputStream stream, int iBytesToRead) throws EOFException, IOException {
        assert (iBytesToRead > 0);
        byte[] ab = new byte[iBytesToRead];
        IO.readByteArray(stream, ab);
        return ab;
    }

    @Nonnull
    public static byte[] readByteArray(@Nonnull RandomAccessFile stream, int iBytesToRead) throws EOFException, IOException {
        assert (iBytesToRead > 0);
        byte[] ab = new byte[iBytesToRead];
        IO.readByteArray(stream, ab);
        return ab;
    }

    public static void readByteArray(@Nonnull InputStream stream, @Nonnull byte[] abBuffer) throws EOFException, IOException {
        IO.readByteArray(stream, abBuffer, 0, abBuffer.length);
    }

    public static void readByteArray(@Nonnull RandomAccessFile stream, @Nonnull byte[] abBuffer) throws EOFException, IOException {
        IO.readByteArray(stream, abBuffer, 0, abBuffer.length);
    }

    public static void readByteArray(@Nonnull InputStream stream, @Nonnull byte[] abBuffer, int iStartOffset, int iBytesToRead) throws EOFException, IOException {
        int iBytesRead = IO.readByteArrayMax(stream, abBuffer, iStartOffset, iBytesToRead);
        if (iBytesRead < iBytesToRead) {
            throw new EOFException();
        }
    }

    public static void readByteArray(@Nonnull RandomAccessFile stream, @Nonnull byte[] abBuffer, int iStartOffset, int iBytesToRead) throws EOFException, IOException {
        int iBytesRead = IO.readByteArrayMax(stream, abBuffer, iStartOffset, iBytesToRead);
        if (iBytesRead < iBytesToRead) {
            throw new EOFException();
        }
    }

    public static int readByteArrayMax(@Nonnull InputStream stream, @Nonnull byte[] abBuffer, int iStartOffset, int iBytesToRead) throws EOFException, IOException {
        int iRemainingBytes = iBytesToRead;
        int iBytesRead = stream.read(abBuffer, iStartOffset, iRemainingBytes);
        if (iBytesRead < 0) {
            return 0;
        }
        iRemainingBytes -= iBytesRead;
        while (iRemainingBytes > 0 && (iBytesRead = stream.read(abBuffer, iStartOffset += iBytesRead, iRemainingBytes)) >= 0) {
            iRemainingBytes -= iBytesRead;
        }
        return iBytesToRead - iRemainingBytes;
    }

    public static int readByteArrayMax(@Nonnull RandomAccessFile stream, @Nonnull byte[] abBuffer, int iStartOffset, int iBytesToRead) throws EOFException, IOException {
        int iRemainingBytes = iBytesToRead;
        int iBytesRead = stream.read(abBuffer, iStartOffset, iRemainingBytes);
        if (iBytesRead < 0) {
            return 0;
        }
        iRemainingBytes -= iBytesRead;
        while (iRemainingBytes > 0 && (iBytesRead = stream.read(abBuffer, iStartOffset += iBytesRead, iRemainingBytes)) >= 0) {
            iRemainingBytes -= iBytesRead;
        }
        return iBytesToRead - iRemainingBytes;
    }

    public static void skip(@Nonnull InputStream stream, long lngTotal) throws EOFException, IOException {
        long lngBytesSkipped = IO.skipEofCheck(stream.skip(lngTotal), -1L);
        lngTotal -= lngBytesSkipped;
        while (lngTotal > 0L) {
            lngBytesSkipped = IO.skipEofCheck(stream.skip(lngTotal), lngBytesSkipped);
            lngTotal -= lngBytesSkipped;
        }
    }

    private static long skipEofCheck(long lngBytesRead, long lngPrevBytesRead) throws EOFException {
        if (lngBytesRead < 0L) {
            throw new EOFException();
        }
        if (lngBytesRead == 0L && lngPrevBytesRead == 0L) {
            throw new EOFException();
        }
        return lngBytesRead;
    }

    public static void skip(@Nonnull RandomAccessFile stream, int iTotal) throws EOFException, IOException {
        int iBytesSkipped = IO.skipEofCheck(stream.skipBytes(iTotal), -1);
        iTotal -= iBytesSkipped;
        while (iTotal > 0) {
            iBytesSkipped = IO.skipEofCheck(stream.skipBytes(iTotal), iBytesSkipped);
            iTotal -= iBytesSkipped;
        }
    }

    private static int skipEofCheck(int iBytesRead, int iPrevBytesRead) throws EOFException {
        if (iBytesRead < 0) {
            throw new EOFException();
        }
        if (iBytesRead == 0 && iPrevBytesRead == 0) {
            throw new EOFException();
        }
        return iBytesRead;
    }

    public static int skipMax(@Nonnull InputStream stream, int iTotal) throws IOException {
        long lngBytesSkipped;
        long lngPrevBytesSkipped = stream.skip(iTotal);
        if (lngPrevBytesSkipped < 0L) {
            return 0;
        }
        for (long lngBytesRemain = (long)iTotal - lngPrevBytesSkipped; lngBytesRemain > 0L; lngBytesRemain -= lngBytesSkipped) {
            lngBytesSkipped = stream.skip(lngBytesRemain);
            if (lngBytesSkipped < 0L || lngBytesSkipped == 0L && lngPrevBytesSkipped == 0L) {
                return (int)((long)iTotal - lngBytesRemain);
            }
            lngPrevBytesSkipped = lngBytesSkipped;
        }
        return iTotal;
    }

    public static void writeFile(@Nonnull String sFile, @Nonnull byte[] ab) throws FileNotFoundException, IOException {
        IO.writeFile(new File(sFile), ab);
    }

    public static void writeFile(@Nonnull File file, @Nonnull byte[] ab) throws FileNotFoundException, IOException {
        IO.writeFile(file, ab, 0, ab.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(@Nonnull File file, @Nonnull byte[] ab, int iStart, int iLen) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(ab, iStart, iLen);
        }
        finally {
            fos.close();
        }
    }

    public static void writeIStoFile(@Nonnull InputStream stream, @Nonnull String sFile) throws FileNotFoundException, IOException {
        IO.writeIStoFile(stream, new File(sFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIStoFile(@Nonnull InputStream stream, @Nonnull File file) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            IO.writeIStoOS(stream, fos);
        }
        finally {
            fos.close();
        }
    }

    public static void writeIStoOS(@Nonnull InputStream is, @Nonnull OutputStream os) throws IOException {
        int i;
        byte[] b = new byte[2048];
        while ((i = is.read(b)) > 0) {
            os.write(b, 0, i);
        }
    }

    @Nonnull
    public static byte[] readFile(@Nonnull String sFile) throws FileNotFoundException, IOException {
        return IO.readFile(new File(sFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static byte[] readFile(@Nonnull File file) throws FileNotFoundException, IOException {
        RandomAccessFile stream = new RandomAccessFile(file, "r");
        try {
            if (stream.length() > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Unable to read file larger than max array size.");
            }
            byte[] byArray = IO.readByteArray(stream, (int)stream.length());
            return byArray;
        }
        finally {
            stream.close();
        }
    }

    @Nonnull
    public static byte[] readEntireStream(@Nonnull InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.writeIStoOS(stream, baos);
        return baos.toByteArray();
    }

    public static void makeDirs(@CheckForNull File dir) throws LocalizedFileNotFoundException {
        if (dir == null) {
            return;
        }
        if (!dir.mkdirs()) {
            if (!dir.exists()) {
                throw new LocalizedFileNotFoundException(I.UNABLE_TO_CREATE_DIR(dir));
            }
            if (!dir.isDirectory()) {
                throw new LocalizedFileNotFoundException(I.CANNOT_CREATE_DIR_OVER_FILE(dir));
            }
        }
    }

    public static void makeDirsForFile(@Nonnull File f) throws LocalizedFileNotFoundException {
        IO.makeDirs(f.getParentFile());
    }

    public static void writeZeros(@Nonnull OutputStream stream, int iCount) throws IOException {
        while (iCount > 0) {
            int iToWrite = ZEROS.length;
            if (iToWrite > iCount) {
                iToWrite = iCount;
            }
            stream.write(ZEROS, 0, iToWrite);
            iCount -= iToWrite;
        }
    }

    public static void writeZeros(@Nonnull RandomAccessFile stream, int iCount) throws IOException {
        while (iCount > 0) {
            int iToWrite = ZEROS.length;
            if (iToWrite > iCount) {
                iToWrite = iCount;
            }
            stream.write(ZEROS, 0, iToWrite);
            iCount -= iToWrite;
        }
    }

    public static class ZeroInputStream
    extends InputStream {
        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            Arrays.fill(b, off, len, (byte)0);
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            return n;
        }
    }
}

