/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import javax.annotation.Nonnull;

public class Fraction
implements Cloneable,
Comparable<Fraction> {
    public static final Fraction ZERO = new Fraction(0L, 1L);
    protected final long numerator_;
    protected final long denominator_;

    public final long getNumerator() {
        return this.numerator_;
    }

    public final long getDenominator() {
        return this.denominator_;
    }

    public Fraction(int i) {
        this(i, 1L);
    }

    public Fraction(long num, long den) {
        boolean numNonnegative = num >= 0L;
        boolean denNonnegative = den >= 0L;
        long a = numNonnegative ? num : -num;
        long b = denNonnegative ? den : -den;
        long g = Fraction.gcd(a, b);
        this.numerator_ = numNonnegative == denNonnegative ? a / g : -a / g;
        this.denominator_ = b / g;
    }

    public Fraction(@Nonnull Fraction f) {
        this.numerator_ = f.getNumerator();
        this.denominator_ = f.getDenominator();
    }

    public String toString() {
        if (this.getDenominator() == 1L) {
            return String.format("%d", this.getNumerator());
        }
        return String.format("%d/%d (%3f)", this.getNumerator(), this.getDenominator(), this.asDouble());
    }

    @Nonnull
    public Fraction clone() {
        return new Fraction(this);
    }

    public double asDouble() {
        return (double)this.getNumerator() / (double)this.getDenominator();
    }

    public float asFloat() {
        return (float)this.getNumerator() / (float)this.getDenominator();
    }

    public int asInt() {
        return (int)(this.getNumerator() / this.getDenominator());
    }

    public static long gcd(long a, long b) {
        long y;
        long x;
        if (a < 0L) {
            a = -a;
        }
        if (b < 0L) {
            b = -b;
        }
        if (a >= b) {
            x = a;
            y = b;
        } else {
            x = b;
            y = a;
        }
        while (y != 0L) {
            long t = x % y;
            x = y;
            y = t;
        }
        return x;
    }

    @Nonnull
    public static Fraction divide(long a, Fraction b) {
        long an = a;
        long ad = 1L;
        long bn = b.getNumerator();
        long bd = b.getDenominator();
        return new Fraction(an * bd, ad * bn);
    }

    @Nonnull
    public Fraction negative() {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        return new Fraction(-an, ad);
    }

    @Nonnull
    public Fraction reciprocal() {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        return new Fraction(ad, an);
    }

    @Nonnull
    public Fraction add(Fraction b) {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        long bn = b.getNumerator();
        long bd = b.getDenominator();
        return new Fraction(an * bd + bn * ad, ad * bd);
    }

    @Nonnull
    public Fraction add(long n) {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        long bn = n;
        long bd = 1L;
        return new Fraction(an * bd + bn * ad, ad * bd);
    }

    @Nonnull
    public Fraction subtract(Fraction b) {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        long bn = b.getNumerator();
        long bd = b.getDenominator();
        return new Fraction(an * bd - bn * ad, ad * bd);
    }

    @Nonnull
    public Fraction subtract(long n) {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        long bn = n;
        long bd = 1L;
        return new Fraction(an * bd - bn * ad, ad * bd);
    }

    @Nonnull
    public Fraction multiply(Fraction b) {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        long bn = b.getNumerator();
        long bd = b.getDenominator();
        return new Fraction(an * bn, ad * bd);
    }

    @Nonnull
    public Fraction multiply(long n) {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        long bn = n;
        long bd = 1L;
        return new Fraction(an * bn, ad * bd);
    }

    public float multiply(float f) {
        return (float)this.getNumerator() * f / (float)this.getDenominator();
    }

    @Nonnull
    public Fraction divide(@Nonnull Fraction b) {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        long bn = b.getNumerator();
        long bd = b.getDenominator();
        return new Fraction(an * bd, ad * bn);
    }

    @Nonnull
    public Fraction divide(long n) {
        long an = this.getNumerator();
        long ad = this.getDenominator();
        long bn = n;
        long bd = 1L;
        return new Fraction(an * bd, ad * bn);
    }

    @Nonnull
    public Fraction abs() {
        return new Fraction(Math.abs(this.numerator_), this.denominator_);
    }

    @Override
    public int compareTo(Fraction other) {
        long r;
        long an = this.getNumerator();
        long ad = this.getDenominator();
        long bn = other.getNumerator();
        long bd = other.getDenominator();
        long l = an * bd;
        return l < (r = bn * ad) ? -1 : (l == r ? 0 : 1);
    }

    @Override
    public int compareTo(long n) {
        long ad;
        long bn;
        long r;
        long bd;
        long an = this.getNumerator();
        long l = an * (bd = 1L);
        return l < (r = (bn = n) * (ad = this.getDenominator())) ? -1 : (l == r ? 0 : 1);
    }

    public boolean equals(Object other) {
        return this.compareTo((Fraction)other) == 0;
    }

    public boolean equals(long n) {
        return this.compareTo(n) == 0;
    }

    public int hashCode() {
        return (int)(this.numerator_ ^ this.denominator_);
    }
}

