/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import jpsxdec.util.ExposedBAOS;

public class DemuxedData<T extends Piece>
implements Iterable<T> {
    @Nonnull
    private final List<? extends T> _pieces;
    private final int _iStartSector;
    private final int _iEndSector;
    private final int _iStartDataOffset;
    private final int _iEndDataOffset;
    private final int _iDataSize;

    public DemuxedData(@Nonnull List<? extends T> pieces) {
        this(pieces, 0, pieces.isEmpty() ? -1 : ((Piece)pieces.get(pieces.size() - 1)).getDemuxPieceSize());
    }

    public DemuxedData(@Nonnull List<? extends T> pieces, int iStartPieceOffset, int iEndPieceOffset) {
        if (pieces.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (pieces.contains(null)) {
            throw new IllegalArgumentException();
        }
        if (pieces.size() == 1) {
            if (iStartPieceOffset > iEndPieceOffset) {
                throw new IllegalArgumentException();
            }
            if (iStartPieceOffset < 0) {
                throw new IllegalArgumentException();
            }
            if (iEndPieceOffset > ((Piece)pieces.get(pieces.size() - 1)).getDemuxPieceSize()) {
                throw new IllegalArgumentException();
            }
        } else {
            if (iStartPieceOffset < 0 || iEndPieceOffset > ((Piece)pieces.get(pieces.size() - 1)).getDemuxPieceSize()) {
                throw new IllegalArgumentException();
            }
            if (iStartPieceOffset >= ((Piece)pieces.get(0)).getDemuxPieceSize() || iEndPieceOffset <= 0) {
                throw new IllegalArgumentException("Trim the pieces first");
            }
        }
        this._pieces = pieces;
        this._iStartDataOffset = iStartPieceOffset;
        this._iEndDataOffset = iEndPieceOffset;
        int iSize = 0;
        int iStartSector = Integer.MAX_VALUE;
        int iEndSector = Integer.MIN_VALUE;
        for (int iPiece = 0; iPiece < this._pieces.size(); ++iPiece) {
            Piece piece = (Piece)this._pieces.get(iPiece);
            int iStart = 0;
            if (iPiece == 0) {
                iStart = this._iStartDataOffset;
            }
            int iEnd = piece.getDemuxPieceSize();
            if (iPiece == this._pieces.size() - 1) {
                iEnd = this._iEndDataOffset;
            }
            iSize += iEnd - iStart;
            int iSectorNumber = piece.getSectorNumber();
            if (iSectorNumber < iStartSector) {
                iStartSector = iSectorNumber;
            }
            if (iSectorNumber <= iEndSector) continue;
            iEndSector = iSectorNumber;
        }
        this._iStartSector = iStartSector;
        this._iEndSector = iEndSector;
        this._iDataSize = iSize;
    }

    public int getPieceCount() {
        return this._pieces.size();
    }

    public int getStartSector() {
        return this._iStartSector;
    }

    public int getEndSector() {
        return this._iEndSector;
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this._pieces.iterator();
    }

    public int getStartDataOffset() {
        return this._iStartDataOffset;
    }

    public int getEndDataOffset() {
        return this._iEndDataOffset;
    }

    public int getDemuxSize() {
        return this._iDataSize;
    }

    @Nonnull
    public byte[] copyDemuxData() {
        ExposedBAOS baos = new ExposedBAOS(this.getDemuxSize());
        byte[] abCopyBuff = null;
        for (int iPiece = 0; iPiece < this._pieces.size(); ++iPiece) {
            Piece piece = (Piece)this._pieces.get(iPiece);
            if (abCopyBuff == null || abCopyBuff.length < piece.getDemuxPieceSize()) {
                abCopyBuff = new byte[piece.getDemuxPieceSize()];
            }
            piece.copyDemuxPieceData(abCopyBuff, 0);
            int iStart = 0;
            if (iPiece == 0) {
                iStart = this._iStartDataOffset;
            }
            int iEnd = piece.getDemuxPieceSize();
            if (iPiece == this._pieces.size() - 1) {
                iEnd = this._iEndDataOffset;
            }
            baos.write(abCopyBuff, iStart, iEnd - iStart);
        }
        return baos.toByteArray();
    }

    public String toString() {
        return String.format("Start sector %d@%d [%d pieces] End sector %d@%d = %d", this._iStartSector, this._iStartDataOffset, this._pieces.size(), this._iEndSector, this._iEndDataOffset, this._iDataSize);
    }

    public static interface Piece {
        public int getDemuxPieceSize();

        public byte getDemuxPieceByte(int var1);

        public void copyDemuxPieceData(@Nonnull byte[] var1, int var2);

        public int getSectorNumber();
    }
}

