/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.BufferedPushIterator;
import jpsxdec.util.DemuxedData;

public class DemuxPushInputStream<T extends DemuxedData.Piece>
extends InputStream {
    private static final Logger LOG = Logger.getLogger(DemuxPushInputStream.class.getName());
    private final BufferedPushIterator<T> _queue = new BufferedPushIterator();
    @Nonnull
    private CopyablePieceSequenceStream<T> _readStream;
    @CheckForNull
    private CopyablePieceSequenceStream<T> _markedStream;
    private int _iMarkReadLimit;
    private boolean _blnClosed = false;

    public DemuxPushInputStream(@Nonnull T firstPiece) {
        this._queue.add(firstPiece);
        this._readStream = new CopyablePieceSequenceStream(this._queue.iterator());
    }

    public void addPiece(@Nonnull T piece) throws IllegalStateException {
        if (this._blnClosed) {
            throw new IllegalStateException("Stream is closed.");
        }
        this._queue.add(piece);
        this._readStream.addAvailable(piece.getDemuxPieceSize());
        if (this._markedStream != null) {
            this._markedStream.addAvailable(piece.getDemuxPieceSize());
        }
    }

    @Override
    public int read() throws NeedsMoreData {
        int i;
        if (this._iMarkReadLimit < 0) {
            this._markedStream = null;
        }
        if ((i = this._readStream.read()) < 0) {
            if (this._blnClosed) {
                return -1;
            }
            throw new NeedsMoreData();
        }
        if (this._markedStream != null) {
            --this._iMarkReadLimit;
        }
        return i;
    }

    @Override
    public long skip(long lngBytesToSkip) throws NeedsMoreData {
        long lngBytesSkipped;
        if ((long)this._iMarkReadLimit < lngBytesToSkip) {
            this._markedStream = null;
        }
        if ((lngBytesSkipped = this._readStream.skip(lngBytesToSkip)) < lngBytesToSkip) {
            if (this._blnClosed) {
                return lngBytesSkipped;
            }
            throw new NeedsMoreData();
        }
        if (this._markedStream != null) {
            this._iMarkReadLimit = (int)((long)this._iMarkReadLimit - lngBytesSkipped);
        }
        return lngBytesSkipped == 0L ? -1L : lngBytesSkipped;
    }

    @Override
    public int read(byte[] b) throws NeedsMoreData {
        try {
            return super.read(b);
        }
        catch (NeedsMoreData ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new RuntimeException("Should not happen", ex);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws NeedsMoreData {
        try {
            return super.read(b, off, len);
        }
        catch (NeedsMoreData ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new RuntimeException("Should not happen", ex);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this._markedStream = this._readStream.copy();
        this._iMarkReadLimit = readlimit;
        int iAvailable = this.available();
        if (!this._blnClosed || iAvailable < readlimit) {
            // empty if block
        }
    }

    @Override
    public void reset() {
        if (this._markedStream == null) {
            return;
        }
        this._readStream = this._markedStream;
        this._markedStream = null;
        this._iMarkReadLimit = 0;
    }

    @Override
    public int available() {
        return this._readStream.available();
    }

    @Override
    public void close() {
        this._blnClosed = true;
    }

    public boolean isEof() {
        return this._readStream.isEof();
    }

    @Nonnull
    public T getCurrentPiece() {
        return this._readStream.getCurrentPiece();
    }

    public int getOffsetInCurrentPiece() {
        return this._readStream.getCurrentPieceOffset();
    }

    @Nonnull
    public DemuxedData<T> getMarkToReadDemux() {
        if (this._markedStream == null) {
            throw new IllegalStateException();
        }
        BufferedPushIterator.Iter startIterator = ((CopyablePieceSequenceStream)this._markedStream)._pieceIterator;
        int iStartOfs = this._markedStream.getCurrentPieceOffset();
        BufferedPushIterator.Iter endIterator = ((CopyablePieceSequenceStream)this._readStream)._pieceIterator;
        int iEndOfs = this._readStream.getCurrentPieceOffset();
        List pieces = startIterator.getElementSpanTo(endIterator);
        assert (!pieces.isEmpty());
        int iStartSector = 0;
        if (iStartOfs == ((DemuxedData.Piece)pieces.get(0)).getDemuxPieceSize()) {
            iStartOfs = 0;
            iStartSector = 1;
        }
        ArrayList sectorSpan = new ArrayList(pieces.size() - iStartSector);
        for (int i = iStartSector; i < pieces.size(); ++i) {
            sectorSpan.add(pieces.get(i));
        }
        return new DemuxedData(sectorSpan, iStartOfs, iEndOfs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._readStream);
        if (this._markedStream != null) {
            sb.append(" [marked ").append(this._markedStream).append(" remaining ").append(this._iMarkReadLimit).append("]");
        }
        if (this._blnClosed) {
            sb.append(" closed");
        } else {
            sb.append(" open");
        }
        return sb.toString();
    }

    private static class CopyablePieceSequenceStream<T extends DemuxedData.Piece>
    extends InputStream {
        @Nonnull
        private final BufferedPushIterator.Iter<T> _pieceIterator;
        @Nonnull
        private PieceInputStream<T> _currentPieceStream;
        private int _iAvailable = 0;

        public CopyablePieceSequenceStream(@Nonnull BufferedPushIterator.Iter<T> pieceInterator) {
            this._pieceIterator = pieceInterator;
            this._currentPieceStream = new PieceInputStream<DemuxedData.Piece>((DemuxedData.Piece)this._pieceIterator.next());
            this._iAvailable = this._currentPieceStream.available();
            BufferedPushIterator.Iter<T> it = this._pieceIterator.copy();
            while (it.hasNext()) {
                this._iAvailable += ((DemuxedData.Piece)it.next()).getDemuxPieceSize();
            }
        }

        public CopyablePieceSequenceStream(@Nonnull BufferedPushIterator.Iter<T> pieceIterator, @Nonnull PieceInputStream<T> currentPieceStream, int iAvailable) {
            this._pieceIterator = pieceIterator.copy();
            this._currentPieceStream = currentPieceStream.copy();
            this._iAvailable = iAvailable;
        }

        @Nonnull
        public CopyablePieceSequenceStream<T> copy() {
            return new CopyablePieceSequenceStream<T>(this._pieceIterator, this._currentPieceStream, this._iAvailable);
        }

        public boolean isEof() {
            return this._currentPieceStream.isEof() && !this._pieceIterator.hasNext();
        }

        @Override
        public int read() {
            if (this.isEof()) {
                return -1;
            }
            this.skipEofStreams();
            if (this.isEof()) {
                return -1;
            }
            --this._iAvailable;
            return this._currentPieceStream.read();
        }

        private void skipEofStreams() {
            while (this._currentPieceStream.isEof() && this._pieceIterator.hasNext()) {
                this._currentPieceStream = new PieceInputStream<DemuxedData.Piece>((DemuxedData.Piece)this._pieceIterator.next());
            }
        }

        @Override
        public long skip(long lngBytesToSkip) {
            if (this.isEof()) {
                return -1L;
            }
            long lngTotalBytesSkipped = 0L;
            while (lngTotalBytesSkipped < lngBytesToSkip && !this.isEof()) {
                this.skipEofStreams();
                long lngBytesSkipped = this._currentPieceStream.skip(lngBytesToSkip - lngTotalBytesSkipped);
                if (lngBytesSkipped <= 0L) continue;
                lngTotalBytesSkipped += lngBytesSkipped;
            }
            this._iAvailable = (int)((long)this._iAvailable - lngTotalBytesSkipped);
            return lngTotalBytesSkipped == 0L ? -1L : lngTotalBytesSkipped;
        }

        @Override
        public int available() {
            return this._iAvailable;
        }

        public void addAvailable(int iAddedBytes) {
            this._iAvailable += iAddedBytes;
        }

        public int getCurrentPieceOffset() {
            return this._currentPieceStream.getReadOffset();
        }

        @Nonnull
        public T getCurrentPiece() {
            return this._currentPieceStream.getPiece();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._currentPieceStream);
            if (this._pieceIterator.hasNext()) {
                sb.append(" has next");
            } else {
                sb.append(" iterator end");
            }
            return sb.toString();
        }
    }

    private static class PieceInputStream<T extends DemuxedData.Piece>
    extends InputStream {
        @Nonnull
        private final T _piece;
        private int _iReadHead;

        public PieceInputStream(@Nonnull T piece) {
            this._piece = piece;
            this._iReadHead = 0;
        }

        private PieceInputStream(@Nonnull T piece, int iReadHead) {
            this._piece = piece;
            this._iReadHead = iReadHead;
        }

        @Nonnull
        public PieceInputStream<T> copy() {
            return new PieceInputStream<T>(this._piece, this._iReadHead);
        }

        public boolean isEof() {
            return this.available() <= 0;
        }

        @Override
        public int read() {
            if (this.isEof()) {
                return -1;
            }
            byte b = this._piece.getDemuxPieceByte(this._iReadHead);
            ++this._iReadHead;
            return b & 0xFF;
        }

        @Override
        public long skip(long lngBytesToSkip) {
            long lngBytesSkipped;
            if (this.isEof()) {
                return -1L;
            }
            int iSkippableBytes = this.available();
            if ((long)iSkippableBytes <= lngBytesToSkip) {
                lngBytesSkipped = iSkippableBytes;
                this._iReadHead = this._piece.getDemuxPieceSize();
            } else {
                lngBytesSkipped = lngBytesToSkip;
                this._iReadHead = (int)((long)this._iReadHead + lngBytesToSkip);
            }
            return lngBytesSkipped;
        }

        @Override
        public int available() {
            return this._piece.getDemuxPieceSize() - this._iReadHead;
        }

        @Nonnull
        public T getPiece() {
            return this._piece;
        }

        public int getReadOffset() {
            return this._iReadHead;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("byte ").append(this._iReadHead).append(" of ").append(this._piece.getDemuxPieceSize());
            return sb.toString();
        }
    }

    public static class NeedsMoreData
    extends IOException {
    }
}

