/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.BufferedIOIterator;
import jpsxdec.util.DemuxedData;
import jpsxdec.util.IOIterator;

public class DemuxPullInputStream<T extends DemuxedData.Piece>
extends InputStream {
    @Nonnull
    private BufferedIOIterator<T> _readIt;
    @CheckForNull
    private BufferedIOIterator<T> _markedIt;
    private int _iReadOffset = 0;
    private int _iMarkedOffset;
    private int _iMarkReadLimit;

    public DemuxPullInputStream(@Nonnull IOIterator<T> sourceIterator) {
        this._readIt = new BufferedIOIterator<T>(sourceIterator);
    }

    @CheckForNull
    private T currentPiece() throws NoSuchElementException, IOException {
        DemuxedData.Piece c = this._readIt.hasPrevious() ? (DemuxedData.Piece)this._readIt.peekPrevious() : (this._readIt.hasNext() ? (DemuxedData.Piece)this._readIt.next() : null);
        return (T)c;
    }

    private boolean moveToNextPiece() throws NoSuchElementException, IOException {
        if (this._readIt.hasNext()) {
            this._readIt.next();
            return true;
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        T c;
        if (this._iMarkReadLimit < 0) {
            this._markedIt = null;
        }
        if ((c = this.currentPiece()) == null) {
            return -1;
        }
        while (this._iReadOffset >= c.getDemuxPieceSize()) {
            if (!this.moveToNextPiece()) {
                return -1;
            }
            this._iReadOffset = 0;
            c = this.currentPiece();
            assert (c != null);
        }
        byte b = c.getDemuxPieceByte(this._iReadOffset);
        ++this._iReadOffset;
        if (this._markedIt != null) {
            --this._iMarkReadLimit;
        }
        return b;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this._markedIt = this._readIt.copy();
        this._iMarkedOffset = this._iReadOffset;
        this._iMarkReadLimit = readlimit;
    }

    @Override
    public void reset() {
        if (this._markedIt == null) {
            return;
        }
        this._readIt = this._markedIt;
        this._markedIt = null;
        this._iReadOffset = this._iMarkedOffset;
    }

    @Override
    public int available() throws IOException {
        Object c = this.currentPiece();
        if (c == null) {
            return 0;
        }
        int iAvailable = c.getDemuxPieceSize() - this._iReadOffset;
        BufferedIOIterator<T> it = this._readIt.copy();
        while (it.isNextBuffered()) {
            c = (DemuxedData.Piece)it.next();
            iAvailable += c.getDemuxPieceSize();
        }
        return iAvailable;
    }

    @Override
    public void close() {
    }

    @CheckForNull
    public DemuxedData<T> getMarkToReadDemux() {
        if (this._markedIt == null) {
            throw new IllegalStateException();
        }
        int iStartOfs = this._iMarkedOffset;
        int iEndOfs = this._iReadOffset;
        List<T> pieces = this._markedIt.getElementSpanTo(this._readIt);
        if (pieces.isEmpty()) {
            return null;
        }
        int iStartSector = 0;
        if (iStartOfs == ((DemuxedData.Piece)pieces.get(0)).getDemuxPieceSize()) {
            iStartOfs = 0;
            iStartSector = 1;
        }
        ArrayList<T> src = new ArrayList<T>(pieces.size() - iStartSector);
        for (int i = iStartSector; i < pieces.size(); ++i) {
            src.add(pieces.get(i));
        }
        return new DemuxedData(src, iStartOfs, iEndOfs);
    }
}

