/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.io.ByteArrayInputStream;
import javax.annotation.Nonnull;

public class ByteArrayFPIS
extends ByteArrayInputStream {
    private long _lngFP = 0L;
    private final int _iBufStart;

    public ByteArrayFPIS(@Nonnull byte[] buf, int offset, int length) {
        super(buf, offset, length);
        this._iBufStart = this.pos;
    }

    public ByteArrayFPIS(@Nonnull byte[] buf) {
        super(buf);
        this._iBufStart = this.pos;
    }

    public ByteArrayFPIS(@Nonnull byte[] buf, int offset, int length, long filePos) {
        super(buf, offset, length);
        this._lngFP = filePos;
        this._iBufStart = this.pos;
    }

    public ByteArrayFPIS(@Nonnull byte[] buf, long filePos) {
        super(buf);
        this._lngFP = filePos;
        this._iBufStart = this.pos;
    }

    public ByteArrayFPIS(@Nonnull ByteArrayFPIS bafp, int offset, int length, long filePos) {
        super(bafp.buf, bafp.pos + offset, length);
        this._lngFP = filePos;
        this._iBufStart = this.pos;
    }

    public ByteArrayFPIS(@Nonnull ByteArrayFPIS bafp, int offset, int length) {
        super(bafp.buf, bafp.pos + offset, length);
        this._lngFP = bafp._lngFP;
        this._iBufStart = this.pos;
    }

    public ByteArrayFPIS(@Nonnull ByteArrayFPIS bafp) {
        super(bafp.buf, bafp.pos, bafp.count - bafp.pos);
        this._lngFP = bafp._lngFP;
        this._iBufStart = bafp._iBufStart;
    }

    public long getFilePointer() {
        return this._lngFP + (long)this.pos - (long)this._iBufStart;
    }

    public int getOffset() {
        return this.pos - this._iBufStart;
    }

    public int getStreamByteSize() {
        return this.count - this._iBufStart;
    }

    @Nonnull
    public ByteArrayFPIS copy() {
        return new ByteArrayFPIS(this);
    }

    public String toString() {
        return String.format("FP:%d Stream:%d/%d Buf:%d/%d", this.getFilePointer(), this.getOffset(), this.getStreamByteSize(), this.pos, this.buf.length);
    }
}

