/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.IOIterator;

public class BufferedPushIterator<T>
implements Iterable<T> {
    @Nonnull
    private Element<T> _tail = new Element<Object>(null);

    public void add(@Nonnull T element) {
        Element<T> e = new Element<T>(element);
        this._tail._next = e;
        this._tail = e;
    }

    @Override
    @Nonnull
    public Iter<T> iterator() {
        if (this._tail._value == null) {
            return new Iter(this._tail);
        }
        Element<Object> e = new Element<Object>(null);
        e._next = this._tail;
        return new Iter(e);
    }

    public static class Iter<T>
    implements Iterator<T>,
    IOIterator<T> {
        @Nonnull
        private Element<T> _head;

        private Iter(@Nonnull Element<T> head) {
            this._head = head;
        }

        public boolean hasPrevious() {
            return this._head.hasPrevious();
        }

        @Nonnull
        public T peekPrevious() throws NoSuchElementException {
            return this._head.previous();
        }

        @Override
        public boolean hasNext() {
            return this._head.hasNext();
        }

        @Override
        @Nonnull
        public T next() throws NoSuchElementException {
            this._head = this._head.next();
            return this._head.previous();
        }

        @Nonnull
        public Iter<T> copy() {
            return new Iter<T>(this._head);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public List<T> getElementSpanTo(@Nonnull Iter<T> other) {
            ArrayList list = new ArrayList();
            Element<T> head = this._head;
            while (head != other._head) {
                if (head._value != null) {
                    list.add(head._value);
                }
                if ((head = head._next) != null) continue;
                throw new IllegalArgumentException();
            }
            if (head._value != null) {
                list.add(head._value);
            }
            return list;
        }

        public String toString() {
            return this._head.toString();
        }
    }

    private static class Element<T> {
        @CheckForNull
        public final T _value;
        @CheckForNull
        public Element<T> _next;

        public Element(@CheckForNull T value) {
            this._value = value;
            this._next = null;
        }

        public boolean hasPrevious() {
            return this._value != null;
        }

        @Nonnull
        public T previous() throws NoSuchElementException {
            if (this._value == null) {
                throw new NoSuchElementException();
            }
            return this._value;
        }

        public boolean hasNext() {
            return this._next != null;
        }

        @Nonnull
        public Element<T> next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._value);
            if (this._next == null) {
                sb.append(" no next");
            } else {
                sb.append(" has next");
            }
            return sb.toString();
        }
    }
}

