/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.IOIterator;

public class BufferedIOIterator<T>
implements IOIterator<T> {
    @Nonnull
    private final IOIterator<T> _source;
    @Nonnull
    private Element<T> _head;

    public BufferedIOIterator(@Nonnull IOIterator<T> iterator) {
        this._source = iterator;
        this._head = new Element<Object>(null);
    }

    private BufferedIOIterator(@Nonnull IOIterator<T> iterator, @Nonnull Element<T> head) {
        this._source = iterator;
        this._head = head;
    }

    public boolean hasPrevious() {
        return this._head.hasPrevious();
    }

    @Nonnull
    public T peekPrevious() throws NoSuchElementException {
        return this._head.previous();
    }

    @Override
    public boolean hasNext() {
        return this._head.hasNext(this._source);
    }

    @Override
    @Nonnull
    public T next() throws NoSuchElementException, IOException {
        this._head = this._head.next(this._source);
        return this._head.previous();
    }

    public boolean isNextBuffered() {
        return ((Element)this._head).hasBufferedNext();
    }

    @Nonnull
    public BufferedIOIterator<T> copy() {
        return new BufferedIOIterator<T>(this._source, this._head);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + this._source.hashCode();
        hash = 29 * hash + this._head.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BufferedIOIterator other = (BufferedIOIterator)obj;
        if (this._source != other._source) {
            return false;
        }
        return this._head == other._head;
    }

    @Nonnull
    public List<T> getElementSpanTo(@Nonnull BufferedIOIterator<T> other) {
        ArrayList list = new ArrayList();
        Element<T> h = this._head;
        if (h._value != null) {
            list.add(h._value);
        }
        while (h != other._head) {
            Element next = h._next;
            if (next == null) {
                throw new IllegalArgumentException();
            }
            h = next;
            if (h._value == null) {
                throw new IllegalStateException();
            }
            list.add(h._value);
        }
        return list;
    }

    public String toString() {
        return this._head.toString();
    }

    private static class Element<T> {
        @CheckForNull
        public final T _value;
        @CheckForNull
        public Element<T> _next;

        public Element(@CheckForNull T value) {
            this._value = value;
            this._next = null;
        }

        public boolean hasPrevious() {
            return this._value != null;
        }

        @Nonnull
        public T previous() throws NoSuchElementException {
            if (this._value == null) {
                throw new NoSuchElementException();
            }
            return this._value;
        }

        public boolean hasNext(@Nonnull IOIterator<T> source) {
            if (this._next == null) {
                return source.hasNext();
            }
            return true;
        }

        @Nonnull
        public Element<T> next(@Nonnull IOIterator<T> source) throws NoSuchElementException, IOException {
            if (this._next == null) {
                this._next = new Element<T>(source.next());
            }
            return this._next;
        }

        private boolean hasBufferedNext() {
            return this._next != null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._value);
            if (this._next == null) {
                sb.append(" no next");
            } else {
                sb.append(" has next");
            }
            return sb.toString();
        }
    }
}

