/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AudioOutputFileWriter
implements Runnable,
Closeable {
    private static final Logger LOG = Logger.getLogger(AudioOutputFileWriter.class.getName());
    @Nonnull
    private final PipedInputStream _threadInputStream;
    @Nonnull
    private final AudioInputStream _threadAudioStream;
    @Nonnull
    private final Thread _writingThread;
    @Nonnull
    private final File _outFile;
    @Nonnull
    private final PipedOutputStream _feedStream;
    @Nonnull
    private final AudioFormat _format;
    @Nonnull
    private final AudioFileFormat.Type _eFileFormat;
    @CheckForNull
    private Throwable _writingError;

    public AudioOutputFileWriter(@Nonnull String sFile, @Nonnull AudioFormat format, @Nonnull AudioFileFormat.Type eFileFormat) throws IOException {
        this(new File(sFile), format, eFileFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioOutputFileWriter(@Nonnull File file, @Nonnull AudioFormat format, @Nonnull AudioFileFormat.Type eFileFormat) throws IOException {
        this._format = format;
        this._eFileFormat = eFileFormat;
        this._outFile = file;
        this._threadInputStream = new PipedInputStream();
        this._feedStream = new PipedOutputStream(this._threadInputStream);
        this._threadAudioStream = new AudioInputStream(this._threadInputStream, format, -1L);
        this._writingThread = new Thread((Runnable)this, AudioOutputFileWriter.class.getSimpleName() + " " + this._outFile);
        this._writingThread.start();
        try {
            PipedInputStream pipedInputStream = this._threadInputStream;
            synchronized (pipedInputStream) {
                this._threadInputStream.wait();
                if (this._writingError != null) {
                    if (this._writingError instanceof IOException) {
                        throw (IOException)this._writingError;
                    }
                    throw new RuntimeException(this._writingError);
                }
            }
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            AudioSystem.write(this._threadAudioStream, this._eFileFormat, this._outFile);
        }
        catch (Throwable ex) {
            PipedInputStream pipedInputStream = this._threadInputStream;
            synchronized (pipedInputStream) {
                this._writingError = ex;
                this._threadInputStream.notifyAll();
            }
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nonnull byte[] abData, int iOffset, int iLength) throws IOException {
        PipedInputStream pipedInputStream = this._threadInputStream;
        synchronized (pipedInputStream) {
            if (this._writingError != null) {
                if (this._writingError instanceof IOException) {
                    throw (IOException)this._writingError;
                }
                throw new RuntimeException(this._writingError);
            }
        }
        this._feedStream.write(abData, iOffset, iLength);
        pipedInputStream = this._threadInputStream;
        synchronized (pipedInputStream) {
            if (this._writingError != null) {
                if (this._writingError instanceof IOException) {
                    throw (IOException)this._writingError;
                }
                throw new RuntimeException(this._writingError);
            }
        }
    }

    @Nonnull
    public AudioFormat getFormat() {
        return this._format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this._feedStream.flush();
        try {
            this._feedStream.close();
        }
        finally {
            try {
                this._writingThread.join();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
    }
}

