/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.util;

import argparser.BooleanHolder;
import argparser.StringHolder;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.util.Misc;

public class ArgParser {
    private static final String[] HELPS = new String[]{"-?", "-h", "-help"};
    @CheckForNull
    private String[] _asArgs;
    @CheckForNull
    private argparser.ArgParser _currentParser;

    public ArgParser(@CheckForNull String[] asArgs) {
        this._asArgs = asArgs;
    }

    public boolean hasHelp() {
        if (this._asArgs == null) {
            return false;
        }
        argparser.ArgParser ap = new argparser.ArgParser("", false);
        BooleanHolder help = new BooleanHolder();
        ap.addOption(Misc.join(HELPS, ",") + " %v", help);
        ap.matchAllArgs(this._asArgs, 0, 0);
        return help.value;
    }

    @Nonnull
    public StringHolder addStringOption(String ... asFlags) {
        this.currentArgParse();
        StringHolder sh = new StringHolder();
        this._currentParser.addOption(Misc.join(asFlags, ",") + " %s", sh);
        return sh;
    }

    @Nonnull
    public BooleanHolder addBoolOption(String ... asFlags) {
        this.currentArgParse();
        BooleanHolder bh = new BooleanHolder();
        this._currentParser.addOption(Misc.join(asFlags, ",") + " %v", bh);
        return bh;
    }

    @Nonnull
    public BooleanHolder addBoolOption(boolean blnDefault, String ... asFlags) {
        this.currentArgParse();
        BooleanHolder bh = new BooleanHolder(blnDefault);
        this._currentParser.addOption(Misc.join(asFlags, ",") + " %v", bh);
        return bh;
    }

    private void currentArgParse() {
        if (this._currentParser == null) {
            this._currentParser = new argparser.ArgParser("", false);
        }
    }

    @Nonnull
    public BooleanHolder addHelp() {
        return this.addBoolOption(HELPS);
    }

    public void match() {
        if (this._currentParser == null) {
            throw new IllegalStateException();
        }
        if (this._asArgs != null) {
            this._asArgs = this._currentParser.matchAllArgs(this._asArgs, 0, 0);
        }
        this._currentParser = null;
    }

    public boolean hasRemaining() {
        return this._asArgs != null && this._asArgs.length > 0;
    }

    @Nonnull
    public ArgParser copy() {
        return new ArgParser(this._asArgs);
    }
}

