/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.tim;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jpsxdec.tim.Tim;
import jpsxdec.util.IO;

public class TimValidator {
    private static final Logger LOG = Logger.getLogger(TimValidator.class.getName());
    private static final int MAX_TIM_WORD_WIDTH = 16384;
    private static final int MAX_TIM_HEIGHT = 8192;
    private int _iBitsPerPixel = -1;
    private boolean _blnHasClut;
    private int _iTimByteSize = -1;
    private int _iTimX = -1;
    private int _iTimY = -1;
    private int _iWordWidth = -1;
    private int _iPixelHeight = -1;
    private int _iClutByteSize = -1;
    private int _iClutX = -1;
    private int _iClutY = -1;
    private int _iClutPixelWidth = -1;
    private int _iClutPixelHeight = -1;

    public boolean tagIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        return IO.readUInt8(is) == 16;
    }

    public boolean versionIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        return IO.readUInt8(is) == 0;
    }

    public boolean unknownIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        return IO.readUInt16LE(is) == 0;
    }

    public boolean bppAndClutIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        int iBpp_hasClut = IO.readUInt16LE(is);
        if ((iBpp_hasClut & 0xFFF4) != 0) {
            return false;
        }
        this._blnHasClut = (iBpp_hasClut & 8) != 0;
        switch (iBpp_hasClut & 3) {
            case 0: {
                this._iBitsPerPixel = 4;
                break;
            }
            case 1: {
                this._iBitsPerPixel = 8;
                break;
            }
            case 2: {
                this._iBitsPerPixel = 16;
                break;
            }
            case 3: {
                this._iBitsPerPixel = 24;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return true;
    }

    public boolean bppIsValid(int iBitsPerPixel) {
        return this.bppIsValid(iBitsPerPixel, iBitsPerPixel == 4 || iBitsPerPixel == 8);
    }

    public boolean bppIsValid(int iBitsPerPixel, boolean blnHasClut) {
        switch (iBitsPerPixel) {
            case 4: 
            case 8: 
            case 16: 
            case 24: {
                this._iBitsPerPixel = iBitsPerPixel;
                break;
            }
            default: {
                return false;
            }
        }
        this._blnHasClut = blnHasClut;
        return true;
    }

    public int getBitPerPixel() {
        return this._iBitsPerPixel;
    }

    public boolean hasClut() {
        return this._blnHasClut;
    }

    public boolean timByteSizeIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        int MAX_POSSIBLE_TIM_DATA_SIZE = 0x1000000C;
        int iImageDataByteSize = IO.readSInt32LE(is);
        if (iImageDataByteSize <= 0 || iImageDataByteSize > 0x1000000C) {
            return false;
        }
        this._iTimByteSize = iImageDataByteSize;
        return true;
    }

    public int getImageDataByteSize() {
        return this._iTimByteSize - 12;
    }

    public boolean timXisValid(@Nonnull InputStream is) throws EOFException, IOException {
        return this.timXisValid(IO.readUInt16LE(is));
    }

    public boolean timXisValid(int iTimX) {
        if (iTimX < 0 || iTimX >= 16384) {
            return false;
        }
        this._iTimX = iTimX;
        return true;
    }

    public int getTimX() {
        return this._iTimX;
    }

    public boolean timYisValid(@Nonnull InputStream is) throws EOFException, IOException {
        return this.timYisValid(IO.readUInt16LE(is));
    }

    public boolean timYisValid(int iTimY) {
        if (iTimY < 0 || iTimY >= 8192) {
            return false;
        }
        this._iTimY = iTimY;
        return true;
    }

    public int getTimY() {
        return this._iTimY;
    }

    public boolean wordWidthIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        return this.wordWidthIsValid(IO.readUInt16LE(is));
    }

    public boolean wordWidthIsValid(int iWordWidth) {
        if (iWordWidth <= 0 || iWordWidth > 16384) {
            return false;
        }
        this._iWordWidth = iWordWidth;
        return true;
    }

    public int getWordWidth() {
        return this._iWordWidth;
    }

    public boolean pixelWidthIsValid(int iPixelWidth) {
        int iWordWidth;
        if (this._iBitsPerPixel == 16) {
            iWordWidth = iPixelWidth;
        } else if (this._iBitsPerPixel == 4) {
            if (iPixelWidth % 4 != 0) {
                return false;
            }
            iWordWidth = iPixelWidth / 2 / 2;
        } else {
            if (iPixelWidth % 2 != 0) {
                return false;
            }
            if (this._iBitsPerPixel == 8) {
                iWordWidth = iPixelWidth / 2;
            } else if (this._iBitsPerPixel == 24) {
                iWordWidth = iPixelWidth * 3 / 2;
            } else {
                throw new IllegalStateException("Invalid bits-per-pixel " + this._iBitsPerPixel);
            }
        }
        return this.wordWidthIsValid(iWordWidth);
    }

    public int getPixelWidth() {
        return Tim.calculatePixelWidth(this._iWordWidth, this._iBitsPerPixel);
    }

    public boolean pixelHeightIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        return this.pixelHeightIsValid(IO.readUInt16LE(is));
    }

    public boolean pixelHeightIsValid(int iPixelHeight) {
        if (iPixelHeight <= 0 || iPixelHeight > 8192) {
            return false;
        }
        this._iPixelHeight = iPixelHeight;
        return true;
    }

    public int getPixelHeight() {
        return this._iPixelHeight;
    }

    @Nonnull
    public TimConsistency timIsConsistent() {
        int iExpectedTimByteSize = this._iWordWidth * 2 * this._iPixelHeight + 12;
        TimConsistency consistency = TimConsistency.TOTALLY_CONSISTENT;
        if (this._iTimByteSize != iExpectedTimByteSize) {
            if (this._iTimByteSize < iExpectedTimByteSize || this._iTimByteSize > iExpectedTimByteSize + 2) {
                return TimConsistency.INCONSISTENT;
            }
            LOG.log(Level.WARNING, "Tim data requires only {0} bytes but header says Tim is {1} bytes", new Object[]{iExpectedTimByteSize, this._iTimByteSize});
            consistency = TimConsistency.INCONSISTENT_BUT_VALID;
        }
        if (this._blnHasClut) {
            if (this._iBitsPerPixel == 16) {
                this._iBitsPerPixel = this._iClutPixelWidth < 256 ? 4 : 8;
                LOG.log(Level.WARNING, "TIM reports 16 bits/pixel, but it also has a CLUT. Assuming {0,number,#} bits/pixel", this._iBitsPerPixel);
                consistency = TimConsistency.INCONSISTENT_BUT_VALID;
            } else if (this._iBitsPerPixel == 24) {
                LOG.log(Level.WARNING, "TIM reports 24 bits/pixel, but it also has a CLUT. Assuming 8 bits/pixel");
                this._iBitsPerPixel = 8;
                consistency = TimConsistency.INCONSISTENT_BUT_VALID;
            }
        }
        return consistency;
    }

    public boolean clutByteSizeIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        int CLUT_MAX_BYTE_SIZE = 0x1000000C;
        int iClutByteSize = IO.readSInt32LE(is);
        if (iClutByteSize <= 0 || iClutByteSize > 0x1000000C || iClutByteSize % 2 != 0) {
            return false;
        }
        this._iClutByteSize = iClutByteSize;
        return true;
    }

    public int getClutImageDataByteSize() {
        return this._iClutByteSize - 12;
    }

    public int getClutImageDataWordSize() {
        return this.getClutImageDataByteSize() / 2;
    }

    public boolean clutXisValid(@Nonnull InputStream is) throws EOFException, IOException {
        return this.clutXisValid(IO.readUInt16LE(is));
    }

    public boolean clutXisValid(int iClutX) {
        if (iClutX < 0 || iClutX >= 16384) {
            return false;
        }
        this._iClutX = iClutX;
        return true;
    }

    public int getClutX() {
        return this._iClutX;
    }

    public boolean clutYisValid(@Nonnull InputStream is) throws EOFException, IOException {
        return this.clutYisValid(IO.readUInt16LE(is));
    }

    public boolean clutYisValid(int iClutY) {
        if (iClutY < 0 || iClutY >= 8192) {
            return false;
        }
        this._iClutY = iClutY;
        return true;
    }

    public int getClutY() {
        return this._iClutY;
    }

    public boolean clutPixelWidthIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        return this.clutPixelWidthIsValid(IO.readUInt16LE(is));
    }

    public boolean clutPixelWidthIsValid(int iClutWidth) {
        if (iClutWidth <= 0 || iClutWidth > 16384) {
            return false;
        }
        this._iClutPixelWidth = iClutWidth;
        return true;
    }

    public int getClutPixelWidth() {
        return this._iClutPixelWidth;
    }

    public boolean clutPixelHeightIsValid(@Nonnull InputStream is) throws EOFException, IOException {
        return this.clutPixelHeightIsValid(IO.readUInt16LE(is));
    }

    public boolean clutPixelHeightIsValid(int iClutHeight) {
        if (iClutHeight <= 0 || iClutHeight > 8192) {
            return false;
        }
        this._iClutPixelHeight = iClutHeight;
        return true;
    }

    public int getClutPixelHeight() {
        return this._iClutPixelHeight;
    }

    public boolean clutIsConsistent() {
        int iExpectedClutByteSize = this._iClutPixelWidth * 2 * this._iClutPixelHeight + 12;
        return iExpectedClutByteSize == this._iClutByteSize;
    }

    public static enum TimConsistency {
        TOTALLY_CONSISTENT,
        INCONSISTENT_BUT_VALID,
        INCONSISTENT;

    }
}

