/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.tim;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.PsxRgb;
import jpsxdec.tim.CLUT;
import jpsxdec.tim.CreateTim;
import jpsxdec.tim.TimInfo;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;

public class Tim {
    public static final int SEMI_TRANSPARENT = 254;
    static final int HEADER_SIZE = 12;
    static final int TAG_MAGIC = 16;
    static final int VERSION_0 = 0;
    public static final int MINIMUM_TIM_SIZE = 22;
    private final int _iBitsPerPixel;
    @CheckForNull
    private final CLUT _clut;
    private final int _iTimX;
    private final int _iTimY;
    private final int _iWordWidth;
    private final int _iPixelHeight;
    @Nonnull
    private final byte[] _abImageData;
    private final boolean _blnTimHasIssues;

    @CheckForNull
    public static TimInfo isTim(@Nonnull InputStream inStream) throws EOFException, IOException {
        return CreateTim.isTim(inStream);
    }

    @Nonnull
    public static Tim read(@Nonnull InputStream inStream) throws EOFException, IOException, BinaryDataNotRecognized {
        return CreateTim.read(inStream);
    }

    @Nonnull
    public static Tim create(@Nonnull BufferedImage bi, int iTimX, int iTimY, int iClutX, int iClutY) {
        return CreateTim.create(bi, iTimX, iTimY, iClutX, iClutY);
    }

    @Nonnull
    public static Tim create(@Nonnull BufferedImage bi, int iBitsPerPixel) throws IncompatibleException {
        return CreateTim.create(bi, iBitsPerPixel, 0, 0, 0, 0);
    }

    Tim(@Nonnull byte[] abTimImageData, int iTimX, int iTimY, int iWordWidth, int iPixelHeight, int iBitsPerPixel, @CheckForNull CLUT clut) {
        this(abTimImageData, iTimX, iTimY, iWordWidth, iPixelHeight, iBitsPerPixel, clut, false);
    }

    Tim(@Nonnull byte[] abTimImageData, int iTimX, int iTimY, int iWordWidth, int iPixelHeight, int iBitsPerPixel, @CheckForNull CLUT clut, boolean blnTimHasIssues) {
        this._abImageData = abTimImageData;
        this._iTimX = iTimX;
        this._iTimY = iTimY;
        this._iWordWidth = iWordWidth;
        this._iPixelHeight = iPixelHeight;
        this._iBitsPerPixel = iBitsPerPixel;
        this._clut = clut;
        this._blnTimHasIssues = blnTimHasIssues;
    }

    public int getBitsPerPixel() {
        return this._iBitsPerPixel;
    }

    public int getPaletteCount() {
        if (this._clut == null) {
            return 1;
        }
        return Tim.calcPaletteCount(this._clut._asiColorData.length, this._iBitsPerPixel);
    }

    static int calcPaletteCount(int iClutColorDataLength, int iBitsPerPixel) {
        if (iBitsPerPixel == 4 || iBitsPerPixel == 8) {
            int iColorsForBitsPerPixel = 1 << iBitsPerPixel;
            return iClutColorDataLength / iColorsForBitsPerPixel;
        }
        return 1;
    }

    public int getPixelWidth() {
        return Tim.calculatePixelWidth(this._iWordWidth, this._iBitsPerPixel);
    }

    static int calculatePixelWidth(int iWordWidth, int iBitsPerPixel) {
        switch (iBitsPerPixel) {
            case 4: {
                return iWordWidth * 2 * 2;
            }
            case 8: {
                return iWordWidth * 2;
            }
            case 16: {
                return iWordWidth;
            }
            case 24: {
                return iWordWidth * 2 / 3;
            }
        }
        throw new RuntimeException("Impossible Tim BPP " + iBitsPerPixel);
    }

    public int getPixelHeight() {
        return this._iPixelHeight;
    }

    @Nonnull
    public BufferedImage toBufferedImage(int iPalette) {
        if (iPalette < 0 || iPalette >= this.getPaletteCount()) {
            throw new IllegalArgumentException("Palette index " + iPalette + " out of bounds");
        }
        switch (this._iBitsPerPixel) {
            case 4: {
                return this.toBi4(iPalette);
            }
            case 8: {
                return this.toBi8(iPalette);
            }
            case 16: {
                return this.toBi16();
            }
            case 24: {
                return this.toBi24();
            }
        }
        throw new RuntimeException();
    }

    @CheckForNull
    public BufferedImage getClutImage() {
        if (this._clut != null) {
            return this._clut.toBufferedImage();
        }
        return null;
    }

    public boolean timHasIssues() {
        return this._blnTimHasIssues;
    }

    public void replaceImageData(@Nonnull BufferedImage bi) throws IncompatibleException {
        Tim newTim = Tim.create(bi, this._iBitsPerPixel);
        if (this._clut != null) {
            if (newTim._clut == null) {
                throw new IncompatibleException();
            }
            assert (this._clut._asiColorData.length == newTim._clut._asiColorData.length);
            System.arraycopy(newTim._clut._asiColorData, 0, this._clut._asiColorData, 0, this._clut._asiColorData.length);
        } else if (newTim._clut != null) {
            throw new IncompatibleException();
        }
        assert (this._abImageData.length == newTim._abImageData.length);
        System.arraycopy(newTim._abImageData, 0, this._abImageData, 0, this._abImageData.length);
    }

    public void replaceImageData(@Nonnull BufferedImage bi, @Nonnull BufferedImage clut) throws IncompatibleException {
        if (this._clut == null) {
            throw new IncompatibleException("Can't change the CLUT when Tim doesn't have a CLUT");
        }
        Tim newTim = CreateTim.create(bi, this._iTimX, this._iTimY, clut, this._clut.getX(), this._clut.getY(), this._iBitsPerPixel);
        assert (this._abImageData.length == newTim._abImageData.length);
        System.arraycopy(newTim._abImageData, 0, this._abImageData, 0, this._abImageData.length);
        assert (this._clut._asiColorData.length == newTim._clut._asiColorData.length);
        System.arraycopy(newTim._clut._asiColorData, 0, this._clut._asiColorData, 0, this._clut._asiColorData.length);
    }

    public void write(@Nonnull OutputStream os) throws IOException {
        os.write(16);
        os.write(0);
        IO.writeInt16LE(os, 0);
        IO.writeInt16LE(os, this.calculateBpp_HasCLUT());
        IO.writeInt16LE(os, 0);
        if (this._clut != null) {
            this._clut.write(os);
        }
        IO.writeInt32LE(os, (long)this.calculateByteSize());
        IO.writeInt16LE(os, this._iTimX);
        IO.writeInt16LE(os, this._iTimY);
        IO.writeInt16LE(os, this._iWordWidth);
        IO.writeInt16LE(os, this._iPixelHeight);
        os.write(this._abImageData);
    }

    private int calculateBpp_HasCLUT() {
        int iBitsPerPixReverseLookup;
        switch (this._iBitsPerPixel) {
            case 4: {
                iBitsPerPixReverseLookup = 0;
                break;
            }
            case 8: {
                iBitsPerPixReverseLookup = 1;
                break;
            }
            case 16: {
                iBitsPerPixReverseLookup = 2;
                break;
            }
            case 24: {
                iBitsPerPixReverseLookup = 3;
                break;
            }
            default: {
                throw new IllegalStateException("Unpossible!");
            }
        }
        if (this._clut != null) {
            return iBitsPerPixReverseLookup | 8;
        }
        return iBitsPerPixReverseLookup;
    }

    private int calculateByteSize() {
        return 12 + this._abImageData.length;
    }

    @CheckForNull
    public Mismatch matches(@Nonnull Tim other) {
        if (this._iWordWidth != other._iWordWidth || this.getPixelHeight() != other.getPixelHeight()) {
            return Mismatch.Dimensions;
        }
        if (this.getBitsPerPixel() != other.getBitsPerPixel()) {
            return Mismatch.BitsPerPixel;
        }
        if (this.getPaletteCount() != other.getPaletteCount()) {
            return Mismatch.PaletteCount;
        }
        CLUT otherClut = other._clut;
        if (this._clut == null && otherClut != null) {
            return Mismatch.HasClut;
        }
        if (this._clut != null) {
            if (otherClut == null) {
                return Mismatch.MissingClut;
            }
            if (this._clut.getX() != otherClut.getX() || this._clut.getY() != otherClut.getY()) {
                return Mismatch.ClutXY;
            }
            if (this._clut.getPaletteLength() != otherClut.getPaletteLength()) {
                return Mismatch.ClutPaletteLength;
            }
        }
        return null;
    }

    public String toString() {
        int iRequiredByteSize;
        String s = String.format("%dx%d %dbpp xy(%d, %d) WordWidth:%d Size:", this.getPixelWidth(), this.getPixelHeight(), this.getBitsPerPixel(), this._iTimX, this._iTimY, this._iWordWidth);
        StringBuilder sb = new StringBuilder(s);
        int iActualByteSize = this.calculateByteSize();
        if (iActualByteSize == (iRequiredByteSize = this._iWordWidth * 2 * this._iPixelHeight + 12)) {
            sb.append(iActualByteSize);
        } else {
            sb.append(String.format("%d=%d+%d", iActualByteSize, iRequiredByteSize, iActualByteSize - iRequiredByteSize));
        }
        if (this._clut != null) {
            sb.append(" CLUT[").append(this._clut).append("]");
        }
        return sb.toString();
    }

    @Nonnull
    private BufferedImage toBi4(int iPalette) {
        byte[] abRgbaPalette = new byte[64];
        if (this._clut == null) {
            PsxRgb.fill16GrayRgbaPalette(abRgbaPalette);
        } else {
            int i = iPalette * 16;
            for (int o = 0; o < abRgbaPalette.length; o += 4) {
                int iArgb = PsxRgb.psxABGR1555toARGB8888(this._clut.getColor(i), 254);
                abRgbaPalette[o + 0] = (byte)(iArgb >> 16);
                abRgbaPalette[o + 1] = (byte)(iArgb >> 8);
                abRgbaPalette[o + 2] = (byte)iArgb;
                abRgbaPalette[o + 3] = (byte)(iArgb >> 24);
                ++i;
            }
        }
        IndexColorModel cm = new IndexColorModel(4, 16, abRgbaPalette, 0, true);
        WritableRaster raster = Raster.createPackedRaster(0, this.getPixelWidth(), this.getPixelHeight(), 1, 4, null);
        byte[] abBufferPackedIndexes = ((DataBufferByte)raster.getDataBuffer()).getData();
        for (int i = 0; i < abBufferPackedIndexes.length; ++i) {
            byte b = this._abImageData[i];
            abBufferPackedIndexes[i] = (byte)(b >> 4 & 0xF | b << 4 & 0xF0);
        }
        return new BufferedImage(cm, raster, false, null);
    }

    @Nonnull
    private BufferedImage toBi8(int iPalette) {
        byte[] abRgbaPalette = new byte[1024];
        if (this._clut == null) {
            PsxRgb.fill256GrayRgbaPalette(abRgbaPalette);
        } else {
            int i = iPalette * 256;
            for (int o = 0; o < abRgbaPalette.length; o += 4) {
                int iArgb = PsxRgb.psxABGR1555toARGB8888(this._clut.getColor(i), 254);
                abRgbaPalette[o + 0] = (byte)(iArgb >> 16);
                abRgbaPalette[o + 1] = (byte)(iArgb >> 8);
                abRgbaPalette[o + 2] = (byte)iArgb;
                abRgbaPalette[o + 3] = (byte)(iArgb >> 24);
                ++i;
            }
        }
        IndexColorModel cm = new IndexColorModel(8, 256, abRgbaPalette, 0, true);
        PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, this.getPixelWidth(), this.getPixelHeight(), 1, this.getPixelWidth(), new int[]{0});
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        byte[] abBufferIndexes = ((DataBufferByte)raster.getDataBuffer()).getData();
        System.arraycopy(this._abImageData, 0, abBufferIndexes, 0, abBufferIndexes.length);
        return new BufferedImage(cm, raster, false, null);
    }

    @Nonnull
    private BufferedImage toBi24() {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] aiBits = new int[]{8, 8, 8};
        int[] aiChannelIdxes = new int[]{0, 1, 2};
        ComponentColorModel cm = new ComponentColorModel(cs, aiBits, false, false, 1, 0);
        WritableRaster raster = Raster.createInterleavedRaster(0, this.getPixelWidth(), this.getPixelHeight(), this.getPixelWidth() * 3, 3, aiChannelIdxes, null);
        byte[] abBufferRgb = ((DataBufferByte)raster.getDataBuffer()).getData();
        System.arraycopy(this._abImageData, 0, abBufferRgb, 0, abBufferRgb.length);
        return new BufferedImage(cm, raster, false, null);
    }

    @Nonnull
    private BufferedImage toBi16() {
        BufferedImage bi = new BufferedImage(this.getPixelWidth(), this.getPixelHeight(), 2);
        int[] aiBufferRgba = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        int i = 0;
        for (int o = 0; o < aiBufferRgba.length; ++o) {
            int iColor16 = IO.readUInt16LE(this._abImageData, i);
            aiBufferRgba[o] = PsxRgb.psxABGR1555toARGB8888(iColor16, 254);
            i += 2;
        }
        return bi;
    }

    public static enum Mismatch {
        Dimensions,
        BitsPerPixel,
        PaletteCount,
        HasClut,
        MissingClut,
        ClutWidth,
        ClutXY,
        ClutPaletteLength;

    }
}

