/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.tim;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.PsxRgb;
import jpsxdec.tim.CLUT;
import jpsxdec.tim.Tim;
import jpsxdec.tim.TimInfo;
import jpsxdec.tim.TimValidator;
import jpsxdec.util.BinaryDataNotRecognized;
import jpsxdec.util.IO;
import jpsxdec.util.IncompatibleException;

class CreateTim {
    CreateTim() {
    }

    @CheckForNull
    public static TimInfo isTim(@Nonnull InputStream inStream) throws EOFException, IOException {
        int iPaletteCount;
        TimValidator validator = new TimValidator();
        if (!validator.tagIsValid(inStream)) {
            return null;
        }
        if (!validator.versionIsValid(inStream)) {
            return null;
        }
        if (!validator.unknownIsValid(inStream)) {
            return null;
        }
        if (!validator.bppAndClutIsValid(inStream)) {
            return null;
        }
        if (!validator.unknownIsValid(inStream)) {
            return null;
        }
        if (validator.hasClut()) {
            if (!validator.clutByteSizeIsValid(inStream)) {
                return null;
            }
            if (!validator.clutXisValid(inStream)) {
                return null;
            }
            if (!validator.clutYisValid(inStream)) {
                return null;
            }
            if (!validator.clutPixelWidthIsValid(inStream)) {
                return null;
            }
            if (!validator.clutPixelHeightIsValid(inStream)) {
                return null;
            }
            if (!validator.clutIsConsistent()) {
                return null;
            }
            IO.skip(inStream, (long)validator.getClutImageDataByteSize());
            iPaletteCount = Tim.calcPaletteCount(validator.getClutImageDataWordSize(), validator.getBitPerPixel());
        } else {
            iPaletteCount = 1;
        }
        if (!validator.timByteSizeIsValid(inStream)) {
            return null;
        }
        if (!validator.timXisValid(inStream)) {
            return null;
        }
        if (!validator.timYisValid(inStream)) {
            return null;
        }
        if (!validator.wordWidthIsValid(inStream)) {
            return null;
        }
        if (!validator.pixelHeightIsValid(inStream)) {
            return null;
        }
        TimValidator.TimConsistency consistency = validator.timIsConsistent();
        if (consistency == TimValidator.TimConsistency.INCONSISTENT) {
            return null;
        }
        IO.skip(inStream, (long)validator.getImageDataByteSize());
        return new TimInfo(iPaletteCount, validator.getBitPerPixel(), validator.getPixelWidth(), validator.getPixelHeight());
    }

    @Nonnull
    public static Tim read(@Nonnull InputStream inStream) throws EOFException, IOException, BinaryDataNotRecognized {
        TimValidator validator = new TimValidator();
        if (!validator.tagIsValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        if (!validator.versionIsValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        if (!validator.unknownIsValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        if (!validator.bppAndClutIsValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        if (!validator.unknownIsValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        CLUT clut = null;
        if (validator.hasClut()) {
            if (!validator.clutByteSizeIsValid(inStream)) {
                throw new BinaryDataNotRecognized();
            }
            if (!validator.clutXisValid(inStream)) {
                throw new BinaryDataNotRecognized();
            }
            if (!validator.clutYisValid(inStream)) {
                throw new BinaryDataNotRecognized();
            }
            if (!validator.clutPixelWidthIsValid(inStream)) {
                throw new BinaryDataNotRecognized();
            }
            if (!validator.clutPixelHeightIsValid(inStream)) {
                throw new BinaryDataNotRecognized();
            }
            if (!validator.clutIsConsistent()) {
                throw new BinaryDataNotRecognized();
            }
            short[] asiColorData = new short[validator.getClutImageDataWordSize()];
            for (int i = 0; i < asiColorData.length; ++i) {
                asiColorData[i] = IO.readSInt16LE(inStream);
            }
            clut = new CLUT(asiColorData, validator.getClutX(), validator.getClutY(), validator.getClutPixelWidth(), validator.getClutPixelHeight());
        }
        if (!validator.timByteSizeIsValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        if (!validator.timXisValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        if (!validator.timYisValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        if (!validator.wordWidthIsValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        if (!validator.pixelHeightIsValid(inStream)) {
            throw new BinaryDataNotRecognized();
        }
        TimValidator.TimConsistency consistency = validator.timIsConsistent();
        if (consistency == TimValidator.TimConsistency.INCONSISTENT) {
            throw new BinaryDataNotRecognized();
        }
        byte[] abImageData = IO.readByteArray(inStream, validator.getImageDataByteSize());
        return new Tim(abImageData, validator.getTimX(), validator.getTimY(), validator.getWordWidth(), validator.getPixelHeight(), validator.getBitPerPixel(), clut, consistency == TimValidator.TimConsistency.INCONSISTENT_BUT_VALID);
    }

    @Nonnull
    public static Tim create(@Nonnull BufferedImage bi, int iTimX, int iTimY, int iClutX, int iClutY) {
        int iSrcBpp = CreateTim.findBitsPerPixel(bi);
        int iTargetBpp = iSrcBpp == 32 ? 16 : iSrcBpp;
        try {
            return CreateTim.create(bi, iTargetBpp, iTimX, iTimY, iClutX, iClutY);
        }
        catch (IncompatibleException ex) {
            throw new RuntimeException("Should not happen", ex);
        }
    }

    @Nonnull
    public static Tim create(@Nonnull BufferedImage bi, int iBitsPerPixel, int iTimX, int iTimY, int iClutX, int iClutY) throws IncompatibleException {
        Tim tim;
        int iPaletteLength;
        TimValidator validator = new TimValidator();
        if (!validator.bppIsValid(iBitsPerPixel)) {
            throw new IllegalArgumentException();
        }
        if (!validator.timXisValid(iTimX)) {
            throw new IllegalArgumentException();
        }
        if (!validator.timYisValid(iTimY)) {
            throw new IllegalArgumentException();
        }
        if (!validator.pixelWidthIsValid(bi.getWidth())) {
            throw new IllegalArgumentException();
        }
        if (!validator.pixelHeightIsValid(bi.getHeight())) {
            throw new IllegalArgumentException();
        }
        switch (validator.getBitPerPixel()) {
            case 16: {
                return CreateTim.create16(bi, validator);
            }
            case 24: {
                return CreateTim.create24(bi, validator);
            }
            case 4: {
                iPaletteLength = 16;
                break;
            }
            case 8: {
                iPaletteLength = 256;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        int iSrcBpp = CreateTim.findBitsPerPixel(bi);
        if (iSrcBpp <= validator.getBitPerPixel()) {
            IndexColorModel icm = (IndexColorModel)bi.getColorModel();
            short[] asiClut = CreateTim.extractPalette(icm, iPaletteLength);
            CLUT clut = new CLUT(asiClut, validator.getClutX(), validator.getClutY(), iPaletteLength, 1);
            byte[] abIndexes = CreateTim.extractIndexes(bi, validator.getBitPerPixel() == 4);
            tim = new Tim(abIndexes, validator.getTimX(), validator.getTimY(), validator.getWordWidth(), validator.getPixelHeight(), validator.getBitPerPixel(), clut);
        } else if (iSrcBpp == 8) {
            int[] aiIndexes = bi.getRaster().getPixels(0, 0, bi.getWidth(), bi.getHeight(), (int[])null);
            Arrays.sort(aiIndexes);
            int[] aiMapper = new int[256];
            aiMapper[aiIndexes[0]] = 0;
            int iNewPalSize = 1;
            for (int i = 1; i < aiIndexes.length; ++i) {
                int iIdx = aiIndexes[i];
                if (iIdx == aiIndexes[i - 1]) continue;
                aiMapper[iIdx] = iNewPalSize++;
                if (iNewPalSize <= 16) continue;
                throw new IncompatibleException("Unable to fit image into 16 colors");
            }
            byte[] abTimImg = new byte[aiIndexes.length / 2];
            int i = 0;
            for (int o = 0; o < abTimImg.length; ++o) {
                int iPaletteIdx = aiMapper[aiIndexes[i]];
                iPaletteIdx |= aiMapper[aiIndexes[++i]];
                ++i;
                abTimImg[o] = (byte)iPaletteIdx;
            }
            IndexColorModel icm = (IndexColorModel)bi.getColorModel();
            int[] ai256Palette = new int[256];
            icm.getRGBs(ai256Palette);
            short[] asiClut = new short[16];
            for (int i2 = 0; i2 < iNewPalSize; ++i2) {
                asiClut[i2] = PsxRgb.ARGB8888toPsxABGR1555(ai256Palette[aiMapper[i2]]);
            }
            CLUT clut = new CLUT(asiClut, validator.getClutX(), validator.getClutY(), iPaletteLength, 1);
            tim = new Tim(abTimImg, validator.getTimX(), validator.getTimY(), validator.getWordWidth(), validator.getPixelHeight(), validator.getBitPerPixel(), clut);
        } else {
            tim = CreateTim.createPalettedTim(bi, validator.getBitPerPixel() == 4, validator);
        }
        return tim;
    }

    @Nonnull
    public static Tim create(@Nonnull BufferedImage bi, int iTimX, int iTimY, @Nonnull BufferedImage clutImg, int iClutX, int iClutY, int iBitsPerPixel) {
        int iPaletteSize;
        TimValidator validator = new TimValidator();
        if (!validator.bppIsValid(iBitsPerPixel, true)) {
            throw new IllegalArgumentException();
        }
        if (iBitsPerPixel == 4) {
            iPaletteSize = 16;
        } else if (iBitsPerPixel == 8) {
            iPaletteSize = 256;
        } else {
            throw new IllegalArgumentException("Unable to create a paletted Tim with " + iBitsPerPixel + " bpp");
        }
        if (!validator.clutXisValid(iClutX)) {
            throw new IllegalArgumentException();
        }
        if (!validator.clutYisValid(iClutY)) {
            throw new IllegalArgumentException();
        }
        if (!validator.clutPixelWidthIsValid(clutImg.getWidth())) {
            throw new IllegalArgumentException();
        }
        if (!validator.clutPixelHeightIsValid(clutImg.getHeight())) {
            throw new IllegalArgumentException();
        }
        if (!validator.timXisValid(iTimX)) {
            throw new IllegalArgumentException();
        }
        if (!validator.timYisValid(iTimY)) {
            throw new IllegalArgumentException();
        }
        if (!validator.pixelWidthIsValid(bi.getWidth())) {
            throw new IllegalArgumentException();
        }
        if (!validator.pixelHeightIsValid(bi.getHeight())) {
            throw new IllegalArgumentException();
        }
        ColorModel cm = bi.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            throw new IllegalArgumentException("Image must have IndexColorModel");
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int[] aiPaletteArgb = new int[iPaletteSize];
        icm.getRGBs(aiPaletteArgb);
        int[] aiClut = clutImg.getRGB(0, 0, clutImg.getWidth(), clutImg.getHeight(), null, 0, clutImg.getWidth());
        for (int i = 0; i < aiPaletteArgb.length; ++i) {
            if (aiPaletteArgb[i] == aiClut[i]) continue;
            throw new IllegalArgumentException("Image palette does not match CLUT colors");
        }
        short[] asiClut = new short[aiClut.length];
        for (int i = 0; i < aiClut.length; ++i) {
            asiClut[i] = PsxRgb.ARGB8888toPsxABGR1555(aiClut[i]);
        }
        CLUT clut = new CLUT(asiClut, validator.getClutX(), validator.getClutY(), validator.getClutPixelWidth(), validator.getClutPixelHeight());
        byte[] abTimImg = CreateTim.extractIndexes(bi, iBitsPerPixel == 4);
        return new Tim(abTimImg, validator.getTimX(), validator.getTimY(), validator.getWordWidth(), validator.getPixelHeight(), validator.getBitPerPixel(), clut);
    }

    private static int findBitsPerPixel(@Nonnull BufferedImage bi) {
        if (bi.getColorModel() instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)bi.getColorModel();
            int iPaletteSize = icm.getMapSize();
            if (iPaletteSize <= 16) {
                return 4;
            }
            if (iPaletteSize <= 256) {
                return 8;
            }
            return 32;
        }
        return 32;
    }

    @Nonnull
    private static byte[] extractIndexes(@Nonnull BufferedImage bi, boolean bln4bppOrNot8bpp) {
        byte[] abIndexes;
        int[] aiIndexes = bi.getRaster().getPixels(0, 0, bi.getWidth(), bi.getHeight(), (int[])null);
        if (bln4bppOrNot8bpp) {
            assert (bi.getWidth() % 2 == 0);
            abIndexes = new byte[aiIndexes.length / 2];
            int i = 0;
            int o = 0;
            while (i < aiIndexes.length) {
                int iIdx1 = aiIndexes[i];
                ++i;
                if (iIdx1 >= 16) {
                    throw new IllegalArgumentException("Caller should have ensured palette index " + iIdx1 + " is < 16");
                }
                int iIdx2 = aiIndexes[i];
                ++i;
                if (iIdx2 >= 16) {
                    throw new IllegalArgumentException("Caller should have ensured palette index " + iIdx2 + " is < 16");
                }
                abIndexes[o] = (byte)(iIdx2 << 4 | iIdx1);
                ++o;
            }
        } else {
            byte[] abIndexes2 = new byte[aiIndexes.length];
            for (int i = 0; i < aiIndexes.length; ++i) {
                int iIdx = aiIndexes[i];
                if (iIdx >= 256) {
                    throw new IllegalArgumentException("Caller should have ensured palette index " + iIdx + " is < 256");
                }
                abIndexes2[i] = (byte)iIdx;
            }
            return abIndexes2;
        }
        return abIndexes;
    }

    @Nonnull
    private static short[] extractPalette(@Nonnull IndexColorModel icm, int iLen) {
        int[] aiPalette = new int[iLen];
        icm.getRGBs(aiPalette);
        short[] asiClut = new short[aiPalette.length];
        for (int i = 0; i < aiPalette.length; ++i) {
            asiClut[i] = PsxRgb.ARGB8888toPsxABGR1555(aiPalette[i]);
        }
        return asiClut;
    }

    @Nonnull
    private static Tim create16(@Nonnull BufferedImage bi, @Nonnull TimValidator validator) {
        int[] aiArgb = bi.getRGB(0, 0, bi.getWidth(), bi.getHeight(), null, 0, bi.getWidth());
        byte[] abTim16 = new byte[aiArgb.length * 2];
        int i = 0;
        int o = 0;
        while (i < aiArgb.length) {
            int iArgb = aiArgb[i];
            short siTimAbgr = PsxRgb.ARGB8888toPsxABGR1555(iArgb);
            IO.writeInt16LE(abTim16, o, siTimAbgr);
            ++i;
            o += 2;
        }
        return new Tim(abTim16, validator.getTimX(), validator.getTimY(), validator.getWordWidth(), validator.getPixelHeight(), 16, null);
    }

    @Nonnull
    private static Tim create24(@Nonnull BufferedImage bi, @Nonnull TimValidator validator) {
        int[] aiArgb = bi.getRGB(0, 0, bi.getWidth(), bi.getHeight(), null, 0, bi.getWidth());
        byte[] abTim24 = new byte[aiArgb.length * 3];
        int i = 0;
        int o = 0;
        while (i < aiArgb.length) {
            int iArgb = aiArgb[i];
            abTim24[o + 0] = (byte)(iArgb >> 16);
            abTim24[o + 1] = (byte)(iArgb >> 8);
            abTim24[o + 2] = (byte)iArgb;
            ++i;
            o += 3;
        }
        return new Tim(abTim24, validator.getTimX(), validator.getTimY(), validator.getWordWidth(), validator.getPixelHeight(), 24, null);
    }

    @Nonnull
    private static Tim createPalettedTim(@Nonnull BufferedImage bi, boolean bln4bppOrNot8bpp, @Nonnull TimValidator validator) {
        int iPaletteSize = bln4bppOrNot8bpp ? 16 : 256;
        int[] aiArgb = bi.getRGB(0, 0, bi.getWidth(), bi.getHeight(), null, 0, bi.getWidth());
        PaletteMaker pal = new PaletteMaker(aiArgb, iPaletteSize);
        byte[] abTimImg = bln4bppOrNot8bpp ? new byte[aiArgb.length / 2] : new byte[aiArgb.length];
        int i = 0;
        for (int o = 0; o < abTimImg.length; ++o) {
            int iPaletteIdx = pal.getPixelPaletteIndex(i);
            ++i;
            if (bln4bppOrNot8bpp) {
                iPaletteIdx |= pal.getPixelPaletteIndex(i) << 4;
                ++i;
            }
            abTimImg[o] = (byte)iPaletteIdx;
        }
        CLUT clut = pal.makeClut(validator.getClutX(), validator.getClutY());
        int iBpp = bln4bppOrNot8bpp ? 4 : 8;
        return new Tim(abTimImg, validator.getTimX(), validator.getTimY(), validator.getWordWidth(), validator.getPixelHeight(), iBpp, clut);
    }

    private static class PaletteMaker {
        @Nonnull
        public final short[] _asiPalette;
        private int _iColorCount;
        @Nonnull
        private final short[] _asiTim16Image;

        public PaletteMaker(@Nonnull int[] aiArgb, int iPaletteSize) {
            this._asiTim16Image = new short[aiArgb.length];
            for (int i = 0; i < aiArgb.length; ++i) {
                this._asiTim16Image[i] = PsxRgb.ARGB8888toPsxABGR1555(aiArgb[i]);
            }
            short[] asiSortedTim = Arrays.copyOf(this._asiTim16Image, this._asiTim16Image.length);
            Arrays.sort(asiSortedTim);
            this._asiPalette = new short[iPaletteSize];
            this._asiPalette[0] = asiSortedTim[0];
            this._iColorCount = 1;
            for (int i = 1; i < asiSortedTim.length; ++i) {
                short siColor = asiSortedTim[i];
                if (siColor == asiSortedTim[i - 1]) continue;
                this._asiPalette[this._iColorCount] = siColor;
                ++this._iColorCount;
                if (this._iColorCount <= iPaletteSize) continue;
                throw new IllegalArgumentException("Unable to fit image into " + iPaletteSize + " colors");
            }
        }

        public int getPixelPaletteIndex(int iPixelIndex) {
            short siTim16 = this._asiTim16Image[iPixelIndex];
            return Arrays.binarySearch(this._asiPalette, 0, this._iColorCount, siTim16);
        }

        @Nonnull
        public CLUT makeClut(int iClutX, int iClutY) {
            return new CLUT(this._asiPalette, iClutX, iClutY, this._asiPalette.length, 1);
        }
    }
}

