/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.tim;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import jpsxdec.psxvideo.PsxRgb;
import jpsxdec.util.IO;

class CLUT {
    public static final int HEADER_SIZE = 12;
    private final int _iClutPixelWidth;
    private final int _iClutPixelHeight;
    private final int _iClutX;
    private final int _iClutY;
    @Nonnull
    final short[] _asiColorData;

    CLUT(@Nonnull short[] asiPalette, int iX, int iY, int iPixelWidth, int iPixelHeight) {
        this._asiColorData = asiPalette;
        this._iClutX = iX;
        this._iClutY = iY;
        this._iClutPixelWidth = iPixelWidth;
        this._iClutPixelHeight = iPixelHeight;
    }

    public void write(@Nonnull OutputStream os) throws IOException {
        IO.writeInt32LE(os, (long)this.calculateClutSizeInBytes());
        IO.writeInt16LE(os, this._iClutX);
        IO.writeInt16LE(os, this._iClutY);
        IO.writeInt16LE(os, this._iClutPixelWidth);
        IO.writeInt16LE(os, this._iClutPixelHeight);
        for (short i : this._asiColorData) {
            IO.writeInt16LE(os, (int)i);
        }
    }

    private int calculateClutSizeInBytes() {
        return this._asiColorData.length * 2 + 12;
    }

    public short getColor(int iIndex) {
        return this._asiColorData[iIndex];
    }

    public int getPaletteLength() {
        return this._asiColorData.length;
    }

    public int getX() {
        return this._iClutX;
    }

    public int getY() {
        return this._iClutY;
    }

    @Nonnull
    public BufferedImage toBufferedImage() {
        BufferedImage bi = new BufferedImage(this._iClutPixelWidth, this._iClutPixelHeight, 2);
        int[] aiBufferArgb = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < aiBufferArgb.length; ++i) {
            aiBufferArgb[i] = PsxRgb.psxABGR1555toARGB8888(this._asiColorData[i], 254);
        }
        return bi;
    }

    public String toString() {
        return String.format("%dx%d xy(%d, %d) Size:%d", this._iClutPixelWidth, this._iClutPixelHeight, this._iClutX, this._iClutY, this.calculateClutSizeInBytes());
    }
}

