/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec.tojpeg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpsxdec.i18n.I;
import jpsxdec.psxvideo.mdec.Ac0Checker;
import jpsxdec.psxvideo.mdec.Calc;
import jpsxdec.psxvideo.mdec.MdecBlock;
import jpsxdec.psxvideo.mdec.MdecCode;
import jpsxdec.psxvideo.mdec.MdecContext;
import jpsxdec.psxvideo.mdec.MdecException;
import jpsxdec.psxvideo.mdec.MdecInputStream;
import jpsxdec.psxvideo.mdec.tojpeg.Component;
import jpsxdec.psxvideo.mdec.tojpeg.HuffmanTable;
import jpsxdec.psxvideo.mdec.tojpeg.JpegBitOutputStream;
import jpsxdec.util.IO;
import jpsxdec.util.Misc;

public class Mdec2Jpeg {
    private static final Logger LOG = Logger.getLogger(Mdec2Jpeg.class.getName());
    private static final int[] JPEG_QUANTIZATION_TABLE_ZIGZAG = new int[64];
    private static final int[] PSX_QUANTIZATION_TABLE_ZIGZAG = new int[64];
    private static final byte[] COMMENT_BYTES;
    private static final int SOI = 216;
    private static final int APP0 = 224;
    private static final int COM = 254;
    private static final int DQT = 219;
    static final int DHT = 196;
    private static final int SOF0 = 192;
    private static final int SOS = 218;
    private static final int EOI = 217;
    private static final int PRECISION = 8;
    private static final int NUM_COMPONENTS = 3;
    private static final int JPEG_Y_COMPONENT = 0;
    private static final int JPEG_CB_COMPONENT = 1;
    private static final int JPEG_CR_COMPONENT = 2;
    private final Component[] _aoComponents = new Component[3];
    private final int _iPixelWidth;
    private final int _iPixelHeight;
    private final int _iMacBlockWidth;
    private final int _iMacBlockHeight;
    private final int _iTotalMacBlocks;
    private final HuffmanTable[] _aoDhtTables = new HuffmanTable[]{HuffmanTable.DEFAULT_DC_LUMA_HUFFMAN, HuffmanTable.DEFAULT_DC_CHROMA_HUFFMAN, HuffmanTable.DEFAULT_AC_LUMA_HUFFMAN, HuffmanTable.DEFAULT_AC_CHROMA_HUFFMAN};
    private final HuffmanTable[] _aoDcHuffmanTables = new HuffmanTable[2];
    private final HuffmanTable[] _aoAcHuffmanTables = new HuffmanTable[2];
    private final JpegBitOutputStream _jpegStream = new JpegBitOutputStream();

    private static boolean verifyTable(int[] aiActual) {
        int[] aiExpeced = new int[]{2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 1, 1, 4, 1, 5, 6, 1, 1, 1, 4, 1, 5, 6, 1, 1, 1, 1, 1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 7, 1, 1};
        for (int i = 0; i < aiExpeced.length; ++i) {
            if (aiExpeced[MdecInputStream.REVERSE_ZIG_ZAG_LOOKUP_LIST[i]] == aiActual[i]) continue;
            return false;
        }
        return aiExpeced.length == aiActual.length;
    }

    public Mdec2Jpeg(int iPixelWidth, int iPixelHeight) {
        this._iPixelWidth = iPixelWidth;
        this._iPixelHeight = iPixelHeight;
        this._iMacBlockWidth = Calc.macroblockDim(iPixelWidth);
        this._iMacBlockHeight = Calc.macroblockDim(iPixelHeight);
        this._iTotalMacBlocks = this._iMacBlockWidth * this._iMacBlockHeight;
        this._aoComponents[0] = new Component(1, 0, 2, 2, 0, 0, this._iMacBlockWidth, this._iMacBlockHeight);
        this._aoComponents[1] = new Component(2, 0, 1, 1, 1, 1, this._iMacBlockWidth, this._iMacBlockHeight);
        this._aoComponents[2] = new Component(3, 0, 1, 1, 1, 1, this._iMacBlockWidth, this._iMacBlockHeight);
        HuffmanTable.initializeHuffmanTables(this._aoDhtTables, this._aoDcHuffmanTables, this._aoAcHuffmanTables);
    }

    public void readMdec(MdecInputStream mdecInStream) throws MdecException.TooMuchEnergy, MdecException.ReadCorruption, MdecException.EndOfStream {
        Ac0Checker cleanStream = Ac0Checker.wrapWithChecker(mdecInStream, true);
        MdecCode code = new MdecCode();
        for (Component comp : this._aoComponents) {
            Arrays.fill(comp.DctCoffZZ, 0);
            comp.WriteIndex = 0;
        }
        MdecContext context = new MdecContext(this._iMacBlockHeight);
        while (context.getTotalMacroBlocksRead() < this._iTotalMacBlocks) {
            for (MdecBlock block : MdecBlock.list()) {
                Component comp;
                comp = block == MdecBlock.Cr ? this._aoComponents[2] : (block == MdecBlock.Cb ? this._aoComponents[1] : this._aoComponents[0]);
                cleanStream.readMdecCode(code);
                comp.DctCoffZZ[comp.WriteIndex] = code.getBottom10Bits();
                int iCurrentBlockQscale = code.getTop6Bits();
                int iCurrentBlockVectorPosition = 0;
                while (!cleanStream.readMdecCode(code)) {
                    if ((iCurrentBlockVectorPosition += code.getTop6Bits() + 1) >= 64) {
                        MdecContext.MacroBlockPixel macBlkXY = context.getMacroBlockPixel();
                        throw new MdecException.ReadCorruption(MdecException.RLC_OOB_IN_MB_XY_BLOCK(iCurrentBlockVectorPosition, context.getTotalMacroBlocksRead(), macBlkXY.x, macBlkXY.y, context.getCurrentBlock().ordinal()));
                    }
                    int iJpegQScale = JPEG_QUANTIZATION_TABLE_ZIGZAG[iCurrentBlockVectorPosition];
                    int iVal = iJpegQScale == 1 ? code.getBottom10Bits() * PSX_QUANTIZATION_TABLE_ZIGZAG[iCurrentBlockVectorPosition] * iCurrentBlockQscale + 4 >> 3 : code.getBottom10Bits() * iCurrentBlockQscale;
                    if (iVal < -1023 || iVal > 1023) {
                        MdecContext.MacroBlockPixel macBlkXY = context.getMacroBlockPixel();
                        String msg = String.format("[JPG] Too much energy to encode %d in macroblock %d (%d, %d) block %d", iVal, context.getTotalMacroBlocksRead(), macBlkXY.x, macBlkXY.y, context.getCurrentBlock().ordinal());
                        LOG.log(Level.WARNING, msg);
                        throw new MdecException.TooMuchEnergy(msg);
                    }
                    comp.DctCoffZZ[comp.WriteIndex + iCurrentBlockVectorPosition] = iVal;
                    context.nextCode();
                }
                context.nextCodeEndBlock();
                comp.WriteIndex += 64;
            }
        }
        cleanStream.logIfAny0AcCoefficient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJpeg(OutputStream os) throws IOException {
        Mdec2Jpeg.writeMarker(os, 216);
        Mdec2Jpeg.writeAPP(os, 224, 1, 1, 0, 1, 1, 0, 0);
        Mdec2Jpeg.writeCOM(os, COMMENT_BYTES);
        Mdec2Jpeg.writeDQT(os, 0, JPEG_QUANTIZATION_TABLE_ZIGZAG);
        this.writeSOF(os, 192, 8, this._iPixelWidth, this._iPixelHeight);
        for (int i = 0; i < this._aoDhtTables.length; ++i) {
            HuffmanTable dhtTable = this._aoDhtTables[i];
            dhtTable.writeDHT(os);
        }
        this.writeSOS(os, 218, 0, 63);
        for (Component component : this._aoComponents) {
            component.PreviousDC = 0;
        }
        this._jpegStream.innerStream = os;
        this._jpegStream.reset();
        try {
            for (int iMbY = 0; iMbY < this._iMacBlockHeight; ++iMbY) {
                for (int iMbX = 0; iMbX < this._iMacBlockWidth; ++iMbX) {
                    for (Component comp : this._aoComponents) {
                        int iMbBlockSize = comp.HSampling * comp.VSampling;
                        int iBlockStart = (iMbX * this._iMacBlockHeight + iMbY) * iMbBlockSize * 64;
                        int[] aiBlocks = comp.DctCoffZZ;
                        for (int iBlock = 0; iBlock < iMbBlockSize; ++iBlock) {
                            this._aoDcHuffmanTables[comp.DcHuffTableIndex].encodeDcCoefficient(aiBlocks[iBlockStart], comp, this._jpegStream);
                            this._aoAcHuffmanTables[comp.AcHuffTableIndex].encodeAcCoefficients(aiBlocks, iBlockStart, this._jpegStream);
                            iBlockStart += 64;
                        }
                    }
                }
            }
            this._jpegStream.flush();
        }
        finally {
            this._jpegStream.innerStream = null;
        }
        Mdec2Jpeg.writeMarker(os, 217);
    }

    static void writeMarker(OutputStream os, int iMarker) throws IOException {
        os.write(255);
        os.write(iMarker);
    }

    private static void writeAPP(OutputStream os, int iAppMarker, int iMajorVersion, int iMinorVersion, int iUnits, int iHDpp, int iVDpp, int iThumbW, int iThumbH) throws IOException {
        Mdec2Jpeg.writeMarker(os, iAppMarker);
        IO.writeInt16BE(os, 16);
        os.write(new byte[]{74, 70, 73, 70, 0});
        os.write(iMajorVersion);
        os.write(iMinorVersion);
        os.write(iUnits);
        IO.writeInt16BE(os, iHDpp);
        IO.writeInt16BE(os, iVDpp);
        os.write(iThumbH);
        os.write(iThumbW);
    }

    private void writeSOF(OutputStream os, int iSofMarker, int iSamplePrecision, int iWidth, int iHeight) throws IOException {
        Mdec2Jpeg.writeMarker(os, iSofMarker);
        IO.writeInt16BE(os, 8 + this._aoComponents.length * 3);
        os.write(iSamplePrecision);
        IO.writeInt16BE(os, iHeight);
        IO.writeInt16BE(os, iWidth);
        os.write(this._aoComponents.length);
        for (Component comp : this._aoComponents) {
            os.write(comp.ComponentIndex);
            os.write(comp.HSampling << 4 | comp.VSampling);
            os.write(comp.QuantizationTableIndex);
        }
    }

    private static void writeDQT(OutputStream os, int iIndex, int[] aiQtable) throws IOException {
        Mdec2Jpeg.writeMarker(os, 219);
        IO.writeInt16BE(os, 67);
        if ((iIndex & 0xFFFFFFF0) != 0 || aiQtable.length != 64) {
            throw new UnsupportedOperationException("Only 8-bit precision implemented");
        }
        os.write(iIndex);
        for (int i : aiQtable) {
            if ((i & 0xFFFFFF00) != 0) {
                throw new UnsupportedOperationException("Only 8-bit precision implemented");
            }
            os.write(i);
        }
    }

    private void writeSOS(OutputStream os, int iSosMarker, int iSpectralSelectionStart, int iSpectralSelectionEnd) throws IOException {
        Mdec2Jpeg.writeMarker(os, iSosMarker);
        IO.writeInt16BE(os, 3 + this._aoComponents.length * 2 + 3);
        os.write(this._aoComponents.length);
        for (Component comp : this._aoComponents) {
            os.write(comp.ComponentIndex);
            os.write(comp.DcHuffTableIndex << 4 | comp.AcHuffTableIndex);
        }
        os.write(iSpectralSelectionStart);
        os.write(iSpectralSelectionEnd);
        os.write(0);
    }

    private static void writeCOM(OutputStream out, byte[] abComment) throws IOException {
        Mdec2Jpeg.writeMarker(out, 254);
        IO.writeInt16BE(out, 2 + abComment.length);
        out.write(abComment);
    }

    static {
        for (int i = 0; i < PSX_QUANTIZATION_TABLE_ZIGZAG.length; ++i) {
            int iQVal;
            Mdec2Jpeg.PSX_QUANTIZATION_TABLE_ZIGZAG[i] = iQVal = MdecInputStream.PSX_DEFAULT_QUANTIZATION_MATRIX[MdecInputStream.REVERSE_ZIG_ZAG_LOOKUP_LIST[i]];
            Mdec2Jpeg.JPEG_QUANTIZATION_TABLE_ZIGZAG[i] = i == 0 ? iQVal : (iQVal % 8 == 0 ? iQVal / 8 : 1);
        }
        assert (Mdec2Jpeg.verifyTable(JPEG_QUANTIZATION_TABLE_ZIGZAG));
        String comment = "Generated by " + I.JPSXDEC_VERSION_NON_COMMERCIAL("1.05 (beta)").getEnglishMessage() + " MDEC to JPEG translator";
        COMMENT_BYTES = Misc.stringToAscii(comment);
    }
}

