/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec.tojpeg;

import java.io.IOException;
import java.io.OutputStream;

class JpegBitOutputStream
extends OutputStream {
    private int _iIndex;
    private int _iNextWrite;
    public OutputStream innerStream;
    private static final int BITS_PER_WRITE = 8;

    JpegBitOutputStream() {
    }

    public void write(int iValue, int iBits) throws IOException {
        assert (iBits != 0);
        assert ((iValue & ~((1 << iBits) - 1)) == 0);
        this._iNextWrite <<= iBits;
        this._iNextWrite |= iValue;
        this._iIndex += iBits;
        while (this._iIndex > 8) {
            this.write(this._iNextWrite >> this._iIndex - 8 & 0xFF);
            this._iIndex -= 8;
        }
    }

    public void reset() {
        this._iIndex = 0;
        this._iNextWrite = 0;
    }

    @Override
    public void flush() throws IOException {
        if (this._iIndex != 0) {
            this._iNextWrite <<= 8 - this._iIndex;
            this.write(this._iNextWrite);
        }
        this.reset();
    }

    @Override
    public void write(int b) throws IOException {
        this.innerStream.write(b);
        if ((b & 0xFF) == 255) {
            this.innerStream.write(0);
        }
    }
}

