/*
 * Decompiled with CFR 0.152.
 */
package jpsxdec.psxvideo.mdec.tojpeg;

import java.io.IOException;
import java.io.OutputStream;
import jpsxdec.psxvideo.mdec.tojpeg.Component;
import jpsxdec.psxvideo.mdec.tojpeg.JpegBitOutputStream;
import jpsxdec.psxvideo.mdec.tojpeg.Mdec2Jpeg;
import jpsxdec.util.IO;

class HuffmanTable {
    private static final int DC = 0;
    private static final int AC = 1;
    public static final HuffmanTable DEFAULT_DC_LUMA_HUFFMAN = new HuffmanTable(0, 0, new int[][]{null, {0}, {1, 2, 3, 4, 5}, {6}, {7}, {8}, {9}, {10}, {11}, null, null, null, null, null, null, null});
    public static final HuffmanTable DEFAULT_DC_CHROMA_HUFFMAN = new HuffmanTable(0, 1, new int[][]{null, {0, 1, 2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, null, null, null, null, null});
    public static final HuffmanTable DEFAULT_AC_LUMA_HUFFMAN = new HuffmanTable(1, 0, new int[][]{null, {1, 2}, {3}, {0, 4, 17}, {5, 18, 33}, {49, 65}, {6, 19, 81, 97}, {7, 34, 113}, {20, 50, 129, 145, 161}, {8, 35, 66, 177, 193}, {21, 82, 209, 240}, {36, 51, 98, 114}, null, null, {130}, {9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250}});
    public static final HuffmanTable DEFAULT_AC_CHROMA_HUFFMAN = new HuffmanTable(1, 1, new int[][]{null, {0, 1}, {2}, {3, 17}, {4, 5, 33, 49}, {6, 18, 65, 81}, {7, 97, 113}, {19, 34, 50, 129}, {8, 20, 66, 145, 161, 177, 193}, {9, 35, 51, 82, 240}, {21, 98, 114, 209}, {10, 22, 36, 52}, null, {225}, {37, 241}, {23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250}});
    private static final int EOB_CODE_INDEX = 0;
    private static final int RUN16_CODE_INDEX = 240;
    private final int _iTableType;
    private final int _iTableIndex;
    private final int[][] _aaiValuesForBitLen;
    private final int[] _aiHuffCodes = new int[256];
    private final int[] _aiHuffCodesSize = new int[256];
    private final int _iDhtLength;

    public static void initializeHuffmanTables(HuffmanTable[] aoDhtTables, HuffmanTable[] aoDcHuffmanTables, HuffmanTable[] aoAcHuffmanTables) {
        for (HuffmanTable dhtTable : aoDhtTables) {
            if (dhtTable._iTableType == 0) {
                aoDcHuffmanTables[dhtTable.getIndex()] = dhtTable;
                continue;
            }
            aoAcHuffmanTables[dhtTable.getIndex()] = dhtTable;
        }
    }

    private HuffmanTable(int iType, int iIndex, int[][] aaiValuesForBitLen) {
        if (aaiValuesForBitLen.length != 16) {
            throw new IllegalArgumentException();
        }
        this._iTableType = iType;
        this._iTableIndex = iIndex;
        this._aaiValuesForBitLen = aaiValuesForBitLen;
        int iCode = 0;
        int iTableSize = 0;
        for (int iBitLen = 0; iBitLen < 16; ++iBitLen) {
            int[] aiValues = this._aaiValuesForBitLen[iBitLen];
            if (aiValues != null) {
                iTableSize += aiValues.length;
                for (int iValue : aiValues) {
                    this._aiHuffCodesSize[iValue] = iBitLen + 1;
                    this._aiHuffCodes[iValue] = iCode++;
                }
            }
            iCode <<= 1;
        }
        this._iDhtLength = 19 + iTableSize;
    }

    public int getIndex() {
        return this._iTableIndex;
    }

    public void writeDHT(OutputStream out) throws IOException {
        Mdec2Jpeg.writeMarker(out, 196);
        IO.writeInt16BE(out, this._iDhtLength);
        out.write(this._iTableType << 4 | this._iTableIndex);
        for (int[] i : this._aaiValuesForBitLen) {
            out.write(i == null ? 0 : i.length);
        }
        for (int[] i : this._aaiValuesForBitLen) {
            if (i == null) continue;
            for (int j : i) {
                out.write(j);
            }
        }
    }

    public void encodeDcCoefficient(int iDc, Component comp, JpegBitOutputStream out) throws IOException {
        int iDcDiff = iDc - comp.PreviousDC;
        comp.PreviousDC = iDc;
        if (iDcDiff < 0) {
            int iAbsDcDiff = -iDcDiff;
            int iBitSize = HuffmanTable.highest1bitPosition(iAbsDcDiff);
            assert (iBitSize <= 11);
            out.write(this._aiHuffCodes[iBitSize], this._aiHuffCodesSize[iBitSize]);
            int iAbsDcDiffMask = (1 << iBitSize) - 1;
            out.write(0xFFFFFF - iAbsDcDiff & iAbsDcDiffMask, iBitSize);
        } else {
            int iBitSize = HuffmanTable.highest1bitPosition(iDcDiff);
            assert (iBitSize <= 11);
            out.write(this._aiHuffCodes[iBitSize], this._aiHuffCodesSize[iBitSize]);
            if (iBitSize != 0) {
                out.write(iDcDiff, iBitSize);
            }
        }
    }

    public void encodeAcCoefficients(int[] aiDctCoffs, int iBlockStart, JpegBitOutputStream out) throws IOException {
        int iZeroRun = 0;
        for (int i = 1; i < 64; ++i) {
            int iBitCount;
            int iAc = aiDctCoffs[iBlockStart + i];
            if (iAc == 0) {
                if (i == 63) {
                    out.write(this._aiHuffCodes[0], this._aiHuffCodesSize[0]);
                    continue;
                }
                ++iZeroRun;
                continue;
            }
            while (iZeroRun > 15) {
                out.write(this._aiHuffCodes[240], this._aiHuffCodesSize[240]);
                iZeroRun -= 16;
            }
            if (iAc < 0) {
                iBitCount = HuffmanTable.highest1bitPosition(-iAc);
                iAc = 0xFFFFFF + iAc & (1 << iBitCount) - 1;
            } else {
                iBitCount = HuffmanTable.highest1bitPosition(iAc);
            }
            assert (iBitCount <= 10);
            int iCode = iZeroRun << 4 | iBitCount;
            out.write(this._aiHuffCodes[iCode], this._aiHuffCodesSize[iCode]);
            out.write(iAc, iBitCount);
            iZeroRun = 0;
        }
    }

    private static int highest1bitPosition(int i) {
        return 32 - Integer.numberOfLeadingZeros(i);
    }
}

